/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.jdr.regarima;

import ec.tstoolkit.Parameter;
import ec.tstoolkit.ParameterType;
import ec.tstoolkit.arima.estimation.Forecasts;
import ec.tstoolkit.information.RegressionItem;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.modelling.ComponentType;
import ec.tstoolkit.modelling.DefaultTransformationType;
import ec.tstoolkit.modelling.arima.LogForecasts;
import ec.tstoolkit.modelling.arima.PreadjustmentType;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.timeseries.calendars.LengthOfPeriodType;
import ec.tstoolkit.timeseries.regression.ICalendarVariable;
import ec.tstoolkit.timeseries.regression.IEasterVariable;
import ec.tstoolkit.timeseries.regression.ILengthOfPeriodVariable;
import ec.tstoolkit.timeseries.regression.IMovingHolidayVariable;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.regression.ITradingDaysVariable;
import ec.tstoolkit.timeseries.regression.OutlierType;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.util.ArrayList;
import jd2.information.InformationExtractor;
import jd2.information.InformationMapping;
import lombok.Generated;

public final class RegArimaInfo {
    public static final int FCAST_YEAR = 1;
    public static final String LOG = "log";
    public static final String ADJUST = "adjust";
    public static final String SPAN = "span";
    public static final String ESPAN = "espan";
    public static final String START = "start";
    public static final String END = "end";
    public static final String N = "n";
    public static final String REGRESSION = "regression";
    public static final String EASTER = "easter";
    public static final String FULLRES = "fullresiduals";
    public static final String FCASTS = "fcasts";
    public static final String EFCASTS = "efcasts";
    public static final String BCASTS = "bcasts";
    public static final String LIN_FCASTS = "lin_fcasts";
    public static final String LIN_BCASTS = "lin_bcasts";
    public static final String NTD = "ntd";
    public static final String NMH = "nmh";
    public static final String TD = "td";
    public static final String LP = "lp";
    public static final String OUT = "out";
    public static final String NOUT = "nout";
    public static final String NOUTAO = "noutao";
    public static final String NOUTLS = "noutls";
    public static final String NOUTTC = "nouttc";
    public static final String NOUTSO = "noutso";
    public static final String COEFF = "coefficients";
    public static final String COVAR = "covar";
    public static final String COEFFDESC = "description";
    public static final String PCOVAR = "pcovar";
    static final InformationMapping<PreprocessingModel> MAPPING = new InformationMapping<PreprocessingModel>(PreprocessingModel.class);

    public static InformationMapping<PreprocessingModel> getMapping() {
        return MAPPING;
    }

    private static int nperiods(PreprocessingModel m, int n) {
        if (n >= 0) {
            return n;
        }
        return -n * m.getFrequency().intValue();
    }

    private static TsData reg(PreprocessingModel model, ComponentType componentType, boolean fcast) {
        TsData tmp = model.userEffect(RegArimaInfo.domain(model, fcast), componentType);
        if (tmp == null) {
            return null;
        }
        model.backTransform(tmp, false, false);
        return tmp;
    }

    private static TsData reg(PreprocessingModel model, boolean fcast) {
        TsData tmp = model.userEffect(RegArimaInfo.domain(model, fcast));
        if (tmp == null) {
            return null;
        }
        model.backTransform(tmp, false, false);
        return tmp;
    }

    private static TsDomain domain(PreprocessingModel model, boolean fcast) {
        if (fcast) {
            TsDomain dom = model.description.getSeriesDomain();
            return new TsDomain(dom.getEnd(), 1 * dom.getFrequency().intValue());
        }
        return model.description.getSeriesDomain();
    }

    private static TsData outlier(PreprocessingModel model, ComponentType componentType, boolean fcast) {
        TsData tmp = model.outliersEffect(RegArimaInfo.domain(model, fcast), componentType);
        if (tmp == null) {
            return null;
        }
        model.backTransform(tmp, false, false);
        return tmp;
    }

    private static TsData tde(PreprocessingModel model, boolean fcast) {
        TsDomain fdom = RegArimaInfo.domain(model, fcast);
        TsData tmp = model.tradingDaysEffect(fdom);
        if (tmp == null) {
            return null;
        }
        model.backTransform(tmp, false, true);
        return tmp;
    }

    private static TsData ycal(PreprocessingModel model, boolean fcast) {
        return RegArimaInfo.inv_op(model, fcast ? model.forecast(1 * model.description.getFrequency(), false) : model.interpolatedSeries(false), RegArimaInfo.cal(model, fcast));
    }

    private static TsData omhe(PreprocessingModel model, boolean fcast) {
        TsData tmp = RegArimaInfo.inv_op(model, RegArimaInfo.mhe(model, fcast), RegArimaInfo.ee(model, fcast));
        if (tmp == null) {
            return null;
        }
        return tmp;
    }

    private static TsData mhe(PreprocessingModel model, boolean fcast) {
        TsData tmp = model.movingHolidaysEffect(RegArimaInfo.domain(model, fcast));
        if (tmp == null) {
            return null;
        }
        model.backTransform(tmp, false, false);
        return tmp;
    }

    private static TsData ee(PreprocessingModel model, boolean fcast) {
        TsData tmp = model.deterministicEffect(RegArimaInfo.domain(model, fcast), IEasterVariable.class);
        if (tmp == null) {
            return null;
        }
        model.backTransform(tmp, false, false);
        return tmp;
    }

    private static TsData det(PreprocessingModel model, boolean fcast) {
        TsData tmp = model.deterministicEffect(RegArimaInfo.domain(model, fcast));
        if (tmp == null) {
            return null;
        }
        model.backTransform(tmp, false, true);
        return tmp;
    }

    private static TsData cal(PreprocessingModel model, boolean fcast) {
        TsData tmp = RegArimaInfo.op(model, RegArimaInfo.tde(model, fcast), RegArimaInfo.mhe(model, fcast));
        if (tmp == null) {
            return null;
        }
        return tmp;
    }

    private static TsData op(PreprocessingModel model, TsData l, TsData r) {
        if (model.description.getTransformation() == DefaultTransformationType.Log) {
            return TsData.multiply((TsData)l, (TsData)r);
        }
        return TsData.add((TsData)l, (TsData)r);
    }

    private static TsData inv_op(PreprocessingModel model, TsData l, TsData r) {
        if (model.description.getTransformation() == DefaultTransformationType.Log) {
            return TsData.divide((TsData)l, (TsData)r);
        }
        return TsData.subtract((TsData)l, (TsData)r);
    }

    private static TsData forecastError(PreprocessingModel model) {
        double[] ef;
        TsDomain fdomain = RegArimaInfo.domain(model, true);
        Forecasts fcasts = model.forecasts(fdomain.getLength());
        if (model.isMultiplicative()) {
            LogForecasts lf = new LogForecasts(fcasts);
            ef = lf.getForecastStdevs();
        } else {
            ef = fcasts.getForecastStdevs();
        }
        return new TsData(fdomain.getStart(), ef, true);
    }

    @Generated
    private RegArimaInfo() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        MAPPING.set(InformationExtractor.concatenate(SPAN, START), TsPeriod.class, source -> source.description.getSeriesDomain().getStart());
        MAPPING.set(InformationExtractor.concatenate(SPAN, END), TsPeriod.class, source -> source.description.getSeriesDomain().getLast());
        MAPPING.set(InformationExtractor.concatenate(SPAN, N), Integer.class, source -> source.description.getSeriesDomain().getLength());
        MAPPING.set(InformationExtractor.concatenate(ESPAN, START), TsPeriod.class, source -> source.description.getEstimationDomain().getStart());
        MAPPING.set(InformationExtractor.concatenate(ESPAN, END), TsPeriod.class, source -> source.description.getEstimationDomain().getLast());
        MAPPING.set(InformationExtractor.concatenate(ESPAN, N), Integer.class, source -> source.description.getEstimationDomain().getLength());
        MAPPING.set(LOG, Boolean.class, source -> source.isMultiplicative());
        MAPPING.set(ADJUST, Boolean.class, source -> {
            if (source.description.getPreadjustmentType() == PreadjustmentType.None) {
                return null;
            }
            return source.description.getLengthOfPeriodType() != LengthOfPeriodType.None;
        });
        MAPPING.set("y", TsData.class, source -> source.description.getOriginal());
        MAPPING.set("y_f", TsData.class, source -> source.forecast(1 * source.description.getFrequency(), false));
        MAPPING.set("y_ef", TsData.class, source -> RegArimaInfo.forecastError(source));
        MAPPING.set("yc", TsData.class, source -> source.interpolatedSeries(false));
        MAPPING.set("yc_f", TsData.class, source -> source.forecast(1 * source.description.getFrequency(), false));
        MAPPING.set("yc_ef", TsData.class, source -> RegArimaInfo.forecastError(source));
        MAPPING.set("l", TsData.class, source -> source.linearizedSeries(false));
        MAPPING.set("y_lin", TsData.class, source -> source.linearizedSeries(true));
        MAPPING.set("y_lin_f", TsData.class, source -> source.linearizedForecast(RegArimaInfo.domain(source, true).getLength(), true));
        MAPPING.set("ycal", TsData.class, source -> RegArimaInfo.ycal(source, false));
        MAPPING.set("ycal_f", TsData.class, source -> RegArimaInfo.ycal(source, true));
        MAPPING.set("det", TsData.class, source -> RegArimaInfo.det(source, false));
        MAPPING.set("det_f", TsData.class, source -> RegArimaInfo.det(source, true));
        MAPPING.set("l_f", TsData.class, source -> source.linearizedForecast(1 * source.description.getFrequency()));
        MAPPING.set("l_b", TsData.class, source -> source.linearizedBackcast(source.description.getFrequency()));
        MAPPING.set("cal", TsData.class, source -> RegArimaInfo.cal(source, false));
        MAPPING.set("cal_f", TsData.class, source -> RegArimaInfo.cal(source, true));
        MAPPING.set("tde", TsData.class, source -> RegArimaInfo.tde(source, false));
        MAPPING.set("tde_f", TsData.class, source -> RegArimaInfo.tde(source, true));
        MAPPING.set("mhe", TsData.class, source -> RegArimaInfo.mhe(source, false));
        MAPPING.set("mhe_f", TsData.class, source -> RegArimaInfo.mhe(source, true));
        MAPPING.set("ee", TsData.class, source -> RegArimaInfo.ee(source, false));
        MAPPING.set("ee_f", TsData.class, source -> RegArimaInfo.ee(source, true));
        MAPPING.set("omhe", TsData.class, source -> RegArimaInfo.omhe(source, false));
        MAPPING.set("omhe_f", TsData.class, source -> RegArimaInfo.omhe(source, true));
        MAPPING.set(OUT, TsData.class, source -> RegArimaInfo.outlier(source, ComponentType.Undefined, false));
        MAPPING.set("out_f", TsData.class, source -> RegArimaInfo.outlier(source, ComponentType.Undefined, true));
        MAPPING.set("out_i", TsData.class, source -> RegArimaInfo.outlier(source, ComponentType.Irregular, false));
        MAPPING.set("out_i_f", TsData.class, source -> RegArimaInfo.outlier(source, ComponentType.Irregular, true));
        MAPPING.set("out_t", TsData.class, source -> RegArimaInfo.outlier(source, ComponentType.Trend, false));
        MAPPING.set("out_t_f", TsData.class, source -> RegArimaInfo.outlier(source, ComponentType.Trend, true));
        MAPPING.set("out_s", TsData.class, source -> RegArimaInfo.outlier(source, ComponentType.Seasonal, false));
        MAPPING.set("out_s_f", TsData.class, source -> RegArimaInfo.outlier(source, ComponentType.Seasonal, true));
        MAPPING.set("reg", TsData.class, source -> RegArimaInfo.reg(source, false));
        MAPPING.set("reg_f", TsData.class, source -> RegArimaInfo.reg(source, true));
        MAPPING.set("reg_t", TsData.class, source -> RegArimaInfo.reg(source, ComponentType.Trend, false));
        MAPPING.set("reg_t_f", TsData.class, source -> RegArimaInfo.reg(source, ComponentType.Trend, true));
        MAPPING.set("reg_s", TsData.class, source -> RegArimaInfo.reg(source, ComponentType.Seasonal, false));
        MAPPING.set("reg_s_f", TsData.class, source -> RegArimaInfo.reg(source, ComponentType.Seasonal, true));
        MAPPING.set("reg_i", TsData.class, source -> RegArimaInfo.reg(source, ComponentType.Irregular, false));
        MAPPING.set("reg_i_f", TsData.class, source -> RegArimaInfo.reg(source, ComponentType.Irregular, true));
        MAPPING.set("reg_sa", TsData.class, source -> RegArimaInfo.reg(source, ComponentType.SeasonallyAdjusted, false));
        MAPPING.set("reg_sa_f", TsData.class, source -> RegArimaInfo.reg(source, ComponentType.SeasonallyAdjusted, true));
        MAPPING.set("reg_y", TsData.class, source -> RegArimaInfo.reg(source, ComponentType.Series, false));
        MAPPING.set("reg_y_f", TsData.class, source -> RegArimaInfo.reg(source, ComponentType.Series, true));
        MAPPING.set("reg_u", TsData.class, source -> RegArimaInfo.reg(source, ComponentType.Undefined, false));
        MAPPING.set("reg_u_f", TsData.class, source -> RegArimaInfo.reg(source, ComponentType.Undefined, true));
        MAPPING.set(FULLRES, TsData.class, source -> source.getFullResiduals());
        MAPPING.set(LP, RegressionItem.class, source -> source.getRegressionItem(ILengthOfPeriodVariable.class, 0));
        MAPPING.set(NTD, Integer.class, source -> source.description.countRegressors(var -> var.status.isSelected() && var.getVariable() instanceof ICalendarVariable));
        MAPPING.set(NMH, Integer.class, source -> source.description.countRegressors(var -> var.status.isSelected() && var.getVariable() instanceof IMovingHolidayVariable));
        MAPPING.setArray(TD, 1, 15, RegressionItem.class, (source, i) -> source.getRegressionItem(ITradingDaysVariable.class, i - 1));
        MAPPING.set(EASTER, RegressionItem.class, source -> source.getRegressionItem(IEasterVariable.class, 0));
        MAPPING.set(NOUT, Integer.class, source -> source.description.getOutliers().size() + source.description.getPrespecifiedOutliers().size());
        MAPPING.set(NOUTAO, Integer.class, source -> {
            TsVariableList vars = source.description.buildRegressionVariables();
            return vars.select(OutlierType.AO).getItemsCount();
        });
        MAPPING.set(NOUTLS, Integer.class, source -> {
            TsVariableList vars = source.description.buildRegressionVariables();
            return vars.select(OutlierType.LS).getItemsCount();
        });
        MAPPING.set(NOUTTC, Integer.class, source -> {
            TsVariableList vars = source.description.buildRegressionVariables();
            return vars.select(OutlierType.TC).getItemsCount();
        });
        MAPPING.set(NOUTSO, Integer.class, source -> {
            TsVariableList vars = source.description.buildRegressionVariables();
            return vars.select(OutlierType.SO).getItemsCount();
        });
        MAPPING.setArray(OUT, 1, 31, RegressionItem.class, (source, i) -> source.getRegressionItem(IOutlierVariable.class, i - 1));
        MAPPING.set(COEFF, Parameter[].class, source -> {
            double[] c = source.estimation.getLikelihood().getB();
            if (c == null) {
                return new Parameter[0];
            }
            Parameter[] C = new Parameter[c.length];
            double[] e = source.estimation.getLikelihood().getBSer(true, source.description.getArimaComponent().getFreeParametersCount());
            for (int i = 0; i < C.length; ++i) {
                Parameter p = new Parameter(c[i], ParameterType.Estimated);
                p.setStde(e[i]);
                C[i] = p;
            }
            return C;
        });
        MAPPING.set(COEFFDESC, String[].class, source -> {
            int[] missings;
            ArrayList<String> str = new ArrayList<String>();
            if (source.description.isEstimatedMean()) {
                str.add("Mean");
            }
            if ((missings = source.description.getMissingValues()) != null) {
                for (int i = 0; i < missings.length; ++i) {
                    int pos = missings[i];
                    TsPeriod period = source.description.getEstimationDomain().get(pos);
                    str.add("Missing: " + period.toString());
                }
            }
            TsPeriod items = source.description.buildRegressionVariables().items();
            TsFrequency context = source.description.getEstimationDomain().getFrequency();
            for (TsPeriod var : items) {
                for (int j = 0; j < var.getDim(); ++j) {
                    str.add(var.getItemDescription(j, context));
                }
            }
            String[] desc = new String[str.size()];
            return str.toArray(desc);
        });
        MAPPING.set(COVAR, Matrix.class, source -> source.estimation.getLikelihood().getBVar(true, source.description.getArimaComponent().getFreeParametersCount()));
        MAPPING.set(PCOVAR, Matrix.class, source -> source.estimation.getParametersCovariance());
        MAPPING.setArray(FCASTS, -2, TsData.class, (source, i) -> source.forecast(RegArimaInfo.nperiods(source, i), false));
        MAPPING.setArray(BCASTS, -2, TsData.class, (source, i) -> source.backcast(RegArimaInfo.nperiods(source, i), false));
        MAPPING.setArray(LIN_FCASTS, -2, TsData.class, (source, i) -> source.linearizedForecast(RegArimaInfo.nperiods(source, i)));
        MAPPING.setArray(LIN_BCASTS, -2, TsData.class, (source, i) -> source.linearizedBackcast(RegArimaInfo.nperiods(source, i)));
        MAPPING.setArray(EFCASTS, -2, TsData.class, (source, i) -> {
            double[] ef;
            int np = RegArimaInfo.nperiods(source, i);
            TsDomain fdomain = new TsDomain(source.description.getSeriesDomain().getEnd(), np);
            Forecasts fcasts = source.forecasts(np);
            if (source.isMultiplicative()) {
                LogForecasts lf = new LogForecasts(fcasts);
                ef = lf.getForecastStdevs();
            } else {
                ef = fcasts.getForecastStdevs();
            }
            return new TsData(fdomain.getStart(), ef, true);
        });
    }
}

