/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.jdr.x11;

import ec.satoolkit.DecompositionMode;
import ec.satoolkit.x11.IX11Toolkit;
import ec.satoolkit.x11.Mstatistics;
import ec.satoolkit.x11.X11Kernel;
import ec.satoolkit.x11.X11Results;
import ec.satoolkit.x11.X11Specification;
import ec.satoolkit.x11.X11Toolkit;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.jdr.x11.MstatisticsInfo;
import ec.tstoolkit.jdr.x11.X11DecompositionInfo;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.util.LinkedHashMap;
import java.util.Map;
import jd2.algorithm.IProcResults;
import jd2.information.InformationMapping;
import lombok.Generated;

public class X11Monitor {
    public static Results process(TsData s, X11Specification spec) {
        X11Toolkit toolkit = X11Toolkit.create((X11Specification)spec);
        X11Kernel kernel = new X11Kernel();
        kernel.setToolkit((IX11Toolkit)toolkit);
        X11Results x11 = kernel.process(s);
        Mstatistics mstatistics = Mstatistics.computeFromX11((DecompositionMode)spec.getMode(), (InformationSet)x11.getInformation());
        return new Results(spec.clone(), x11, mstatistics);
    }

    public static final class Results
    implements IProcResults {
        private final X11Specification spec;
        private final X11Results decomposition;
        private final Mstatistics mstatistics;
        static final InformationMapping<Results> MAPPING = new InformationMapping<Results>(Results.class);

        public InformationMapping<Results> getMapping() {
            return MAPPING;
        }

        @Override
        public boolean contains(String id) {
            return MAPPING.contains(id);
        }

        @Override
        public Map<String, Class> getDictionary() {
            LinkedHashMap<String, Class> dic = new LinkedHashMap<String, Class>();
            MAPPING.fillDictionary(null, dic, true);
            return dic;
        }

        @Override
        public <T> T getData(String id, Class<T> tclass) {
            return MAPPING.getData(this, id, tclass);
        }

        @Generated
        public Results(X11Specification spec, X11Results decomposition, Mstatistics mstatistics) {
            this.spec = spec;
            this.decomposition = decomposition;
            this.mstatistics = mstatistics;
        }

        @Generated
        public X11Specification getSpec() {
            return this.spec;
        }

        @Generated
        public X11Results getDecomposition() {
            return this.decomposition;
        }

        @Generated
        public Mstatistics getMstatistics() {
            return this.mstatistics;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Results)) {
                return false;
            }
            Results other = (Results)o;
            X11Specification this$spec = this.getSpec();
            X11Specification other$spec = other.getSpec();
            if (this$spec == null ? other$spec != null : !this$spec.equals(other$spec)) {
                return false;
            }
            X11Results this$decomposition = this.getDecomposition();
            X11Results other$decomposition = other.getDecomposition();
            if (this$decomposition == null ? other$decomposition != null : !this$decomposition.equals(other$decomposition)) {
                return false;
            }
            Mstatistics this$mstatistics = this.getMstatistics();
            Mstatistics other$mstatistics = other.getMstatistics();
            return !(this$mstatistics == null ? other$mstatistics != null : !this$mstatistics.equals(other$mstatistics));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            X11Specification $spec = this.getSpec();
            result = result * 59 + ($spec == null ? 43 : $spec.hashCode());
            X11Results $decomposition = this.getDecomposition();
            result = result * 59 + ($decomposition == null ? 43 : $decomposition.hashCode());
            Mstatistics $mstatistics = this.getMstatistics();
            result = result * 59 + ($mstatistics == null ? 43 : $mstatistics.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "X11Monitor.Results(spec=" + this.getSpec() + ", decomposition=" + this.getDecomposition() + ", mstatistics=" + this.getMstatistics() + ")";
        }

        static {
            MAPPING.delegate("diagnostics", MstatisticsInfo.getMapping(), source -> source.getMstatistics());
            MAPPING.delegate("decomposition", X11DecompositionInfo.getMapping(), source -> source.getDecomposition());
        }
    }
}

