/*
 * Decompiled with CFR 0.152.
 */
package jd2.workspace.file;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import jd2.workspace.Workspace;
import jd2.workspace.WorkspaceItem;
import jd2.workspace.file.FamilyHandler;
import jd2.workspace.file.FileFormat;
import jd2.workspace.file.FileWorkspaceImpl;
import jd2.workspace.io.IoUtil;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface FileWorkspace
extends Workspace {
    public @NonNull FileFormat getFileFormat() throws IOException;

    public @NonNull Path getFile() throws IOException;

    public @NonNull Path getRootFolder() throws IOException;

    public @NonNull Path getFile(@NonNull WorkspaceItem var1) throws IOException;

    public static @NonNull FileWorkspace create(@NonNull Path file, @NonNull FileFormat format) throws IOException {
        return FileWorkspaceImpl.create(file, format, IoUtil.supplierOfServiceLoader(FamilyHandler.class));
    }

    public static @NonNull FileWorkspace open(@NonNull Path file) throws IOException {
        return FileWorkspace.open(file, FileWorkspace.probeFormat(file).orElseThrow(() -> new IOException("Cannot probe workspace file format of '" + file + "'")));
    }

    public static @NonNull FileWorkspace open(@NonNull Path file, @NonNull FileFormat format) throws IOException {
        return FileWorkspaceImpl.open(file, format, IoUtil.supplierOfServiceLoader(FamilyHandler.class));
    }

    public static @NonNull Optional<FileFormat> probeFormat(@NonNull Path file) throws IOException {
        return FileWorkspaceImpl.probeFormat(file);
    }
}

