/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.diagnostics;

import ec.satoolkit.diagnostics.Item;
import ec.tstoolkit.dstats.Chi2;
import ec.tstoolkit.dstats.TestType;
import ec.tstoolkit.stats.StatisticalTest;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.util.Arrays;

public class KruskalWallisTest
extends StatisticalTest {
    public KruskalWallisTest(TsData tsdata) {
        int freq = tsdata.getFrequency().intValue();
        if (freq <= 1) {
            return;
        }
        int pos = tsdata.getStart().getPosition();
        double[] data = tsdata.internalStorage();
        Object[] items = new Item[data.length];
        int N = 0;
        int[] nk = new int[freq];
        int j = 0;
        for (int i = 0; i < items.length; ++i) {
            double d = data[i];
            if (!Double.isFinite(d)) continue;
            int k = (pos + i) % freq;
            items[j++] = new Item(k, d);
            int n = k;
            nk[n] = nk[n] + 1;
        }
        N = j;
        Arrays.sort(items, 0, N);
        double[] S = new double[freq];
        int i = 0;
        while (i < N) {
            int j1;
            int j0 = i;
            for (j1 = i + 1; j1 < N && ((Item)items[j0]).val == ((Item)items[j1]).val; ++j1) {
            }
            int n = j1 - j0;
            if (n == 1) {
                int n2 = ((Item)items[i]).pos;
                S[n2] = S[n2] + (double)(i + 1);
            } else {
                double dpos = (double)j0 + 0.5 * (double)(n + 1);
                for (int jcur = j0; jcur < j1; ++jcur) {
                    int n3 = ((Item)items[jcur]).pos;
                    S[n3] = S[n3] + dpos;
                }
            }
            i = j1;
        }
        double h = 0.0;
        for (int i2 = 0; i2 < freq; ++i2) {
            h += S[i2] * S[i2] / (double)nk[i2];
        }
        h = 12.0 * h / (double)(N * (N + 1)) - (double)(3 * (N + 1));
        Chi2 chi2 = new Chi2();
        chi2.setDegreesofFreedom(freq - 1);
        this.m_dist = chi2;
        this.m_type = TestType.Upper;
        this.m_val = h;
    }
}

