/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.diagnostics;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.dstats.F;
import ec.tstoolkit.dstats.TestType;
import ec.tstoolkit.stats.StatisticalTest;
import ec.tstoolkit.timeseries.simplets.PeriodIterator;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDataBlock;

public class SeasonalityTest
extends StatisticalTest {
    private double m_ssr;
    private double m_ssm;
    private int m_dfm;
    private int m_dfr;

    public static SeasonalityTest evolutiveSeasonality(TsData ts, boolean mul) {
        int i;
        int i2;
        double xbar = mul ? 1.0 : 0.0;
        PeriodIterator bi = PeriodIterator.fullYears(ts);
        int freq = ts.getFrequency().intValue();
        double[] mc = new double[freq];
        if (!bi.hasMoreElements()) {
            return null;
        }
        TsDataBlock cur = bi.nextElement();
        int yy = cur.data.getLength();
        double[] my = new double[yy];
        double m = 0.0;
        double[] tmp = new double[yy * freq];
        int f = cur.start.minus(ts.getStart());
        double[] pdata = ts.internalStorage();
        for (i2 = 0; i2 < tmp.length; ++i2) {
            tmp[i2] = Math.abs(pdata[f++] - xbar);
        }
        int mm = 0;
        for (i2 = 0; i2 < yy; ++i2) {
            int j = 0;
            while (j < freq) {
                int n = j++;
                mc[n] = mc[n] + tmp[mm];
                int n2 = i2;
                my[n2] = my[n2] + tmp[mm];
                ++mm;
            }
            m += my[i2];
        }
        m /= (double)(freq * yy);
        i2 = 0;
        while (i2 < freq) {
            int n = i2++;
            mc[n] = mc[n] / (double)yy;
        }
        i2 = 0;
        while (i2 < yy) {
            int n = i2++;
            my[n] = my[n] / (double)freq;
        }
        double ss = 0.0;
        double ssa = 0.0;
        double ssb = 0.0;
        int ll = 0;
        for (i = 0; i < yy; ++i) {
            int j = 0;
            while (j < freq) {
                ss += (tmp[ll] - m) * (tmp[ll] - m);
                ++j;
                ++ll;
            }
        }
        for (i = 0; i < yy; ++i) {
            ssb += (my[i] - m) * (my[i] - m);
        }
        ssb *= (double)freq;
        for (i = 0; i < freq; ++i) {
            ssa += (mc[i] - m) * (mc[i] - m);
        }
        double ssr = ss - (ssa *= (double)yy) - ssb;
        if (ssr < 0.0) {
            ssr = 0.0;
        }
        SeasonalityTest sr = new SeasonalityTest(ssb, yy - 1, ssr, (yy - 1) * (freq - 1));
        return sr;
    }

    public static SeasonalityTest stableSeasonality(TsData ts) {
        double[] pdata = ts.internalStorage();
        double mm = 0.0;
        for (int i = 0; i < pdata.length; ++i) {
            mm += pdata[i];
        }
        mm /= (double)pdata.length;
        double SSQ = 0.0;
        for (int i = 0; i < pdata.length; ++i) {
            SSQ += (pdata[i] - mm) * (pdata[i] - mm);
        }
        PeriodIterator bi = new PeriodIterator(ts);
        double SSM = 0.0;
        while (bi.hasMoreElements()) {
            TsDataBlock block = bi.nextElement();
            DataBlock rc = block.data;
            double mmj = rc.sum() / (double)rc.getLength();
            SSM += (mmj - mm) * (mmj - mm) * (double)rc.getLength();
        }
        double SSR = SSQ - SSM;
        if (SSR < 0.0) {
            SSR = 0.0;
        }
        int freq = ts.getFrequency().intValue();
        SeasonalityTest st = new SeasonalityTest(SSM, freq - 1, SSR, pdata.length - freq);
        return st;
    }

    SeasonalityTest(double SSM, int dfm, double SSR, int dfr2) {
        this.m_ssm = SSM;
        this.m_ssr = SSR;
        this.m_dfm = dfm;
        this.m_dfr = dfr2;
        F f = new F();
        f.setDFNum(this.m_dfm);
        f.setDFDenom(this.m_dfr);
        this.m_dist = f;
        this.m_val = this.m_ssm / (double)this.m_dfm * ((double)this.m_dfr / this.m_ssr);
        this.m_type = TestType.Upper;
    }

    public int getDFInterPeriod() {
        return this.m_dfm;
    }

    public int getDFResidual() {
        return this.m_dfr;
    }

    public int getDFTot() {
        return this.m_dfm + this.m_dfr;
    }

    public double getSSM() {
        return this.m_ssm;
    }

    public double getSSQ() {
        return this.m_ssr + this.m_ssm;
    }

    public double getSSR() {
        return this.m_ssr;
    }
}

