/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.seats;

import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.estimation.LikelihoodStatistics;
import ec.tstoolkit.arima.estimation.RegArimaEstimation;
import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.eco.ConcentratedLikelihood;
import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.modelling.arima.tramo.SeasonalityDetector;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.timeseries.simplets.TsData;

public class SeatsModel {
    private final TsData series;
    private boolean meanCorrection;
    private SarimaModel model;
    private double ser;
    private IArimaModel noisyModel;
    private final boolean hasSeas;
    private boolean cutoff;
    private boolean changed;
    private Complex[] arRoots;
    private Complex[] maRoots;

    public SeatsModel(TsData series, SarimaModel model, boolean meanCorrection) {
        this.series = series;
        this.model = model;
        this.meanCorrection = meanCorrection;
        SeasonalityDetector detector = new SeasonalityDetector();
        this.hasSeas = detector.hasSeasonality(series);
    }

    public boolean hasSignificantSeasonality() {
        return this.hasSeas;
    }

    public SarimaModel getSarima() {
        return this.model;
    }

    public Complex[] getAutoRegressiveRoots() {
        if (this.arRoots == null) {
            this.arRoots = this.model == null ? new Complex[0] : this.model.getRegularAR().roots();
        }
        return this.arRoots;
    }

    public Complex[] getMovingAverageRoots() {
        if (this.maRoots == null) {
            this.maRoots = this.model == null ? new Complex[0] : this.model.getRegularMA().roots();
        }
        return this.maRoots;
    }

    public IArimaModel getArima() {
        if (this.noisyModel == null) {
            return this.model;
        }
        return this.noisyModel;
    }

    public RegArimaModel<SarimaModel> getRegarima() {
        RegArimaModel<SarimaModel> regarima = new RegArimaModel<SarimaModel>(this.model, new DataBlock(this.series.internalStorage()));
        regarima.setMeanCorrection(this.meanCorrection);
        return regarima;
    }

    public double getSer() {
        if (this.ser == 0.0) {
            this.computeSer();
        }
        return this.ser;
    }

    public void setSer(double value) {
        this.ser = value;
    }

    public TsData getSeries() {
        return this.series;
    }

    public boolean isMeanCorrection() {
        return this.meanCorrection;
    }

    public void setMeanCorrection(boolean meanCorrection) {
        this.meanCorrection = meanCorrection;
    }

    public void setModel(SarimaModel model) {
        this.model = model;
        this.ser = 0.0;
        this.noisyModel = null;
    }

    public void setCutOff(boolean co) {
        this.cutoff = co;
    }

    public boolean isCutOff() {
        return this.cutoff;
    }

    public void setChanged(boolean c) {
        this.changed = c;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setModelSpecification(SarimaSpecification spec) {
        this.setModel(new SarimaModel(spec));
    }

    public void setNoisyModel(IArimaModel model) {
        this.noisyModel = model;
        this.ser = 0.0;
    }

    public IArimaModel getNoisyModel() {
        return this.noisyModel;
    }

    private void computeSer() {
        if (this.noisyModel == null) {
            RegArimaModel<SarimaModel> regarima = this.getRegarima();
            ConcentratedLikelihood ll = regarima.computeLikelihood();
            RegArimaEstimation<SarimaModel> est = new RegArimaEstimation<SarimaModel>(regarima, ll);
            LikelihoodStatistics stats = est.statistics(this.getSarima().getSpecification().getParametersCount(), 0.0);
            this.ser = Math.sqrt(stats.SsqErr / (double)(stats.effectiveObservationsCount - stats.estimatedParametersCount));
        } else {
            RegArimaModel<IArimaModel> regarima = new RegArimaModel<IArimaModel>(this.noisyModel, new DataBlock(this.series.internalStorage()));
            regarima.setMeanCorrection(this.meanCorrection);
            ConcentratedLikelihood ll = regarima.computeLikelihood();
            RegArimaEstimation<IArimaModel> est = new RegArimaEstimation<IArimaModel>(regarima, ll);
            LikelihoodStatistics stats = est.statistics(this.getSarima().getSpecification().getParametersCount(), 0.0);
            this.ser = Math.sqrt(stats.SsqErr / (double)(stats.effectiveObservationsCount - stats.estimatedParametersCount));
        }
    }
}

