/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.special;

import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.ProcessingInformation;
import ec.tstoolkit.eco.DiffuseConcentratedLikelihood;
import ec.tstoolkit.information.InformationMapping;
import ec.tstoolkit.maths.realfunctions.IFunction;
import ec.tstoolkit.maths.realfunctions.IFunctionInstance;
import ec.tstoolkit.structural.BasicStructuralModel;
import ec.tstoolkit.structural.BsmMonitor;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class StmEstimation
implements IProcResults {
    public static final String RESIDUALS = "residuals";
    private final BsmMonitor monitor_;
    private final TsData y_;
    private final TsVariableList x_;
    private static final InformationMapping<StmEstimation> MAPPING = new InformationMapping<StmEstimation>(StmEstimation.class);

    public StmEstimation(TsData y, TsVariableList x, BsmMonitor monitor) {
        this.monitor_ = monitor;
        this.y_ = y;
        this.x_ = x;
    }

    @Override
    public boolean contains(String id) {
        return MAPPING.contains(id);
    }

    @Override
    public List<ProcessingInformation> getProcessingInformation() {
        return Collections.emptyList();
    }

    @Override
    public Map<String, Class> getDictionary() {
        LinkedHashMap<String, Class> map = new LinkedHashMap<String, Class>();
        MAPPING.fillDictionary(null, map, false);
        return map;
    }

    @Override
    public <T> T getData(String id, Class<T> tclass) {
        return MAPPING.getData(this, id, tclass);
    }

    public BasicStructuralModel getModel() {
        return this.monitor_.getResult();
    }

    public TsData getY() {
        return this.y_;
    }

    public TsVariableList getX() {
        return this.x_;
    }

    public TsData getResiduals() {
        double[] res = this.monitor_.getLikelihood().getResiduals();
        TsDomain edom = this.y_.getDomain();
        return new TsData(edom.getStart().plus(edom.getLength() - res.length), res, false);
    }

    public DiffuseConcentratedLikelihood getLikelihood() {
        return this.monitor_.getLikelihood();
    }

    public IFunction likelihoodFunction() {
        return this.monitor_.likelihoodFunction();
    }

    public IFunctionInstance maxLikelihoodFunction() {
        return this.monitor_.maxLikelihoodFunction();
    }

    public static InformationMapping<StmEstimation> getMapping() {
        return MAPPING;
    }

    public static <T> void setMapping(String name, Class<T> tclass, Function<StmEstimation, T> extractor) {
        MAPPING.set(name, tclass, extractor);
    }

    public static <T> void setTsData(String name, Function<StmEstimation, TsData> extractor) {
        MAPPING.set(name, extractor);
    }

    static {
        MAPPING.set(RESIDUALS, source -> source.getResiduals());
    }
}

