/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.tramoseats;

import ec.satoolkit.DecompositionMode;
import ec.satoolkit.DefaultSeriesDecomposition;
import ec.satoolkit.IDefaultSeriesDecomposer;
import ec.satoolkit.IPreprocessingFilter;
import ec.satoolkit.seats.SeatsKernel;
import ec.satoolkit.seats.SeatsResults;
import ec.satoolkit.seats.SeatsSpecification;
import ec.satoolkit.seats.SeatsToolkit;
import ec.tstoolkit.arima.estimation.FastArimaML;
import ec.tstoolkit.arima.estimation.LikelihoodStatistics;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.ReadDataBlock;
import ec.tstoolkit.eco.ConcentratedLikelihood;
import ec.tstoolkit.modelling.ComponentInformation;
import ec.tstoolkit.modelling.ComponentType;
import ec.tstoolkit.modelling.DefaultTransformationType;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.modelling.arima.tramo.TramoProcessor;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.stats.LjungBoxTest;
import ec.tstoolkit.timeseries.simplets.TsData;

public class SeatsDecomposer
implements IDefaultSeriesDecomposer<SeatsResults> {
    private SeatsSpecification spec_;
    private SeatsResults results_;
    private static final double TMU = 1.9;
    private static final double LB_FACTOR = 1.5;
    private static final double LB_LIMIT = 50.0;

    public SeatsDecomposer(SeatsSpecification spec) {
        this.spec_ = spec;
    }

    @Override
    public boolean decompose(TsData y) {
        SeatsToolkit toolkit = SeatsToolkit.create(this.spec_);
        SeatsKernel kernel = new SeatsKernel();
        kernel.setToolkit(toolkit);
        this.results_ = kernel.process(y);
        return this.results_ != null;
    }

    @Override
    public boolean decompose(PreprocessingModel model, IPreprocessingFilter filter) {
        SeatsSpecification spec = this.prepareSpec(model, filter);
        SeatsToolkit toolkit = SeatsToolkit.create(spec);
        SeatsKernel kernel = new SeatsKernel();
        kernel.setToolkit(toolkit);
        TsData y = filter.getCorrectedSeries(true);
        this.correctBias(y, filter);
        this.results_ = kernel.process(y);
        if (this.results_ == null) {
            return false;
        }
        this.correctBias(this.results_.getSeriesDecomposition(), filter);
        LikelihoodStatistics stat = model.estimation.getStatistics();
        this.results_.getModel().setSer(Math.sqrt(stat.SsqErr / (double)(stat.effectiveObservationsCount - stat.estimatedParametersCount)));
        return true;
    }

    @Override
    public SeatsResults getDecomposition() {
        return this.results_;
    }

    private SeatsSpecification prepareSpec(PreprocessingModel model, IPreprocessingFilter filter) {
        SeatsSpecification spec = this.spec_.clone();
        spec.setLog(model.description.getTransformation() == DefaultTransformationType.Log);
        spec.setArima(model.description.getArimaComponent().clone());
        return spec;
    }

    private boolean isMean(PreprocessingModel model) {
        int nhp = model.description.getArimaComponent().getFreeParametersCount();
        if (model.description.isMean()) {
            double emu;
            ConcentratedLikelihood ll = model.estimation.getLikelihood();
            double mu = ll.getB()[0];
            double tmu = mu / (emu = ll.getBSer(0, true, nhp));
            if (Math.abs(tmu) > 1.9) {
                return true;
            }
            int nlb = TramoProcessor.calcLBLength(model.description.getFrequency());
            double lbTramo = this.ljungBox(ll.getResiduals(), nlb);
            TsData lin = model.linearizedSeries(true);
            double lbMean = this.test(lin, model.estimation.getArima(), true, nlb);
            if (lbMean <= 1.5 * lbTramo || lbMean <= 50.0) {
                return true;
            }
            double lbNoMean = this.test(lin, model.estimation.getArima(), false, nlb);
            if (lbNoMean > 1.5 * lbTramo && lbNoMean > 50.0) {
                return true;
            }
        }
        return false;
    }

    private double ljungBox(double[] residuals, int nlb) {
        LjungBoxTest tlb = new LjungBoxTest();
        tlb.setK(nlb);
        tlb.test(new ReadDataBlock(residuals));
        if (tlb.isValid()) {
            return tlb.getValue();
        }
        return 0.0;
    }

    private double test(TsData lin, SarimaModel arima, boolean mean, int nlb) {
        FastArimaML m1 = new FastArimaML();
        m1.setMeanCorrection(mean);
        m1.setModel(arima);
        DataBlock data = new DataBlock(lin);
        if (m1.process(data)) {
            return this.ljungBox(m1.getResiduals(), nlb);
        }
        return 0.0;
    }

    private void correctBias(TsData y, IPreprocessingFilter filter) {
        double bias = filter.getBiasCorrection(ComponentType.Series);
        if (bias == 0.0) {
            return;
        }
        y.apply(x -> x + bias);
    }

    private void correctBias(DefaultSeriesDecomposition decomposition, IPreprocessingFilter filter) {
        double corr = filter.getBiasCorrection(ComponentType.Series);
        if (corr == 0.0) {
            return;
        }
        boolean mul = decomposition.getMode() != DecompositionMode.Additive;
        double bias = mul ? Math.exp(corr) : corr;
        TsData s = decomposition.getSeries(ComponentType.Seasonal, ComponentInformation.Value);
        if (s != null) {
            if (mul) {
                s.apply(x -> x / bias);
            } else {
                s.apply(x -> x - bias);
            }
        }
        if ((s = decomposition.getSeries(ComponentType.Seasonal, ComponentInformation.Forecast)) != null) {
            if (mul) {
                s.apply(x -> x / bias);
            } else {
                s.apply(x -> x - bias);
            }
        }
        if ((s = decomposition.getSeries(ComponentType.Series, ComponentInformation.Value)) != null) {
            if (mul) {
                s.apply(x -> x / bias);
            } else {
                s.apply(x -> x - bias);
            }
        }
        if ((s = decomposition.getSeries(ComponentType.Series, ComponentInformation.Forecast)) != null) {
            if (mul) {
                s.apply(x -> x / bias);
            } else {
                s.apply(x -> x - bias);
            }
        }
    }
}

