/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.x11;

import ec.satoolkit.x11.ComplexNormalizingStrategie;
import ec.satoolkit.x11.CopyYearEndPoints;
import ec.satoolkit.x11.DefaultNormalizingStrategie;
import ec.satoolkit.x11.DefaultX11Algorithm;
import ec.satoolkit.x11.INormalizing;
import ec.satoolkit.x11.ISeasonalNormalizer;
import ec.satoolkit.x11.SeasonalFilterOption;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;

class DefaultSeasonalNormalizer
extends DefaultX11Algorithm
implements ISeasonalNormalizer {
    private INormalizing tempNormalizer;

    DefaultSeasonalNormalizer() {
    }

    public void setNormalizer(SeasonalFilterOption[] options) {
        if (options == null) {
            this.tempNormalizer = new DefaultNormalizingStrategie();
        } else if (options.length == 1) {
            this.tempNormalizer = new DefaultNormalizingStrategie();
        } else {
            for (int i = 0; i < options.length; ++i) {
                if (options[i] == null) continue;
                this.tempNormalizer = new ComplexNormalizingStrategie(options);
                break;
            }
            if (this.tempNormalizer == null) {
                this.tempNormalizer = new DefaultNormalizingStrategie();
            }
        }
    }

    @Override
    public TsData normalize(TsData s, TsDomain xdom) {
        int freq = this.context.getFrequency();
        TsData tmp = this.tempNormalizer.process(s, s.getDomain(), freq);
        TsData snorm = this.op(s, tmp);
        if (xdom == null) {
            return snorm;
        }
        TsData xsnorm = snorm.fittoDomain(xdom);
        int nf = s.getStart().minus(xsnorm.getStart());
        new CopyYearEndPoints(nf, freq).process(null, new DataBlock(xsnorm.internalStorage()));
        return xsnorm;
    }
}

