/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.x11;

import ec.satoolkit.x11.AirlinePreprocessor;
import ec.satoolkit.x11.AutomaticTrendCycleComputer;
import ec.satoolkit.x11.BaseX11Algorithm;
import ec.satoolkit.x11.BiasCorrection;
import ec.satoolkit.x11.CochranDependentExtremeValuesCorrector;
import ec.satoolkit.x11.DefaultExtremeValuesCorrector;
import ec.satoolkit.x11.DefaultSeasonalComputer;
import ec.satoolkit.x11.DefaultSeasonalNormalizer;
import ec.satoolkit.x11.DefaultTrendCycleComputer;
import ec.satoolkit.x11.DefaultX11Algorithm;
import ec.satoolkit.x11.DefaultX11Utilities;
import ec.satoolkit.x11.DummySeasonalNormalizer;
import ec.satoolkit.x11.GroupSpecificExtremeValuesCorrector;
import ec.satoolkit.x11.IExtremeValuesCorrector;
import ec.satoolkit.x11.ISeasonalComputer;
import ec.satoolkit.x11.ISeasonalNormalizer;
import ec.satoolkit.x11.ITrendCycleComputer;
import ec.satoolkit.x11.IX11Preprocessor;
import ec.satoolkit.x11.IX11Toolkit;
import ec.satoolkit.x11.IX11Utilities;
import ec.satoolkit.x11.PeriodSpecificExtremeValuesCorrector;
import ec.satoolkit.x11.X11Context;
import ec.satoolkit.x11.X11Specification;

public class X11Toolkit
extends BaseX11Algorithm
implements IX11Toolkit {
    private IX11Preprocessor preprocessor;
    private ITrendCycleComputer tcprovider;
    private ISeasonalComputer sprovider;
    private IExtremeValuesCorrector xcorrector;
    private ISeasonalNormalizer snormalizer;
    private IX11Utilities utilities = new DefaultX11Utilities();
    private boolean excludefcst = false;
    private BiasCorrection bias = BiasCorrection.Legacy;

    public static X11Toolkit create(X11Specification spec) {
        X11Context context = new X11Context(spec.getMode(), spec.getBackcastHorizon(), spec.getForecastHorizon());
        X11Toolkit toolkit = new X11Toolkit(context);
        if (spec.getForecastHorizon() != 0 || spec.getBackcastHorizon() != 0) {
            toolkit.setPreprocessor(new AirlinePreprocessor());
        }
        DefaultSeasonalComputer sprovider = new DefaultSeasonalComputer();
        if (spec.isSeasonal()) {
            sprovider.setFilters(spec.getSeasonalFilters());
        } else {
            sprovider.setDummyFilter();
        }
        toolkit.setSeasonalFilterprovider(sprovider);
        toolkit.setExcludefcas(spec.isExcludefcst());
        if (spec.isAutoHenderson()) {
            toolkit.setTrendCycleFilterprovider(new AutomaticTrendCycleComputer());
        } else {
            toolkit.setTrendCycleFilterprovider(new DefaultTrendCycleComputer(spec.getHendersonFilterLength()));
        }
        switch (spec.getCalendarSigma()) {
            case Select: {
                DefaultX11Algorithm xcorrector = new GroupSpecificExtremeValuesCorrector();
                ((PeriodSpecificExtremeValuesCorrector)xcorrector).setSigma(spec.getLowerSigma(), spec.getUpperSigma());
                ((GroupSpecificExtremeValuesCorrector)xcorrector).setSigmavecOption(spec.getSigmavec());
                ((PeriodSpecificExtremeValuesCorrector)xcorrector).setExcludefcast(spec.isExcludefcst());
                toolkit.setExtremeValuescorrector((IExtremeValuesCorrector)((Object)xcorrector));
                break;
            }
            case All: {
                DefaultX11Algorithm xcorrector = new PeriodSpecificExtremeValuesCorrector();
                ((PeriodSpecificExtremeValuesCorrector)xcorrector).setSigma(spec.getLowerSigma(), spec.getUpperSigma());
                ((PeriodSpecificExtremeValuesCorrector)xcorrector).setExcludefcast(spec.isExcludefcst());
                toolkit.setExtremeValuescorrector((IExtremeValuesCorrector)((Object)xcorrector));
                break;
            }
            case Signif: {
                DefaultX11Algorithm xcorrector = new CochranDependentExtremeValuesCorrector();
                ((CochranDependentExtremeValuesCorrector)xcorrector).setSigma(spec.getLowerSigma(), spec.getUpperSigma());
                ((CochranDependentExtremeValuesCorrector)xcorrector).setExcludefcast(spec.isExcludefcst());
                toolkit.setExtremeValuescorrector((IExtremeValuesCorrector)((Object)xcorrector));
                break;
            }
            default: {
                DefaultX11Algorithm xcorrector = new DefaultExtremeValuesCorrector();
                ((DefaultExtremeValuesCorrector)xcorrector).setSigma(spec.getLowerSigma(), spec.getUpperSigma());
                ((DefaultExtremeValuesCorrector)xcorrector).setExcludefcast(spec.isExcludefcst());
                toolkit.setExtremeValuescorrector((IExtremeValuesCorrector)((Object)xcorrector));
                break;
            }
        }
        if (spec.isSeasonal()) {
            DefaultSeasonalNormalizer nprovider = new DefaultSeasonalNormalizer();
            nprovider.setNormalizer(spec.getSeasonalFilters());
            toolkit.setSeasonalnormalizer(nprovider);
        } else {
            toolkit.setSeasonalnormalizer(DummySeasonalNormalizer.instance);
        }
        toolkit.bias = spec.getBiasCorrection();
        return toolkit;
    }

    public static X11Toolkit create() {
        return X11Toolkit.create(new X11Specification());
    }

    private X11Toolkit(X11Context context) {
        this.context = context;
    }

    @Override
    public IExtremeValuesCorrector getExtremeValuesCorrector() {
        return this.xcorrector;
    }

    @Override
    public IX11Preprocessor getPreprocessor() {
        return this.preprocessor;
    }

    @Override
    public ISeasonalComputer getSeasonalComputer() {
        return this.sprovider;
    }

    @Override
    public ISeasonalNormalizer getSeasonalNormalizer() {
        return this.snormalizer;
    }

    @Override
    public ITrendCycleComputer getTrendCycleComputer() {
        return this.tcprovider;
    }

    @Override
    public IX11Utilities getUtilities() {
        return this.utilities;
    }

    @Override
    public boolean isExcludefcst() {
        return this.excludefcst;
    }

    @Override
    public BiasCorrection getBiasCorrection() {
        return this.bias;
    }

    @Override
    public X11Context getContext() {
        return this.context;
    }

    public void setPreprocessor(IX11Preprocessor preprocessor) {
        if (preprocessor != null) {
            preprocessor.setContext(this.context);
        }
        this.preprocessor = preprocessor;
    }

    public void setTrendCycleFilterprovider(ITrendCycleComputer tcprovider) {
        if (tcprovider != null) {
            tcprovider.setContext(this.context);
        }
        this.tcprovider = tcprovider;
    }

    public void setSeasonalFilterprovider(ISeasonalComputer sprovider) {
        if (sprovider != null) {
            sprovider.setContext(this.context);
        }
        this.sprovider = sprovider;
    }

    public void setExtremeValuescorrector(IExtremeValuesCorrector xcorrector) {
        if (xcorrector != null) {
            xcorrector.setContext(this.context);
        }
        this.xcorrector = xcorrector;
    }

    public void setSeasonalnormalizer(ISeasonalNormalizer snormalizer) {
        if (snormalizer != null) {
            snormalizer.setContext(this.context);
        }
        this.snormalizer = snormalizer;
    }

    public void setExcludefcas(boolean excldudefcast) {
        this.excludefcst = excldudefcast;
    }

    public void setUtilities(IX11Utilities utilities) {
        if (utilities != null) {
            utilities.setContext(this.context);
        }
        this.utilities = utilities;
    }
}

