/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima;

import ec.tstoolkit.BaseException;
import ec.tstoolkit.arima.ArimaException;
import ec.tstoolkit.arima.ArimaModel;
import ec.tstoolkit.arima.AutoCovarianceFunction;
import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.StationaryTransformation;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.dstats.IDistribution;
import ec.tstoolkit.dstats.Normal;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.linearfilters.RationalBackFilter;
import ec.tstoolkit.maths.matrices.LowerTriangularMatrix;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.random.IRandomNumberGenerator;
import ec.tstoolkit.random.StochasticRandomizer;
import ec.tstoolkit.random.XorshiftRNG;

public final class ArimaModelBuilder {
    private int m_ndrop = 0;
    private double m_startmean = 100.0;
    private double m_startstdev = 10.0;
    private static IRandomNumberGenerator RNG = XorshiftRNG.fromSystemNanoTime();
    private IDistribution m_dist = new Normal();
    private IRandomNumberGenerator rng = RNG;

    public void setStartMean(double m) {
        this.m_startmean = m;
    }

    public void setStartStdev(double e) {
        this.m_startstdev = e;
    }

    public void setDropCount(int n) {
        this.m_ndrop = n;
    }

    public double getStartMean() {
        return this.m_startmean;
    }

    public double getStartStdev() {
        return this.m_startstdev;
    }

    public int getDropCount() {
        return this.m_ndrop;
    }

    public void setRandomNumberGenerator(IRandomNumberGenerator rng) {
        this.rng = rng;
    }

    public IRandomNumberGenerator getRandomNumberGenerator() {
        return this.rng;
    }

    public IDistribution getDistribution() {
        return this.m_dist;
    }

    public void setDistribution(IDistribution dist) {
        this.m_dist = dist;
    }

    public ArimaModel createModel(Polynomial AR2, Polynomial MA, double var) {
        try {
            double x = AR2.get(0);
            double y = MA.get(0);
            BackFilter ar = new BackFilter(AR2);
            if (x != 1.0) {
                ar = ar.normalize();
            }
            BackFilter ur = BackFilter.ONE;
            BackFilter.StationaryTransformation st = new BackFilter.StationaryTransformation();
            if (st.transform(ar)) {
                ar = st.stationaryFilter;
                ur = st.unitRoots;
            }
            BackFilter ma = new BackFilter(MA);
            if (y != 1.0) {
                ma = ma.normalize();
            }
            return new ArimaModel(ar, ur, ma, var * y / x * y / x);
        }
        catch (BaseException ex) {
            return null;
        }
    }

    public double[] generate(IArimaModel arima, int n) {
        return this.generate(arima, 0.0, n);
    }

    public double[] generate(IArimaModel arima, double mean, int n) {
        try {
            int i;
            double[] w;
            StationaryTransformation stm = arima.stationaryTransformation();
            double[] tmp = this.generateStationary((IArimaModel)stm.stationaryModel, mean, n + this.m_ndrop);
            if (this.m_ndrop == 0) {
                w = tmp;
            } else {
                w = new double[n];
                System.arraycopy(tmp, this.m_ndrop, w, 0, n);
            }
            if (stm.unitRoots.isIdentity()) {
                return w;
            }
            Polynomial P = stm.unitRoots.getPolynomial();
            double[] yprev = new double[P.getDegree()];
            if (this.m_startstdev != 0.0) {
                for (i = 0; i < yprev.length; ++i) {
                    yprev[i] = StochasticRandomizer.normal(this.rng, this.m_startmean, this.m_startstdev);
                }
            } else if (this.m_startmean != 0.0) {
                for (i = 0; i < yprev.length; ++i) {
                    yprev[i] = this.m_startmean;
                }
            }
            for (i = 0; i < n; ++i) {
                int j;
                double y = w[i];
                for (j = 1; j <= P.getDegree(); ++j) {
                    y -= yprev[j - 1] * P.get(j);
                }
                w[i] = y;
                for (j = yprev.length - 1; j > 0; --j) {
                    yprev[j] = yprev[j - 1];
                }
                if (yprev.length <= 0) continue;
                yprev[0] = y;
            }
            return w;
        }
        catch (ArimaException ex) {
            return null;
        }
    }

    public double[] generateStationary(IArimaModel starima, int n) {
        return this.generateStationary(starima, 0.0, n);
    }

    public double[] generateStationary(IArimaModel starima, double mean, int n) {
        BackFilter ar = starima.getAR();
        BackFilter ma = starima.getMA();
        int p = ar.getDegree();
        int q = ma.getDegree();
        double[] y = new double[p];
        double[] e = new double[q];
        if (p == 0) {
            for (int i = 0; i < q; ++i) {
                e[i] = this.m_dist.random(this.rng);
            }
        } else {
            Matrix ac = new Matrix(p + q, p + q);
            AutoCovarianceFunction acf = starima.getAutoCovarianceFunction();
            acf.prepare(p);
            SubMatrix pm = ac.subMatrix(0, p, 0, p);
            pm.diagonal().set(acf.get(0));
            for (int i = 1; i < p; ++i) {
                pm.subDiagonal(-i).set(acf.get(i));
            }
            if (q > 0) {
                SubMatrix qm = ac.subMatrix(p, p + q, p, p + q);
                qm.diagonal().set(starima.getInnovationVariance());
                SubMatrix qp = ac.subMatrix(p, p + q, 0, p);
                RationalBackFilter psi = starima.getPsiWeights();
                int nw = Math.min(q, p);
                psi.prepare(q);
                DataBlock w = new DataBlock(psi.getWeights(q));
                for (int i = 0; i < nw; ++i) {
                    qp.column(i).drop(i, 0).copy(w.drop(0, i));
                }
                qp.mul(starima.getInnovationVariance());
            }
            SymmetricMatrix.fromLower(ac);
            SymmetricMatrix.lcholesky(ac);
            double[] x = new double[p + q];
            for (int i = 0; i < x.length; ++i) {
                x[i] = this.m_dist.random(this.rng);
            }
            LowerTriangularMatrix.lmul(ac, x);
            System.arraycopy(x, 0, y, 0, p);
            if (q > 0) {
                System.arraycopy(x, p, e, 0, q);
            }
        }
        double[] z = new double[n];
        double std = Math.sqrt(starima.getInnovationVariance());
        Polynomial theta = ma.getPolynomial();
        Polynomial phi = ar.getPolynomial();
        for (int i = 0; i < n; ++i) {
            int j;
            double u = this.m_dist.random(this.rng) * std;
            double t = mean + u * theta.get(0);
            for (j = 1; j <= q; ++j) {
                t += e[j - 1] * theta.get(j);
            }
            for (j = 1; j <= p; ++j) {
                t -= y[j - 1] * phi.get(j);
            }
            z[i] = t /= phi.get(0);
            if (e.length > 0) {
                for (j = e.length - 1; j > 0; --j) {
                    e[j] = e[j - 1];
                }
                e[0] = u;
            }
            for (j = y.length - 1; j > 0; --j) {
                y[j] = y[j - 1];
            }
            if (y.length <= 0) continue;
            y[0] = t;
        }
        return z;
    }
}

