/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.special;

import ec.tstoolkit.arima.special.GeneralizedAirlineModel;
import ec.tstoolkit.data.IDataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.linearfilters.Utilities;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.maths.realfunctions.ParamValidation;
import ec.tstoolkit.utilities.Ref;

public class GeneralizedAirlineMapper
implements IParametricMapping<GeneralizedAirlineModel> {
    private final int[] m_c;
    private final boolean[] m_fixed;
    private final int m_pow;
    private final int m_freq;
    private final P_Type[] m_ptypes;
    private double m_ubound;
    private boolean m_strict = false;

    public GeneralizedAirlineMapper(GeneralizedAirlineModel t) {
        this.m_c = t.m_c;
        this.m_fixed = t.m_fixed;
        this.m_ptypes = new P_Type[t.getParametersCount()];
        this.m_pow = t.m_pow;
        this.m_freq = t.m_freq;
        this.m_ubound = 1.1;
        int j = 0;
        for (int i = 0; i < t.m_q.length; ++i) {
            if (t.m_fixed[i]) continue;
            this.m_ptypes[j++] = t.m_c[i] < 0 ? P_Type.P_ZERO : (i < 2 ? P_Type.R_ZERO : (i == 2 ? P_Type.H_SEL : P_Type.H_NSEL));
        }
    }

    @Override
    public boolean checkBoundaries(IReadDataBlock p) {
        int np = this.m_ptypes.length;
        for (int i = 0; i < np; ++i) {
            if (!Double.isNaN(p.get(i))) continue;
            return false;
        }
        int idx = 0;
        if (this.m_ptypes[0] == P_Type.P_ZERO) {
            if (np > 1 && this.m_ptypes[1] == P_Type.P_ZERO) {
                double ro = p.get(0) * p.get(0) - 4.0 * p.get(1);
                if (ro < 0.0) {
                    if (p.get(1) > this.m_ubound * this.m_ubound) {
                        return false;
                    }
                } else {
                    ro = Math.sqrt(ro);
                    double r = (-p.get(0) + ro) / (2.0 * p.get(1));
                    if (Math.abs(r) < 1.0 / this.m_ubound) {
                        return false;
                    }
                    r = (-p.get(0) - ro) / (2.0 * p.get(1));
                    if (Math.abs(r) < 1.0 / this.m_ubound) {
                        return false;
                    }
                }
                idx = 2;
            } else {
                if (Math.abs(p.get(0)) > 2.0) {
                    return false;
                }
                idx = 1;
            }
        } else if (this.m_ptypes[0] == P_Type.R_ZERO) {
            if (Math.abs(p.get(0)) > this.m_ubound) {
                return false;
            }
            idx = 1;
        }
        for (int i = idx; i < np; ++i) {
            if (!(p.get(i) < 0.0) && !(p.get(i) > this.m_ubound)) continue;
            return false;
        }
        return true;
    }

    @Override
    public double epsilon(IReadDataBlock inparams, int idx) {
        if (this.m_ptypes[idx] == P_Type.R_ZERO || this.m_ptypes[idx] == P_Type.P_ZERO) {
            return GeneralizedAirlineModel.EPS;
        }
        if (this.m_ptypes[idx] == P_Type.H_SEL) {
            return GeneralizedAirlineModel.EPS / (double)this.m_pow;
        }
        return GeneralizedAirlineModel.EPS / (double)(this.m_freq - this.m_pow - 1);
    }

    @Override
    public int getDim() {
        return this.m_ptypes.length;
    }

    @Override
    public String getDescription(int idx) {
        return "parameter " + idx;
    }

    public boolean isStrict() {
        return this.m_strict;
    }

    @Override
    public double lbound(int idx) {
        int l = 0;
        if (this.m_ptypes.length > 1 && this.m_ptypes[0] == P_Type.P_ZERO && this.m_ptypes[1] == P_Type.P_ZERO) {
            l = 2;
        }
        if (idx < l) {
            return Double.NEGATIVE_INFINITY;
        }
        return 0.0;
    }

    @Override
    public IReadDataBlock map(GeneralizedAirlineModel t) {
        return t.getParameters();
    }

    @Override
    public GeneralizedAirlineModel map(IReadDataBlock p) {
        GeneralizedAirlineModel model = new GeneralizedAirlineModel();
        model.m_c = this.m_c;
        model.m_fixed = this.m_fixed;
        model.m_freq = this.m_freq;
        model.m_pow = this.m_pow;
        model.m_q = new double[this.m_fixed.length];
        for (int i = 0; i < this.m_fixed.length; ++i) {
            if (!this.m_fixed[i]) continue;
            model.m_q[i] = 1.0;
        }
        model.setParameters(p);
        return model;
    }

    public void setStrict(boolean value) {
        this.m_strict = value;
    }

    @Override
    public double ubound(int idx) {
        int l = 0;
        if (this.m_ptypes.length > 1 && this.m_ptypes[0] == P_Type.P_ZERO && this.m_ptypes[1] == P_Type.P_ZERO) {
            l = 2;
        }
        if (idx < l) {
            return Double.POSITIVE_INFINITY;
        }
        return this.m_ubound;
    }

    @Override
    public ParamValidation validate(IDataBlock ioparams) {
        ParamValidation rslt = ParamValidation.Valid;
        int idx = 0;
        if (this.m_ptypes[0] == P_Type.P_ZERO) {
            if (this.m_ptypes.length > 1 && this.m_ptypes[1] == P_Type.P_ZERO) {
                Ref<Object> np;
                Polynomial p = Polynomial.valueOf(1.0, ioparams.get(0), ioparams.get(1));
                if (Utilities.stabilize(p, np = new Ref<Object>(null))) {
                    ioparams.set(0, ((Polynomial)np.val).get(1));
                    ioparams.set(1, ((Polynomial)np.val).get(2));
                    rslt = ParamValidation.Changed;
                }
                idx = 2;
            } else {
                if (ioparams.get(0) > 2.0) {
                    rslt = ParamValidation.Changed;
                    ioparams.set(0, 2.0);
                } else if (ioparams.get(0) < -2.0) {
                    rslt = ParamValidation.Changed;
                    ioparams.set(0, -2.0);
                }
                idx = 1;
            }
        } else if (this.m_ptypes[0] == P_Type.R_ZERO) {
            if (Math.abs(ioparams.get(0)) > 1.0) {
                ioparams.set(0, 1.0 / ioparams.get(0));
                rslt = ParamValidation.Changed;
            }
            idx = 1;
        }
        for (int i = idx; i < this.m_ptypes.length; ++i) {
            if (ioparams.get(i) < 0.0) {
                ioparams.set(i, 0.0);
                rslt = ParamValidation.Changed;
                continue;
            }
            if (!(ioparams.get(i) > 1.0) || !this.m_strict && !(ioparams.get(i) > this.m_ubound)) continue;
            ioparams.set(i, 1.0 / ioparams.get(i));
            rslt = ParamValidation.Changed;
        }
        return rslt;
    }

    private static enum P_Type {
        P_ZERO,
        R_ZERO,
        H_SEL,
        H_NSEL;

    }
}

