/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.special.mixedfrequencies;

import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.InformationSetSerializable;
import ec.tstoolkit.timeseries.DataType;
import ec.tstoolkit.timeseries.PeriodSelectorType;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import java.util.Map;
import java.util.Objects;

public class BasicSpec
implements Cloneable,
InformationSetSerializable {
    public static final String SPAN = "span";
    public static final String LOG = "log";
    public static final String DATATYPE = "datatype";
    private TsPeriodSelector span_ = new TsPeriodSelector();
    private DataType type_ = DataType.Flow;
    private boolean log_ = false;

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(InformationSet.item(prefix, LOG), Boolean.class);
        dic.put(InformationSet.item(prefix, DATATYPE), String.class);
        dic.put(InformationSet.item(prefix, SPAN), TsPeriodSelector.class);
    }

    public void reset() {
        this.span_ = new TsPeriodSelector();
        this.log_ = false;
        this.type_ = DataType.Flow;
    }

    public TsPeriodSelector getSpan() {
        return this.span_;
    }

    public void setSpan(TsPeriodSelector value) {
        if (value == null) {
            this.span_.all();
        } else {
            this.span_ = value;
        }
    }

    public boolean isLog() {
        return this.log_;
    }

    public void setLog(boolean log) {
        this.log_ = log;
    }

    public DataType getDataType() {
        return this.type_;
    }

    public void setDataType(DataType type) {
        this.type_ = type;
    }

    public boolean isDefault() {
        return !this.log_ && this.type_ == DataType.Flow && this.span_.getType() == PeriodSelectorType.All;
    }

    public BasicSpec clone() {
        try {
            BasicSpec spec = (BasicSpec)super.clone();
            spec.span_ = this.span_.clone();
            return spec;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public boolean equals(BasicSpec other) {
        if (other == null) {
            return this.isDefault();
        }
        return this.log_ == other.log_ && this.type_ == other.type_ && Objects.equals(this.span_, other.span_);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof BasicSpec && this.equals((BasicSpec)obj);
    }

    public int hashCode() {
        int hash = 5;
        hash = 61 * hash + Objects.hashCode(this.span_);
        hash = 61 * hash + (this.log_ ? 1 : 0);
        hash = 61 * hash + Objects.hashCode(this.type_);
        return hash;
    }

    @Override
    public InformationSet write(boolean verbose) {
        if (!verbose && this.isDefault()) {
            return null;
        }
        InformationSet info = new InformationSet();
        if (verbose || this.span_.getType() != PeriodSelectorType.All) {
            info.add(SPAN, this.span_);
        }
        if (verbose || this.log_) {
            info.add(LOG, Boolean.valueOf(this.log_));
        }
        if (verbose || this.type_ != DataType.Flow) {
            info.add(DATATYPE, this.type_.name());
        }
        return info;
    }

    @Override
    public boolean read(InformationSet info) {
        try {
            Boolean log;
            String t;
            this.reset();
            TsPeriodSelector span = info.get(SPAN, TsPeriodSelector.class);
            if (span != null) {
                this.span_ = span;
            }
            if ((t = info.get(DATATYPE, String.class)) != null) {
                this.type_ = DataType.valueOf(t);
            }
            if ((log = info.get(LOG, Boolean.class)) != null) {
                this.log_ = log;
            }
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }
}

