/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.data;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.matrices.SubMatrix;
import java.util.Arrays;

public class DataBlockStorage {
    private double[] m_data;
    private int m_n;
    private int m_nused;
    private final int m_dim;
    private static final int g_atom = 16;

    public static int calcSize(int capacity) {
        return (1 + (capacity - 1) / 16) * 16;
    }

    public DataBlockStorage(int dim, int capacity) {
        this.m_n = DataBlockStorage.calcSize(capacity);
        this.m_dim = dim;
        this.m_data = new double[this.m_dim * this.m_n];
    }

    public DataBlock block(int pos) {
        int start = this.m_dim * pos;
        return new DataBlock(this.m_data, start, start + this.m_dim, 1);
    }

    public int getCapacity() {
        return this.m_n;
    }

    public int getCurrentSize() {
        return this.m_nused;
    }

    public int getDim() {
        return this.m_dim;
    }

    public DataBlock item(int index) {
        return new DataBlock(this.m_data, index, index + this.m_dim * this.m_nused, this.m_dim);
    }

    public void resize(int ncapacity) {
        int n = DataBlockStorage.calcSize(ncapacity);
        if (n <= this.m_n) {
            return;
        }
        double[] data = new double[this.m_dim * n];
        System.arraycopy(this.m_data, 0, data, 0, this.m_data.length);
        this.m_data = data;
        this.m_n = n;
    }

    public void resize(int ncapacity, double value) {
        int n = DataBlockStorage.calcSize(ncapacity);
        if (n <= this.m_n) {
            return;
        }
        double[] data = new double[this.m_dim * n];
        Arrays.fill(data, this.m_data.length, data.length, value);
        System.arraycopy(this.m_data, 0, data, 0, this.m_data.length);
        this.m_data = data;
        this.m_n = n;
    }

    public void save(int pos, DataBlock rc) {
        rc.copyTo(this.m_data, pos * this.m_dim);
        if (pos >= this.m_nused) {
            this.m_nused = pos + 1;
        }
    }

    public void save(int pos, double[] v) {
        System.arraycopy(v, 0, this.m_data, pos * this.m_dim, this.m_dim);
        if (pos >= this.m_nused) {
            this.m_nused = pos + 1;
        }
    }

    public DataBlock storage(int start, int end) {
        int p0 = this.m_dim * start;
        int p1 = this.m_dim * end;
        return new DataBlock(this.m_data, p0, p1, 1);
    }

    public double[] storage() {
        return this.m_data;
    }

    public SubMatrix subMatrix(int start, int end) {
        return new SubMatrix(this.m_data, this.m_dim * start, this.m_dim, end - start, 1, this.m_dim);
    }

    public SubMatrix subMatrix() {
        return new SubMatrix(this.m_data, 0, this.m_dim, this.m_nused, 1, this.m_dim);
    }

    public void rescale(double factor) {
        if (factor == 1.0) {
            return;
        }
        int n = this.m_dim * this.m_nused;
        int i = 0;
        while (i < n) {
            int n2 = i++;
            this.m_data[n2] = this.m_data[n2] * factor;
        }
    }
}

