/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.data;

import ec.tstoolkit.data.IDataNormalizer;
import ec.tstoolkit.data.IReadDataBlock;

public class MaxAbsNormalizer
implements IDataNormalizer {
    private double m_c;
    private double m_max = 10.0;
    private double[] m_data;

    @Override
    public double getFactor() {
        return this.m_c;
    }

    public double getMax() {
        return this.m_max;
    }

    @Override
    public double[] getNormalizedData() {
        return this.m_data;
    }

    private boolean process() {
        int i;
        double max = 0.0;
        for (i = 0; i < this.m_data.length; ++i) {
            double d = this.m_data[i];
            if (!Double.isFinite(d) || !((d = Math.abs(d)) > max)) continue;
            max = d;
        }
        if (max == 0.0) {
            return false;
        }
        this.m_c = this.m_max / max;
        for (i = 0; i < this.m_data.length; ++i) {
            if (!Double.isFinite(this.m_data[i])) continue;
            int n = i;
            this.m_data[n] = this.m_data[n] * this.m_c;
        }
        return true;
    }

    public boolean process(double[] data) {
        this.m_c = 1.0;
        this.m_data = (double[])data.clone();
        return this.process();
    }

    @Override
    public boolean process(IReadDataBlock data) {
        this.m_c = 1.0;
        this.m_data = new double[data.getLength()];
        data.copyTo(this.m_data, 0);
        return this.process();
    }

    public void setMax(double value) {
        this.m_max = value;
    }
}

