/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.eco;

import java.text.DecimalFormat;

public class CoefficientEstimation {
    private final double m_ser;
    private final double m_val;

    public CoefficientEstimation(double val, double ser) {
        this.m_val = val;
        this.m_ser = ser;
    }

    public double getStdev() {
        return this.m_ser;
    }

    public double getTStat() {
        return this.m_val / this.m_ser;
    }

    public double getValue() {
        return this.m_val;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        DecimalFormat df4 = new DecimalFormat("0.0000");
        DecimalFormat dg6 = new DecimalFormat("0.######");
        builder.append(dg6.format(this.m_val));
        if (this.m_ser != 0.0) {
            builder.append(" (").append(df4.format(this.getTStat())).append(')');
        }
        return builder.toString();
    }
}

