/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.matrices.Householder;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixException;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.maths.realfunctions.FunctionException;
import ec.tstoolkit.maths.realfunctions.ISsqFunction;
import ec.tstoolkit.maths.realfunctions.ISsqFunctionInstance;
import ec.tstoolkit.maths.realfunctions.ISsqFunctionMinimizer;
import ec.tstoolkit.maths.realfunctions.ParamValidation;

class TramoMarquardt
implements ISsqFunctionMinimizer {
    private int m_niter = 0;
    private int m_maxiter = 50;
    private int m_ndata;
    private double[] m_beta;
    private double m_lambda = 0.001;
    private double m_istep = 4.0;
    private double m_dstep = 0.5;
    private double m_criterion = 1.0E-4;
    private double m_curlambda = 0.0;
    private double m_dmax;
    private double m_obj0 = 0.0;
    private double m_obj1 = 0.0;
    private double[] m_e;
    private Matrix m_dfn;
    private Matrix m_alpha;
    private Matrix m_var;
    private ISsqFunction m_fn;
    private ISsqFunctionInstance m_ftry;
    private DataBlock m_a;

    @Override
    public ISsqFunctionMinimizer exemplar() {
        TramoMarquardt qrm = new TramoMarquardt();
        qrm.m_criterion = this.m_criterion;
        qrm.m_dstep = this.m_dstep;
        qrm.m_istep = this.m_istep;
        qrm.m_lambda = this.m_lambda;
        qrm.m_maxiter = this.m_maxiter;
        return qrm;
    }

    @Override
    public double getConvergenceCriterion() {
        return this.m_criterion;
    }

    @Override
    public void setConvergenceCriterion(double value) {
        this.m_criterion = value;
    }

    public double getCurrentLambda() {
        return this.m_curlambda;
    }

    @Override
    public Matrix getCurvature() {
        this.calcVar();
        return this.m_alpha;
    }

    @Override
    public double[] getGradient() {
        int n = this.m_beta.length;
        double[] g = new double[n];
        for (int c = 0; c < n; ++c) {
            g[c] = -this.m_beta[c];
        }
        return g;
    }

    public double getDecreaseStep() {
        return this.m_dstep;
    }

    public double getIncreaseStep() {
        return this.m_istep;
    }

    public double getInitialLambda() {
        return this.m_lambda;
    }

    public Matrix getInvCurvature() {
        this.calcVar();
        return this.m_alpha;
    }

    @Override
    public int getIterCount() {
        return this.m_niter;
    }

    @Override
    public int getMaxIter() {
        return this.m_maxiter;
    }

    @Override
    public void setMaxIter(int n) {
        this.m_maxiter = n;
    }

    @Override
    public ISsqFunctionInstance getResult() {
        return this.m_ftry;
    }

    @Override
    public double getObjective() {
        return this.m_ftry == null ? Double.NaN : this.m_ftry.getSsqE();
    }

    public boolean minimize(ISsqFunction fn, IReadDataBlock pstart) {
        return this.minimize(fn, fn.ssqEvaluate(pstart));
    }

    @Override
    public boolean minimize(ISsqFunction fn, ISsqFunctionInstance start) {
        this.clear();
        this.m_fn = fn;
        this.initialize(start);
        if (this.m_a.isEmpty()) {
            return true;
        }
        boolean bnewval = true;
        do {
            bnewval = this.iterate(bnewval);
        } while (this.nextIteration());
        this.endIteration();
        return this.m_niter < this.m_maxiter;
    }

    protected void endIteration() {
    }

    protected boolean nextIteration() {
        if (this.m_niter >= this.m_maxiter) {
            return false;
        }
        double dobj = Math.abs(this.m_obj0 - this.m_obj1) / (1.0 + Math.abs(this.m_obj0));
        return this.m_niter < this.m_maxiter && dobj > this.m_criterion && this.m_dmax > Math.sqrt(this.m_criterion);
    }

    private void calcVar() {
        if (this.m_alpha == null) {
            int n = this.m_beta.length;
            this.m_alpha = new Matrix(n, n);
            for (int c = 0; c < n; ++c) {
                for (int r = 0; r <= c; ++r) {
                    double salpha = 0.0;
                    for (int i = 0; i < this.m_ndata; ++i) {
                        salpha += this.m_dfn.get(i, c) * this.m_dfn.get(i, r);
                    }
                    this.m_alpha.set(c, r, salpha);
                }
            }
            SymmetricMatrix.fromLower(this.m_alpha);
        }
        try {
            this.m_var = SymmetricMatrix.inverse(this.m_alpha);
        }
        catch (MatrixException ex) {
            this.m_var = null;
        }
    }

    protected void clear() {
        this.m_ftry = null;
        this.m_e = null;
        this.m_alpha = null;
        this.m_niter = 0;
        this.m_curlambda = 0.0;
    }

    protected void initialize(ISsqFunctionInstance start) {
        this.m_niter = 0;
        this.m_ftry = start;
        IReadDataBlock p = start.getParameters();
        this.m_a = new DataBlock(p.getLength());
        p.copyTo(this.m_a.getData(), 0);
        int n = this.m_a.getLength();
        this.m_beta = new double[n];
        this.m_curlambda = 0.0;
        this.m_e = this.m_ftry.getE();
        this.m_obj1 = this.m_ftry.getSsqE();
    }

    protected boolean iterate(boolean bnewval) {
        ++this.m_niter;
        this.m_obj0 = this.m_obj1;
        int ne = this.m_e.length;
        int n = this.m_beta.length;
        this.m_ndata = ne;
        int nc = ne + n;
        this.calcDerivatives();
        double[] errtmp = new double[nc];
        for (int r = 0; r < ne; ++r) {
            errtmp[r] = -this.m_e[r];
        }
        if (this.m_curlambda != 0.0) {
            double sg = Math.sqrt(this.m_curlambda);
            for (int c = 0; c < n; ++c) {
                this.m_dfn.set(ne + c, c, sg);
            }
        }
        double sum = 0.0;
        this.m_dmax = 0.0;
        DataBlock atry = this.m_a.deepClone();
        try {
            Householder qr = new Householder(true);
            qr.decompose(this.m_dfn);
            double[] da = qr.solve(errtmp);
            for (int i = 0; i < n; ++i) {
                atry.set(i, atry.get(i) + da[i]);
                sum += (this.m_beta[i] + this.m_curlambda * da[i]) * da[i];
                double dmax = Math.abs(da[i]) / (1.0 + Math.abs(this.m_a.get(i)));
                if (!(dmax > this.m_dmax)) continue;
                this.m_dmax = dmax;
            }
        }
        catch (MatrixException e) {
            return false;
        }
        sum /= 2.0;
        ParamValidation val = this.m_fn.getDomain().validate(atry);
        if (val == ParamValidation.Invalid) {
            throw new FunctionException("Boundaries error");
        }
        ISsqFunctionInstance ftry = this.m_fn.ssqEvaluate(atry);
        if (ftry != null) {
            this.m_obj1 = ftry.getSsqE();
            this.m_e = ftry.getE();
        } else {
            this.m_obj1 = Double.MAX_VALUE;
        }
        if (!this.nextIteration()) {
            if (this.m_niter <= this.m_maxiter) {
                this.m_ftry = ftry;
                this.m_a = atry;
            }
            return false;
        }
        double s = (this.m_obj0 - this.m_obj1) / sum;
        if (s > 0.0) {
            this.m_ftry = ftry;
            this.m_a = atry;
        }
        if (s < 0.25) {
            this.m_curlambda = this.m_curlambda == 0.0 ? this.m_lambda : (this.m_curlambda *= this.m_istep);
        }
        if (s > 0.75) {
            this.m_curlambda *= this.m_dstep;
        }
        return s > 0.0;
    }

    private void calcDerivatives() {
        int ne = this.m_e.length;
        int n = this.m_beta.length;
        int nc = ne + n;
        this.m_dfn = new Matrix(nc, n);
        double[] dfn = this.m_dfn.internalStorage();
        for (int i = 0; i < n; ++i) {
            DataBlock cp = new DataBlock(this.m_ftry.getParameters());
            double dx = this.m_fn.getDomain().epsilon(cp, i);
            cp.set(i, cp.get(i) + dx);
            ISsqFunctionInstance ftmp = this.m_fn.ssqEvaluate(cp);
            double[] e = ftmp.getE();
            double grad = 0.0;
            for (int j = 0; j < ne; ++j) {
                e[j] = (e[j] - this.m_e[j]) / dx;
                grad += this.m_e[j] * e[j];
            }
            System.arraycopy(e, 0, dfn, nc * i, ne);
            this.m_beta[i] = -grad * 2.0;
        }
    }
}

