/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo.seriestest;

import ec.tstoolkit.data.DescriptiveStatistics;
import ec.tstoolkit.modelling.arima.tramo.seriestest.OverSeasTest;
import ec.tstoolkit.modelling.arima.tramo.seriestest.SerType;
import ec.tstoolkit.modelling.arima.tramo.spectrum.PeaksEnum;
import ec.tstoolkit.modelling.arima.tramo.spectrum.Spect;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsFrequency;

public class OverSeasTest2 {
    private TsData serie;
    private int checkQs;
    private int checkSNP;
    private int checkPeaks;
    private PeaksEnum[] peaks;
    private int diffSize;
    private int checkOverSeasTest;
    private SerType type;
    protected double crFseas;

    public double getCrFseas() {
        return this.crFseas;
    }

    public void setCrFseas(double crFseas) {
        this.crFseas = crFseas;
    }

    public int getCheckOverSeasTest() {
        return this.checkOverSeasTest;
    }

    public int getCheckPeaks() {
        return this.checkPeaks;
    }

    public int getCheckQs() {
        return this.checkQs;
    }

    public int getCheckSNP() {
        return this.checkSNP;
    }

    public OverSeasTest2(TsData targetS, PeaksEnum[] Peaks2, int DiffSize, SerType Type2) {
        this.serie = targetS;
        this.checkQs = 0;
        this.checkSNP = 0;
        this.checkPeaks = 0;
        this.peaks = Peaks2;
        this.diffSize = DiffSize;
        this.type = Type2;
        this.checkOverSeasTest = this.ComputeOverSeasTest2();
    }

    public OverSeasTest2(TsData targetS, PeaksEnum[] Peaks2, int DiffSize, SerType Type2, double Pseas) {
        this.serie = targetS;
        this.checkQs = 0;
        this.checkSNP = 0;
        this.checkPeaks = 0;
        this.peaks = Peaks2;
        this.diffSize = DiffSize;
        this.type = Type2;
        this.checkOverSeasTest = this.ComputeOverSeasTest2();
        if (Pseas > 0.995) {
            ++this.checkOverSeasTest;
            this.crFseas = 2.0;
        } else if (Pseas > 0.99) {
            ++this.checkOverSeasTest;
            this.crFseas = 1.0;
        } else {
            this.crFseas = 0.0;
        }
    }

    private int ComputeOverSeasTest2() {
        TsData targetS;
        DescriptiveStatistics bs;
        int retVal = 0;
        double SNPVal = 0.0;
        TsData diffS = this.serie.delta(1);
        if (this.type == SerType.Xlin) {
            bs = new DescriptiveStatistics(diffS);
            targetS = diffS.minus(bs.getAverage());
            SNPVal = OverSeasTest.Kendalls(targetS);
        } else {
            bs = new DescriptiveStatistics(this.serie);
            targetS = this.serie.minus(bs.getAverage());
            SNPVal = OverSeasTest.Kendalls(targetS);
        }
        if (SNPVal > 24.73 && this.serie.getFrequency() == TsFrequency.Monthly || SNPVal > 11.35 && this.serie.getFrequency() == TsFrequency.Quarterly) {
            ++retVal;
            this.checkSNP = 1;
        }
        int nLag = Math.max(Math.min(2, this.diffSize), 1);
        for (int i = 0; i < nLag; ++i) {
            diffS = diffS.delta(1);
        }
        DescriptiveStatistics bs2 = new DescriptiveStatistics(diffS);
        TsData targetS2 = diffS.minus(bs2.getAverage());
        double QS = OverSeasTest.CalcQs(targetS2);
        if (QS > 9.21) {
            ++retVal;
            this.checkQs = 1;
        }
        if (Spect.SeasSpectCrit(this.peaks, this.serie.getFrequency())) {
            ++retVal;
            this.checkPeaks = 1;
        }
        return retVal;
    }
}

