/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo.spectrum;

public class PeaksEnum {
    public final AR ar;
    public final Tukey tu;
    public static final PeaksEnum NONE = new PeaksEnum(AR.none, Tukey.none);
    public static final PeaksEnum UNDEF = new PeaksEnum(AR.undef, Tukey.undef);
    public static final PeaksEnum ALL = new PeaksEnum(AR.A, Tukey.T);

    public PeaksEnum(AR ar, Tukey tu) {
        this.ar = ar;
        this.tu = tu;
    }

    public int hashCode() {
        int hash = 3;
        hash = 73 * hash + (this.ar != null ? this.ar.hashCode() : 0);
        hash = 73 * hash + (this.tu != null ? this.tu.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof PeaksEnum && this.equals((PeaksEnum)obj);
    }

    public boolean equals(PeaksEnum peaks) {
        return this.ar == peaks.ar && this.tu == peaks.tu;
    }

    public String artoString() {
        if (this.ar == AR.A) {
            return "A";
        }
        if (this.ar == AR.a) {
            return "a";
        }
        if (this.ar == AR.none) {
            return "-";
        }
        return "n";
    }

    public String tutoString() {
        if (this.tu == Tukey.T) {
            return "T";
        }
        if (this.tu == Tukey.t) {
            return "t";
        }
        if (this.tu == Tukey.none) {
            return "-";
        }
        return "c";
    }

    public String toString() {
        return this.artoString() + this.tutoString();
    }

    public static enum AR {
        A,
        a,
        none,
        undef;


        public boolean isPresent() {
            return this == A || this == a;
        }
    }

    public static enum Tukey {
        T,
        t,
        none,
        undef;


        public boolean isPresent() {
            return this == T || this == t;
        }
    }
}

