/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.x13;

import ec.tstoolkit.eco.ConcentratedLikelihood;
import ec.tstoolkit.modelling.RegStatus;
import ec.tstoolkit.modelling.Variable;
import ec.tstoolkit.modelling.arima.DerivedRegressionTest;
import ec.tstoolkit.modelling.arima.IPreprocessingModule;
import ec.tstoolkit.modelling.arima.IRegressionTest;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.ProcessingResult;
import ec.tstoolkit.modelling.arima.SeparateRegressionTest;
import ec.tstoolkit.timeseries.regression.ILengthOfPeriodVariable;
import ec.tstoolkit.timeseries.regression.IMovingHolidayVariable;
import ec.tstoolkit.timeseries.regression.ITradingDaysVariable;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.regression.TsVariableSelection;

public class RegressionVariablesTest2
implements IPreprocessingModule {
    public static final double CVAL = 1.96;
    public static final double TSIG = 1.0;
    private IRegressionTest test_;
    private IRegressionTest mu_;
    private DerivedRegressionTest derived_;

    public RegressionVariablesTest2(double cval) {
        this.test_ = new SeparateRegressionTest(cval);
        this.derived_ = new DerivedRegressionTest(cval);
        this.mu_ = new SeparateRegressionTest(cval);
    }

    public RegressionVariablesTest2(double cval, double tsig) {
        this.test_ = new SeparateRegressionTest(cval);
        this.derived_ = new DerivedRegressionTest(cval);
        this.mu_ = new SeparateRegressionTest(tsig);
    }

    public void reset() {
    }

    @Override
    public ProcessingResult process(ModellingContext context) {
        ConcentratedLikelihood ll = context.estimation.getLikelihood();
        TsVariableList x = context.description.buildRegressionVariables();
        int start = context.description.getRegressionVariablesStartingPosition();
        boolean changed = false;
        TsVariableSelection<ITsVariable> tdsel = x.selectCompatible(ITradingDaysVariable.class);
        TsVariableSelection.Item<ITsVariable>[] tditems = tdsel.elements();
        boolean usetd = false;
        for (int i = 0; i < tditems.length; ++i) {
            Variable search = context.description.searchVariable((ITsVariable)tditems[i].variable);
            if (!search.status.needTesting()) continue;
            if (!this.test_.accept(ll, -1, start + tditems[i].position, tditems[i].variable.getDim(), null) && !this.derived_.accept(ll, -1, start + tditems[i].position, tditems[i].variable.getDim(), null)) {
                search.status = RegStatus.Rejected;
                changed = true;
                continue;
            }
            usetd = true;
        }
        TsVariableSelection<ITsVariable> lpsel = x.selectCompatible(ILengthOfPeriodVariable.class);
        TsVariableSelection.Item<ITsVariable>[] lpitems = lpsel.elements();
        for (int i = 0; i < lpitems.length; ++i) {
            Variable search = context.description.searchVariable((ITsVariable)lpitems[i].variable);
            if (!search.status.needTesting() || usetd && this.test_.accept(ll, -1, start + lpitems[i].position, lpitems[i].variable.getDim(), null)) continue;
            search.status = RegStatus.Rejected;
            changed = true;
        }
        TsVariableSelection<ITsVariable> mhsel = x.selectCompatible(IMovingHolidayVariable.class);
        TsVariableSelection.Item<ITsVariable>[] mhitems = mhsel.elements();
        for (int i = 0; i < mhitems.length; ++i) {
            Variable search = context.description.searchVariable((ITsVariable)mhitems[i].variable);
            if (!search.status.needTesting() || this.test_.accept(ll, -1, start + mhitems[i].position, mhitems[i].variable.getDim(), null)) continue;
            search.status = RegStatus.Rejected;
            changed = true;
        }
        if (context.automodelling && context.description.isEstimatedMean() && !this.mu_.accept(ll, -1, 0, 1, null)) {
            context.description.setMean(false);
            changed = true;
        }
        if (changed) {
            context.estimation = null;
            return ProcessingResult.Changed;
        }
        return ProcessingResult.Unchanged;
    }
}

