/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.sarima.estimation;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IDataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.Complex;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.realfunctions.FunctionException;
import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.maths.realfunctions.ParamValidation;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.sarima.estimation.SarimaMapping;

public class SarimaFixedMapping
implements IParametricMapping<SarimaModel> {
    final SarimaMapping mapper;
    final boolean[] fixedItems;
    final double[] parameters;
    private static final double RMAX = 0.99;
    private static final int MAX_ITER = 20;
    private static final double K = 0.2;
    private static final double MK = -1.25;

    public boolean[] getFixedItems() {
        return (boolean[])this.fixedItems.clone();
    }

    public SarimaFixedMapping(SarimaSpecification start, IReadDataBlock p, boolean[] fixed) {
        this.mapper = new SarimaMapping(start, false);
        this.fixedItems = (boolean[])fixed.clone();
        this.parameters = new double[p.getLength()];
        p.copyTo(this.parameters, 0);
    }

    public SarimaFixedMapping(SarimaSpecification start, double[] p, boolean[] fixed) {
        this.mapper = new SarimaMapping(start, false);
        this.fixedItems = (boolean[])fixed.clone();
        this.parameters = p;
    }

    @Override
    public boolean checkBoundaries(IReadDataBlock inparams) {
        return this.mapper.checkBoundaries(this.fullParameters(inparams));
    }

    @Override
    public double epsilon(IReadDataBlock inparams, int idx) {
        return this.mapper.epsilon(this.fullParameters(inparams), this.fullIndex(idx));
    }

    private int fixed() {
        int n = 0;
        for (int i = 0; i < this.fixedItems.length; ++i) {
            if (!this.fixedItems[i]) continue;
            ++n;
        }
        return n;
    }

    public IReadDataBlock freeParameters(IReadDataBlock allParams) {
        DataBlock free = new DataBlock(this.getDim());
        this.save(allParams, free);
        return free;
    }

    public int fullIndex(int freeIndex) {
        int cur = -1;
        for (int i = 0; i < this.fixedItems.length; ++i) {
            if (!this.fixedItems[i]) {
                ++cur;
            }
            if (cur != freeIndex) continue;
            return i;
        }
        return -1;
    }

    public DataBlock fullParameters(IReadDataBlock freeParams) {
        double[] buffer = (double[])this.parameters.clone();
        int i = 0;
        int j = 0;
        while (i < freeParams.getLength()) {
            while (this.fixedItems[j]) {
                ++j;
            }
            buffer[j] = freeParams.get(i);
            ++i;
            ++j;
        }
        return new DataBlock(buffer);
    }

    @Override
    public int getDim() {
        return this.mapper.spec.getParametersCount() - this.fixed();
    }

    @Override
    public double lbound(int idx) {
        return this.mapper.lbound(this.fullIndex(idx));
    }

    @Override
    public SarimaModel map(IReadDataBlock p) {
        return this.mapper.map(this.fullParameters(p));
    }

    @Override
    public IReadDataBlock map(SarimaModel t) {
        return this.freeParameters(this.mapper.map(t));
    }

    private void save(IReadDataBlock all, IDataBlock free) {
        int j = 0;
        for (int i = 0; i < this.fixedItems.length; ++i) {
            if (this.fixedItems[i]) continue;
            free.set(j++, all.get(i));
        }
    }

    @Override
    public double ubound(int idx) {
        return this.mapper.ubound(this.fullIndex(idx));
    }

    @Override
    public ParamValidation validate(IDataBlock ioparams) {
        DataBlock tmp = this.fullParameters(ioparams);
        if (this.mapper.checkBoundaries(tmp)) {
            this.save(tmp, ioparams);
            return ParamValidation.Valid;
        }
        int beg = 0;
        int end = this.mapper.spec.getP();
        boolean changed = false;
        if (beg != end) {
            if (this.isFree(beg, end)) {
                if (SarimaFixedMapping.stabilize(tmp, beg, end - beg, 0.99)) {
                    changed = true;
                }
            } else if (this.fstabilize(tmp, beg, end - beg)) {
                changed = true;
            }
        }
        if ((beg = end) != (end += this.mapper.spec.getBP())) {
            if (this.isFree(beg, end)) {
                if (SarimaFixedMapping.stabilize(tmp, beg, end - beg, 0.99)) {
                    changed = true;
                }
            } else if (this.fstabilize(tmp, beg, end - beg)) {
                changed = true;
            }
        }
        if ((beg = end) != (end += this.mapper.spec.getQ())) {
            if (this.isFree(beg, end)) {
                if (SarimaFixedMapping.stabilize(tmp, beg, end - beg, 1.0)) {
                    changed = true;
                }
            } else if (this.fstabilize(tmp, beg, end - beg)) {
                changed = true;
            }
        }
        if ((beg = end) != (end += this.mapper.spec.getBQ())) {
            if (this.isFree(beg, end)) {
                if (SarimaFixedMapping.stabilize(tmp, beg, end - beg, 1.0)) {
                    changed = true;
                }
            } else if (this.fstabilize(tmp, beg, end - beg)) {
                changed = true;
            }
        }
        if (changed) {
            this.save(tmp, ioparams);
            return ParamValidation.Changed;
        }
        return ParamValidation.Valid;
    }

    public Matrix expandCovariance(Matrix cov) {
        int dim = this.getDim();
        if (cov.getColumnsCount() != dim) {
            return null;
        }
        int[] idx = new int[dim];
        int j = 0;
        for (int i = 0; i < this.fixedItems.length; ++i) {
            if (this.fixedItems[i]) continue;
            idx[j++] = i;
        }
        Matrix ecov = new Matrix(this.fixedItems.length, this.fixedItems.length);
        for (int i = 0; i < dim; ++i) {
            for (int j2 = 0; j2 <= i; ++j2) {
                double s = cov.get(i, j2);
                ecov.set(idx[i], idx[j2], s);
                if (i == j2) continue;
                ecov.set(idx[j2], idx[i], s);
            }
        }
        return ecov;
    }

    private boolean isFree(int beg, int end) {
        for (int i = beg; i < end; ++i) {
            if (!this.fixedItems[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean stabilize(IDataBlock c, int start, int nc, double rmax) {
        Polynomial sp;
        if (nc == 0) {
            return false;
        }
        if (SarimaMapping.checkStability(c, start, nc)) {
            return false;
        }
        if (nc == 1) {
            double c0 = c.get(start);
            double cabs = Math.abs(c0);
            if (rmax < 1.0 && Math.abs(cabs - 1.0) <= 0.01) {
                c.set(start, c0 > 0.0 ? rmax : -rmax);
                return true;
            }
            if (cabs > 1.0) {
                c.set(start, 1.0 / c0);
                return true;
            }
            return false;
        }
        double[] ctmp = new double[nc + 1];
        ctmp[0] = 1.0;
        for (int i = 0; i < nc; ++i) {
            ctmp[1 + i] = c.get(start + i);
        }
        Polynomial p = Polynomial.of(ctmp);
        if (p != (sp = SarimaFixedMapping.stabilize(p, rmax))) {
            for (int i = 0; i < nc; ++i) {
                c.set(start + i, sp.get(1 + i));
            }
            return true;
        }
        return false;
    }

    private static Polynomial stabilize(Polynomial p, double rmax) {
        if (p == null) {
            return null;
        }
        Complex[] roots = p.roots();
        boolean changed = false;
        for (int i = 0; i < roots.length; ++i) {
            Complex root = roots[i];
            double n = 1.0 / roots[i].abs();
            if (rmax < 1.0 && Math.abs(n - 1.0) <= 0.01) {
                roots[i] = root.times(n / rmax);
                changed = true;
                continue;
            }
            if (!(n > 1.0)) continue;
            roots[i] = root.inv();
            changed = true;
        }
        if (!changed) {
            return p;
        }
        Polynomial ptmp = Polynomial.fromComplexRoots(roots);
        ptmp = ptmp.divide(ptmp.get(0));
        return ptmp;
    }

    private boolean fstabilize(DataBlock ioparams, int beg, int n) {
        DataBlock extract = ioparams.extract(beg, n);
        if (SarimaMapping.checkStability(extract, 0, n)) {
            return false;
        }
        DataBlock tmp = new DataBlock(n);
        int k = 0;
        do {
            for (int i = 0; i < n; ++i) {
                int j;
                if (this.fixedItems[beg + i]) continue;
                tmp.copy(extract);
                for (j = 0; j < n; ++j) {
                    if (this.fixedItems[beg + j]) continue;
                    tmp.set(j, 0.0);
                }
                tmp.set(i, 0.2);
                for (j = 0; j < 10; ++j) {
                    if (SarimaMapping.checkStability(tmp, 0, n)) {
                        extract.copy(tmp);
                        return true;
                    }
                    tmp.mul(i, -1.25);
                }
            }
        } while (++k <= 20);
        throw new FunctionException("Invalid mapping");
    }

    @Override
    public String getDescription(int idx) {
        return this.mapper.getDescription(this.fullIndex(idx));
    }
}

