/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockStorage;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixStorage;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;

public class SmoothingResults {
    private int m_r;
    private int m_n;
    private int m_start;
    private DataBlockStorage m_a;
    private MatrixStorage m_P;
    private double[] m_c;
    private double[] m_cvar;
    private boolean m_bP = false;
    private boolean m_bA = true;
    private double m_ser = 1.0;
    private double m_ser2 = 1.0;

    public SmoothingResults() {
    }

    public SmoothingResults(boolean hasData, boolean hasVar) {
        this.m_bA = hasData;
        this.m_bP = hasVar;
    }

    public DataBlock A(int idx) {
        return this.m_a == null || idx < this.m_start ? null : this.m_a.block(idx - this.m_start);
    }

    public double getStandardError() {
        return this.m_ser;
    }

    public void setStandardError(double value) {
        this.m_ser = value;
        this.m_ser2 = value * value;
    }

    private int check(DataBlock z) {
        int idx = -1;
        for (int i = 0; i < z.getLength(); ++i) {
            if (z.get(i) == 0.0) continue;
            if (idx != -1) {
                return -1;
            }
            idx = i;
        }
        return idx;
    }

    public void clear() {
        this.m_a = null;
        this.m_P = null;
    }

    public double[] component(int idx) {
        if (this.m_a == null) {
            return null;
        }
        double[] c = new double[this.m_n - this.m_start];
        this.m_a.item(idx).copyTo(c, 0);
        return c;
    }

    public double[] componentCovar(int i, int j) {
        if (this.m_P == null) {
            return null;
        }
        int n = this.m_n - this.m_start;
        double[] c = new double[n];
        for (int z = 0; z < n; ++z) {
            c[z] = this.m_P.matrix(z).get(i, j) * this.m_ser2;
        }
        return c;
    }

    public double[] componentStdev(int idx) {
        double[] c = this.componentVar(idx);
        if (c != null) {
            for (int i = 0; i < this.m_n; ++i) {
                c[i] = Math.sqrt(c[i]);
            }
        }
        return c;
    }

    public double[] componentVar(int idx) {
        return this.componentCovar(idx, idx);
    }

    public int getComponentsCount() {
        return this.m_r;
    }

    public double[] getSmoothations() {
        return this.m_c;
    }

    public double[] getSmoothationsVariance() {
        return this.m_cvar;
    }

    public DataBlockStorage getSmoothedStates() {
        return this.m_a;
    }

    public MatrixStorage getSmoothedStatesVariance() {
        return this.m_P;
    }

    public boolean isSavingA() {
        return this.m_bA;
    }

    public boolean isSavingP() {
        return this.m_bP;
    }

    public SubMatrix P(int idx) {
        return this.m_P == null || idx < this.m_start ? null : this.m_P.matrix(idx - this.m_start);
    }

    public void prepare(int n, int r) {
        int nz = n - this.m_start;
        this.m_n = n;
        this.m_r = r;
        this.clear();
        if (this.m_bA) {
            this.m_a = new DataBlockStorage(this.m_r, nz);
        }
        if (this.m_bP) {
            this.m_P = new MatrixStorage(this.m_r, nz);
        }
        this.m_c = new double[nz];
        this.m_cvar = new double[nz];
    }

    public void save(int pos, DataBlock a, Matrix p, double c, double cvar) {
        int np = pos - this.m_start;
        if (np < 0) {
            return;
        }
        if (this.m_bA) {
            this.m_a.save(np, a);
        }
        if (this.m_bP && p != null) {
            this.m_P.save(np, p);
        }
        this.m_c[np] = c;
        this.m_cvar[np] = cvar;
    }

    public void setSaveA(boolean value) {
        this.m_bA = value;
        this.clear();
    }

    public void setSaveP(boolean value) {
        this.m_bP = value;
        this.clear();
    }

    public int getSavingStart() {
        return this.m_start;
    }

    public void setSavingStart(int start) {
        this.m_start = start;
        this.clear();
    }

    public double[] zcomponent(DataBlock z) {
        int iz = this.check(z);
        if (iz >= 0) {
            return this.component(iz);
        }
        if (this.m_a == null) {
            return null;
        }
        if (this.m_r != z.getLength()) {
            return null;
        }
        int n = this.m_n - this.m_start;
        double[] c = new double[n];
        for (int i = 0; i < n; ++i) {
            c[i] = this.m_a.block(i).dot(z);
        }
        return c;
    }

    public double zcomponent(int idx, DataBlock z) {
        return this.m_a == null || idx < this.m_start ? Double.NaN : this.m_a.block(idx - this.m_start).dot(z);
    }

    public double[] zvariance(DataBlock z) {
        if (this.m_P == null) {
            return null;
        }
        if (this.m_r != z.getLength()) {
            return null;
        }
        int iz = this.check(z);
        double[] var = new double[this.m_n - this.m_start];
        if (iz >= 0) {
            return this.componentVar(iz);
        }
        for (int i = 0; i < this.m_n - this.m_start; ++i) {
            var[i] = SymmetricMatrix.quadraticForm(this.m_P.matrix(i), z) * this.m_ser2;
        }
        return var;
    }

    public double zvariance(int idx, DataBlock z) {
        return this.m_P == null || idx < this.m_start ? Double.NaN : SymmetricMatrix.quadraticForm(this.m_P.matrix(idx - this.m_start), z) * this.m_ser2;
    }
}

