/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf.multivariate;

import ec.tstoolkit.ssf.multivariate.IMUMap;
import ec.tstoolkit.ssf.multivariate.M2uEntry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class M2uMap
implements IMUMap {
    private final List<M2uEntry> m_list;
    private final Map<M2uEntry, Integer> m_map;
    private int m_icur = 0;
    private boolean m_bclosed;

    public M2uMap() {
        this.m_list = new ArrayList<M2uEntry>();
        this.m_map = new HashMap<M2uEntry, Integer>();
    }

    public M2uMap(int minSize) {
        this.m_list = new ArrayList<M2uEntry>(minSize);
        this.m_map = new HashMap<M2uEntry, Integer>();
    }

    public void add(int it, int ivar) {
        if (this.m_bclosed) {
            return;
        }
        M2uEntry entry = new M2uEntry(it, ivar);
        this.m_list.add(entry);
        this.m_map.put(entry, this.m_icur++);
    }

    public void clear() {
        if (this.m_bclosed) {
            return;
        }
        this.m_list.clear();
        this.m_map.clear();
        this.m_icur = 0;
    }

    public void close() {
        this.m_bclosed = true;
    }

    @Override
    public M2uEntry get(int s) {
        return this.m_list.get(s);
    }

    @Override
    public int get(int it, int ivar) {
        Integer s = this.m_map.get(new M2uEntry(it, ivar));
        return s == null ? -1 : s;
    }

    public int getCount() {
        return this.m_icur;
    }

    public boolean isClosed() {
        return this.m_bclosed;
    }
}

