/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf.multivariate;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.SubArrayOfInt;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.multivariate.FullM2uMap;
import ec.tstoolkit.ssf.multivariate.IMUMap;
import ec.tstoolkit.ssf.multivariate.IMultivariateSsf;
import ec.tstoolkit.ssf.multivariate.M2uEntry;
import ec.tstoolkit.ssf.multivariate.M2uMap;

public class M2uSsfAdapter
implements ISsf {
    protected IMultivariateSsf m_mssf;
    protected IMUMap m_map;
    protected int m_cur = -1;
    protected M2uEntry m_entry;
    protected DataBlock m_z;

    public static IMUMap createMap(IMultivariateSsf mssf, int tmax) {
        int nvars = mssf.getVarsCount();
        int nentry = 0;
        for (int pos = 0; pos < tmax; ++pos) {
            for (int v = 0; v < nvars; ++v) {
                if (!mssf.hasZ(pos, v)) continue;
                ++nentry;
            }
        }
        if (nentry == nvars * tmax) {
            return new FullM2uMap(nvars);
        }
        M2uMap map = new M2uMap(nentry);
        for (int pos = 0; pos < tmax; ++pos) {
            for (int v = 0; v < nvars; ++v) {
                if (!mssf.hasZ(pos, v)) continue;
                map.add(pos, v);
            }
        }
        map.close();
        return map;
    }

    public M2uSsfAdapter(IMultivariateSsf mssf, IMUMap map) {
        this.m_mssf = mssf;
        this.m_map = map;
        this.m_z = new DataBlock(this.m_mssf.getStateDim());
    }

    @Override
    public void diffuseConstraints(SubMatrix b0) {
        this.m_mssf.diffuseConstraints(b0);
    }

    @Override
    public void fullQ(int pos, SubMatrix q) {
        this.updateEntry(pos);
        if (this.m_entry.ivar + 1 == this.m_mssf.getVarsCount()) {
            this.m_mssf.fullQ(this.m_entry.it, q);
        }
    }

    public IMultivariateSsf getMSsf() {
        return this.m_mssf;
    }

    @Override
    public int getNonStationaryDim() {
        return this.m_mssf.getNonStationaryDim();
    }

    @Override
    public int getStateDim() {
        return this.m_mssf.getStateDim();
    }

    @Override
    public int getTransitionResCount() {
        return this.m_mssf.getTransitionResCount();
    }

    @Override
    public int getTransitionResDim() {
        return this.m_mssf.getTransitionResDim();
    }

    @Override
    public boolean hasR() {
        return this.m_mssf.hasR();
    }

    @Override
    public boolean hasTransitionRes(int pos) {
        this.updateEntry(pos);
        return this.m_entry.ivar + 1 == this.m_mssf.getVarsCount();
    }

    @Override
    public boolean hasW() {
        return this.m_mssf.hasW();
    }

    @Override
    public boolean isDiffuse() {
        return this.m_mssf.isDiffuse();
    }

    @Override
    public boolean isMeasurementEquationTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTransitionEquationTimeInvariant() {
        return false;
    }

    @Override
    public boolean isTransitionResidualTimeInvariant() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.m_mssf.isValid();
    }

    @Override
    public void L(int pos, DataBlock k, SubMatrix l) {
        this.T(pos, l);
        this.m_z.set(0.0);
        this.Z(pos, this.m_z);
        DataBlockIterator cols = l.columns();
        DataBlock col = cols.getData();
        do {
            double z = this.m_z.get(cols.getPosition());
            col.addAY(-z, k);
        } while (cols.next());
    }

    @Override
    public void Pf0(SubMatrix pf0) {
        this.m_mssf.Pf0(pf0);
    }

    @Override
    public void Pi0(SubMatrix pi0) {
        this.m_mssf.Pi0(pi0);
    }

    @Override
    public void Q(int pos, SubMatrix q) {
        this.updateEntry(pos);
        if (this.m_entry.ivar + 1 == this.m_mssf.getVarsCount()) {
            this.m_mssf.Q(this.m_entry.it, q);
        }
    }

    @Override
    public void R(int pos, SubArrayOfInt r) {
        this.updateEntry(pos);
        if (this.m_entry.ivar + 1 == this.m_mssf.getVarsCount()) {
            this.m_mssf.R(this.m_entry.it, r);
        }
    }

    @Override
    public void T(int pos, SubMatrix tr) {
        this.updateEntry(pos);
        if (this.m_entry.ivar + 1 != this.m_mssf.getVarsCount()) {
            tr.set(0.0);
            tr.diagonal().set(1.0);
        } else {
            this.m_mssf.T(this.m_entry.it, tr);
        }
    }

    @Override
    public void TVT(int pos, SubMatrix v) {
        this.updateEntry(pos);
        if (this.m_entry.ivar + 1 == this.m_mssf.getVarsCount()) {
            this.m_mssf.TVT(this.m_entry.it, v);
        }
    }

    @Override
    public void TX(int pos, DataBlock x) {
        this.updateEntry(pos);
        if (this.m_entry.ivar + 1 == this.m_mssf.getVarsCount()) {
            this.m_mssf.TX(this.m_entry.it, x);
        }
    }

    protected void updateEntry(int pos) {
        if (pos != this.m_cur) {
            this.m_cur = pos;
            this.m_entry = this.m_map.get(pos);
        }
    }

    @Override
    public void VpZdZ(int pos, SubMatrix v, double d) {
        this.updateEntry(pos);
        this.m_mssf.VpZdZ(this.m_entry.it, this.m_entry.ivar, this.m_entry.ivar, v, d);
    }

    @Override
    public void W(int pos, SubMatrix w) {
        this.updateEntry(pos);
        if (this.m_entry.ivar + 1 == this.m_mssf.getVarsCount()) {
            this.m_mssf.W(this.m_entry.it, w);
        }
    }

    @Override
    public void XpZd(int pos, DataBlock x, double d) {
        this.updateEntry(pos);
        this.m_mssf.XpZd(this.m_entry.it, this.m_entry.ivar, x, d);
    }

    @Override
    public void XT(int pos, DataBlock x) {
        this.updateEntry(pos);
        if (this.m_entry.ivar + 1 == this.m_mssf.getVarsCount()) {
            this.m_mssf.XT(this.m_entry.it, x);
        }
    }

    @Override
    public void Z(int pos, DataBlock z) {
        this.updateEntry(pos);
        this.m_mssf.Z(this.m_entry.it, this.m_entry.ivar, z);
    }

    @Override
    public void ZM(int pos, SubMatrix M, DataBlock zm) {
        this.updateEntry(pos);
        this.m_mssf.ZM(this.m_entry.it, this.m_entry.ivar, M, zm);
    }

    @Override
    public double ZVZ(int pos, SubMatrix v) {
        this.updateEntry(pos);
        return this.m_mssf.ZVZ(this.m_entry.it, this.m_entry.ivar, this.m_entry.ivar, v);
    }

    @Override
    public double ZX(int pos, DataBlock x) {
        this.updateEntry(pos);
        return this.m_mssf.ZX(this.m_entry.it, this.m_entry.ivar, x);
    }
}

