/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.stats;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.dstats.F;
import ec.tstoolkit.dstats.TestType;
import ec.tstoolkit.eco.ConcentratedLikelihood;
import ec.tstoolkit.eco.RegModel;
import ec.tstoolkit.maths.matrices.HouseholderR;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.maths.matrices.UpperTriangularMatrix;
import ec.tstoolkit.stats.StatisticalTest;
import java.util.Arrays;
import java.util.List;

public class Anova {
    private static final double EPS = 1.0E-9;
    private final double rssq;
    private final int rdf;
    private final Row[] rows;

    public Anova(RegModel model, int[] groups) {
        HouseholderR qr = new HouseholderR(false);
        qr.setEpsilon(1.0E-9);
        qr.decompose(model.variables());
        ConcentratedLikelihood[] ll = this.nestedModelsEstimation(model.isMeanCorrection(), qr, model.getY(), groups);
        this.rssq = ll[groups.length].getSsqErr();
        this.rdf = ll[groups.length].getDegreesOfFreedom(true, 0);
        this.rows = new Row[groups.length];
        for (int i = 0; i < this.rows.length; ++i) {
            int df = ll[i].getDegreesOfFreedom(true, 0) - ll[i + 1].getDegreesOfFreedom(true, 0);
            double dssq = ll[i].getSsqErr() - ll[i + 1].getSsqErr();
            this.rows[i] = new Row(df, dssq);
        }
    }

    public int getResidualsDegeesOfFreedom() {
        return this.rdf;
    }

    public double getResidualsSsq() {
        return this.rssq;
    }

    public List<Row> getRows() {
        return Arrays.asList(this.rows);
    }

    private ConcentratedLikelihood likelihood(HouseholderR qr, DataBlock y, int nvars) {
        int rank = qr.rank(nvars);
        int n = qr.getEquationsCount();
        DataBlock res = new DataBlock(n - rank);
        DataBlock b = new DataBlock(rank);
        qr.partialLeastSquares(y, b, res);
        ConcentratedLikelihood ll = new ConcentratedLikelihood();
        double ssqerr = res.ssq();
        Matrix u = UpperTriangularMatrix.inverse(qr.getR());
        double sig = ssqerr / (double)n;
        Matrix bvar = SymmetricMatrix.XXt(u);
        bvar.mul(sig);
        ll.set(ssqerr, 0.0, n);
        ll.setRes(res.getData());
        ll.setB(b.getData(), bvar, rank);
        return ll;
    }

    private ConcentratedLikelihood[] nestedModelsEstimation(boolean mean, HouseholderR qr, DataBlock y, int[] groups) {
        ConcentratedLikelihood[] ll = new ConcentratedLikelihood[groups.length + 1];
        int n = mean ? 1 : 0;
        ll[0] = this.likelihood(qr, y, n);
        for (int i = 0; i < groups.length; ++i) {
            ll[i + 1] = this.likelihood(qr, y, n += groups[i]);
        }
        return ll;
    }

    public final class Row {
        public final int df;
        public final double ssq;

        Row(int df, double ssq) {
            this.df = df;
            this.ssq = ssq;
        }

        public double mssq() {
            return this.ssq / (double)this.df;
        }

        public StatisticalTest ftest() {
            F f = new F();
            f.setDFNum(this.df);
            f.setDFDenom(Anova.this.rdf);
            double val = this.ssq * (double)Anova.this.rdf / ((double)this.df * Anova.this.rssq);
            return new StatisticalTest(f, val, TestType.Upper, true);
        }
    }
}

