/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.stats;

import ec.tstoolkit.data.DescriptiveStatistics;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.dstats.Chi2;
import ec.tstoolkit.dstats.TestType;
import ec.tstoolkit.stats.StatisticalTest;

public class DoornikHansenTest
extends StatisticalTest {
    DescriptiveStatistics stats;

    @Override
    public boolean isValid() {
        return this.stats != null && this.stats.getDataCount() > 7;
    }

    private void test() {
        double sk = this.stats.getSkewness();
        double n = this.stats.getDataCount();
        if (n <= 7.0) {
            return;
        }
        double b = 3.0 * (n * n + 27.0 * n - 70.0) * (n + 1.0) * (n + 3.0) / ((n - 2.0) * (n + 5.0) * (n + 7.0) * (n + 9.0));
        double w2 = -1.0 + Math.sqrt(2.0 * (b - 1.0));
        double ds = 1.0 / Math.sqrt(0.5 * Math.log(w2));
        double y = sk * Math.sqrt((w2 - 1.0) * (n + 1.0) * (n + 3.0) / (12.0 * (n - 2.0)));
        double z1 = ds * Math.log(y + Math.sqrt(y * y + 1.0));
        double kr = this.stats.getKurtosis();
        double dk = (n - 3.0) * (n + 1.0) * (n * n + 15.0 * n - 4.0);
        double a = (n - 2.0) * (n + 5.0) * (n + 7.0) * (n * n + 27.0 * n - 70.0) / (dk * 6.0);
        double c = (n - 7.0) * (n + 5.0) * (n + 7.0) * (n * n + 2.0 * n - 5.0) / (dk * 6.0);
        double k = (n + 5.0) * (n + 7.0) * (n * n * n + n * n * 37.0 + 11.0 * n - 313.0) / (dk * 12.0);
        double alpha = a + c * sk * sk;
        double chi = 2.0 * k * (kr - 1.0 - sk * sk);
        double z2 = Math.sqrt(alpha * 9.0) * (Math.pow(chi / (2.0 * alpha), 0.3333333333333333) - 1.0 + 1.0 / (9.0 * alpha));
        this.m_val = z1 * z1 + z2 * z2;
        Chi2 chi2 = new Chi2();
        chi2.setDegreesofFreedom(2);
        this.m_dist = chi2;
        this.m_type = TestType.Upper;
        this.m_asympt = true;
    }

    public void test(DescriptiveStatistics stats) {
        this.stats = stats;
        this.test();
    }

    public void test(IReadDataBlock data) {
        this.stats = new DescriptiveStatistics(data);
        this.test();
    }
}

