/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.structural;

import ec.tstoolkit.Parameter;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.structural.Component;
import ec.tstoolkit.structural.ComponentUse;
import ec.tstoolkit.structural.SeasonalModel;
import java.util.Map;
import java.util.Objects;

public class ModelSpecification
implements IProcSpecification,
Cloneable {
    public static final String LUSE = "luse";
    public static final String SUSE = "suse";
    public static final String NUSE = "nuse";
    public static final String SEASMODEL = "seasmodel";
    public static final String CUSE = "cuse";
    public static final String CDUMP = "cdump";
    public static final String CLENGTH = "clength";
    ComponentUse lUse = ComponentUse.Free;
    ComponentUse sUse = ComponentUse.Free;
    ComponentUse cUse = ComponentUse.Unused;
    ComponentUse nUse = ComponentUse.Free;
    SeasonalModel seasModel = SeasonalModel.Trigonometric;
    Parameter cdump;
    Parameter clength;

    @Override
    public ModelSpecification clone() {
        try {
            ModelSpecification clone = (ModelSpecification)super.clone();
            if (this.cdump != null) {
                clone.cdump = this.cdump.clone();
            }
            if (this.clength != null) {
                clone.clength = this.clength.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public Parameter getCyclicalDumpingFactor() {
        return this.cdump;
    }

    public Parameter getCyclicalPeriod() {
        return this.clength;
    }

    public void setCyclicalDumpingFactor(Parameter value) {
        this.cdump = value;
    }

    public void setCyclicalPeriod(Parameter value) {
        this.clength = value;
    }

    public void fixComponent(Component cmp) {
        switch (cmp) {
            case Level: {
                this.lUse = ComponentUse.Fixed;
                return;
            }
            case Slope: {
                this.sUse = ComponentUse.Fixed;
                return;
            }
            case Seasonal: {
                this.seasModel = SeasonalModel.Fixed;
                return;
            }
            case Cycle: {
                this.cUse = ComponentUse.Fixed;
                return;
            }
            case Noise: {
                this.nUse = ComponentUse.Fixed;
            }
        }
    }

    public ComponentUse getCycleUse() {
        return this.cUse;
    }

    public ComponentUse getLevelUse() {
        return this.lUse;
    }

    public ComponentUse getNoiseUse() {
        return this.nUse;
    }

    public SeasonalModel getSeasonalModel() {
        return this.seasModel;
    }

    public ComponentUse getSeasUse() {
        if (this.seasModel == SeasonalModel.Unused) {
            return ComponentUse.Unused;
        }
        if (this.seasModel == SeasonalModel.Fixed) {
            return ComponentUse.Fixed;
        }
        return ComponentUse.Free;
    }

    public ComponentUse getSlopeUse() {
        return this.sUse;
    }

    public boolean hasCycle() {
        return this.cUse != ComponentUse.Unused;
    }

    public boolean hasLevel() {
        return this.lUse != ComponentUse.Unused;
    }

    public boolean hasNoise() {
        return this.nUse != ComponentUse.Unused;
    }

    public boolean hasSeasonal() {
        return this.seasModel != SeasonalModel.Unused;
    }

    public boolean hasSlope() {
        return this.sUse != ComponentUse.Unused;
    }

    public void setSeasonalModel(SeasonalModel value) {
        if (value != this.seasModel) {
            this.seasModel = value;
        }
    }

    public void useCycle(ComponentUse value) {
        this.cUse = value;
        if (this.cUse != ComponentUse.Unused) {
            if (this.cdump == null) {
                this.cdump = new Parameter();
            }
            if (this.clength == null) {
                this.clength = new Parameter();
            }
        }
    }

    public void useLevel(ComponentUse value) {
        this.lUse = value;
        if (value == ComponentUse.Unused) {
            this.sUse = ComponentUse.Unused;
        }
    }

    public void useNoise(ComponentUse value) {
        this.nUse = value;
    }

    public void useSlope(ComponentUse value) {
        if (value != ComponentUse.Unused && this.lUse == ComponentUse.Unused) {
            return;
        }
        this.sUse = value;
    }

    @Override
    public InformationSet write(boolean verbose) {
        InformationSet info = new InformationSet();
        if (this.lUse != ComponentUse.Unused || verbose) {
            info.set(LUSE, this.lUse.name());
        }
        if (this.sUse != ComponentUse.Unused || verbose) {
            info.set(SUSE, this.sUse.name());
        }
        if (this.cUse != ComponentUse.Unused || verbose) {
            info.set(CUSE, this.cUse.name());
        }
        if (this.nUse != ComponentUse.Unused || verbose) {
            info.set(NUSE, this.nUse.name());
        }
        if (this.seasModel != SeasonalModel.Unused || verbose) {
            info.set(SEASMODEL, this.seasModel.name());
        }
        if (this.cUse != ComponentUse.Unused) {
            if (!Parameter.isDefault(this.cdump)) {
                info.set(CDUMP, this.cdump);
            }
            if (!Parameter.isDefault(this.clength)) {
                info.set(CLENGTH, this.clength);
            }
        }
        return info;
    }

    @Override
    public boolean read(InformationSet info) {
        String s = info.get(LUSE, String.class);
        if (s != null) {
            this.lUse = ComponentUse.valueOf(s);
        }
        if ((s = info.get(SUSE, String.class)) != null) {
            this.sUse = ComponentUse.valueOf(s);
        }
        if ((s = info.get(CUSE, String.class)) != null) {
            this.cUse = ComponentUse.valueOf(s);
        }
        if ((s = info.get(NUSE, String.class)) != null) {
            this.nUse = ComponentUse.valueOf(s);
        }
        if ((s = info.get(SEASMODEL, String.class)) != null) {
            this.seasModel = SeasonalModel.valueOf(s);
        }
        if (this.cUse != ComponentUse.Unused) {
            Parameter p = info.get(CDUMP, Parameter.class);
            if (p != null) {
                this.cdump = p;
            }
            if ((p = info.get(CLENGTH, Parameter.class)) != null) {
                this.clength = p;
            }
        }
        return true;
    }

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(InformationSet.item(prefix, LUSE), String.class);
        dic.put(InformationSet.item(prefix, SUSE), String.class);
        dic.put(InformationSet.item(prefix, NUSE), String.class);
        dic.put(InformationSet.item(prefix, CUSE), String.class);
        dic.put(InformationSet.item(prefix, CDUMP), Parameter.class);
        dic.put(InformationSet.item(prefix, CLENGTH), Parameter.class);
        dic.put(InformationSet.item(prefix, SEASMODEL), String.class);
    }

    public int getParametersCount() {
        int n = 0;
        if (this.lUse == ComponentUse.Free) {
            ++n;
        }
        if (this.sUse == ComponentUse.Free) {
            ++n;
        }
        if (this.nUse == ComponentUse.Free) {
            ++n;
        }
        if (this.seasModel != SeasonalModel.Fixed && this.seasModel != SeasonalModel.Unused) {
            ++n;
        }
        return n += this.getCycleParametersCount();
    }

    public int getCycleParametersCount() {
        int n;
        if (this.cUse == ComponentUse.Unused) {
            return 0;
        }
        int n2 = n = this.cUse == ComponentUse.Fixed ? 0 : 1;
        if (this.cdump == null || !this.cdump.isFixed()) {
            ++n;
        }
        if (this.clength == null || !this.clength.isFixed()) {
            ++n;
        }
        return n;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof ModelSpecification && this.equals((ModelSpecification)obj);
    }

    public int hashCode() {
        int hash = 3;
        hash = 61 * hash + Objects.hashCode((Object)this.lUse);
        hash = 61 * hash + Objects.hashCode((Object)this.sUse);
        hash = 61 * hash + Objects.hashCode((Object)this.cUse);
        hash = 61 * hash + Objects.hashCode((Object)this.nUse);
        hash = 61 * hash + Objects.hashCode((Object)this.seasModel);
        return hash;
    }

    private boolean equals(ModelSpecification spec) {
        return spec.lUse == this.lUse && spec.sUse == this.sUse && spec.nUse == this.nUse && spec.cUse == this.cUse && spec.seasModel == this.seasModel && Objects.deepEquals(spec.cdump, this.cdump) && Objects.deepEquals(spec.clength, this.clength);
    }
}

