/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.analysis;

import ec.tstoolkit.data.AutoRegressiveSpectrum;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DescriptiveStatistics;
import ec.tstoolkit.data.Periodogram;
import ec.tstoolkit.timeseries.simplets.TsData;

public class SpectralDiagnostic {
    private double[] svals_;
    private double[] freqs_;
    private int[] seasfreq_;
    private int[] tdfreq_;
    private int nar_ = 30;
    private int npoints_ = 60;
    private double sensibility_ = 0.11538461538461539;
    private double srange_;
    private double median_;

    public boolean test(TsData ts) {
        try {
            int i;
            AutoRegressiveSpectrum ars = new AutoRegressiveSpectrum(AutoRegressiveSpectrum.Method.Ols);
            int freq = ts.getFrequency().intValue();
            double[] tdfreq = Periodogram.getTradingDaysFrequencies(freq);
            int nsf = freq >= 4 ? (freq - 1) / 2 : freq / 2;
            this.seasfreq_ = new int[nsf];
            int iseas = 2 * this.npoints_ / freq;
            for (int i2 = 0; i2 < this.seasfreq_.length; ++i2) {
                this.seasfreq_[i2] = iseas * (i2 + 1);
            }
            this.freqs_ = new double[this.npoints_ + 1];
            this.svals_ = new double[this.npoints_ + 1];
            double fstep = Math.PI / (double)this.npoints_;
            for (i = 0; i <= this.npoints_; ++i) {
                this.freqs_[i] = fstep * (double)i;
            }
            if (tdfreq != null) {
                this.tdfreq_ = new int[tdfreq.length];
                block4: for (i = 0; i < tdfreq.length; ++i) {
                    for (int j = 0; j < this.npoints_; ++j) {
                        if (!(tdfreq[i] > this.freqs_[j]) || !(tdfreq[i] <= this.freqs_[j + 1])) continue;
                        double d0 = tdfreq[i] - this.freqs_[j];
                        double d1 = this.freqs_[j + 1] - tdfreq[i];
                        if (d0 < d1) {
                            this.freqs_[j] = tdfreq[i];
                            this.tdfreq_[i] = j;
                            continue block4;
                        }
                        this.freqs_[j + 1] = tdfreq[i];
                        this.tdfreq_[i] = j + 1;
                        continue block4;
                    }
                }
            }
            if (ars.process(ts, this.nar_)) {
                for (i = 0; i < this.freqs_.length; ++i) {
                    this.svals_[i] = ars.value(this.freqs_[i]);
                }
                DescriptiveStatistics stats = new DescriptiveStatistics(new DataBlock(this.svals_).drop(1, 1));
                this.median_ = stats.getMedian();
                this.srange_ = stats.getMax() - stats.getMin();
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public int getARLength() {
        return this.nar_;
    }

    public void setARLength(int value) {
        this.nar_ = value;
    }

    public double getSensitivity() {
        return this.sensibility_;
    }

    public void setSensitivity(double value) {
        this.sensibility_ = value;
    }

    public int getNPoints() {
        return this.npoints_;
    }

    public void setNPoints(int value) {
        this.npoints_ = value;
    }

    public double getFrequency(int i) {
        return this.freqs_[i];
    }

    public double getSpectrumValue(int i) {
        return this.svals_[i];
    }

    public int[] getSeasonalFrequencies() {
        return this.seasfreq_;
    }

    public int[] getTradingDaysFrequencies() {
        return this.tdfreq_;
    }

    public boolean hasTradingDayPeaks() {
        if (this.tdfreq_ == null) {
            return false;
        }
        for (int i = 0; i < this.tdfreq_.length; ++i) {
            if (!this.isSignificant(this.tdfreq_[i])) continue;
            return true;
        }
        return false;
    }

    public boolean hasSeasonalPeaks() {
        if (this.seasfreq_ == null) {
            return false;
        }
        for (int i = 0; i < this.seasfreq_.length; ++i) {
            if (!this.isSignificant(this.seasfreq_[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isSignificant(int idx) {
        if (this.svals_[idx] < this.median_) {
            return false;
        }
        if (idx == 0) {
            return this.svals_[idx] - this.svals_[idx + 1] > this.sensibility_ * this.srange_;
        }
        if (idx == this.svals_.length - 1) {
            return this.svals_[idx] - this.svals_[idx - 1] > this.sensibility_ * this.srange_;
        }
        return this.svals_[idx] - this.svals_[idx - 1] > this.sensibility_ * this.srange_ && this.svals_[idx] - this.svals_[idx + 1] > this.sensibility_ * this.srange_;
    }
}

