/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.TsException;
import ec.tstoolkit.timeseries.regression.AbstractSingleTsVariable;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;

public class DiffConstant
extends AbstractSingleTsVariable {
    private Day m_start;
    private BackFilter m_ur;

    public static double[] generateMeanEffect(BackFilter ur, int n) {
        Polynomial p = ur.getPolynomial();
        double[] m = new double[n];
        for (int i = ur.getDegree(); i < n; ++i) {
            double c = 1.0;
            for (int j = 1; j <= p.getDegree(); ++j) {
                if (p.get(j) == 0.0) continue;
                c -= p.get(j) * m[i - j];
            }
            m[i] = c;
        }
        return m;
    }

    public DiffConstant(BackFilter ur, Day start) {
        this.m_start = start;
        this.m_ur = ur;
    }

    @Override
    public void data(TsPeriod start, DataBlock data) {
        TsPeriod s = new TsPeriod(start.getFrequency(), this.m_start);
        int del = start.minus(s);
        if (del < 0) {
            throw new TsException("Unexpected DConstant");
        }
        double[] g = DiffConstant.generateMeanEffect(this.m_ur, del + data.getLength());
        data.copyFrom(g, del);
    }

    @Override
    public String getDescription(TsFrequency context) {
        StringBuilder builder = new StringBuilder();
        builder.append("Polynomial trend (").append(this.m_ur.getDegree()).append(')');
        return builder.toString();
    }

    @Override
    public boolean isSignificant(TsDomain domain) {
        return domain.getLength() > this.m_ur.getDegree();
    }

    @Override
    public String getName() {
        return "trend";
    }
}

