/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.InformationSetSerializable;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.maths.polynomials.RationalFunction;
import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.regression.AbstractSingleTsVariable;
import ec.tstoolkit.timeseries.regression.IUserTsVariable;
import ec.tstoolkit.timeseries.regression.Sequence;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import ec.tstoolkit.utilities.Comparator;
import ec.tstoolkit.utilities.Jdk6;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;

public class InterventionVariable
extends AbstractSingleTsVariable
implements IUserTsVariable,
Cloneable,
InformationSetSerializable {
    public static final String NAME = "name";
    public static final String DELTA = "delta";
    public static final String DELTAS = "deltas";
    public static final String SEQS = "sequences";
    private static final String DESC = "Intervention variable";
    private String desc_ = null;
    private double delta_;
    private double deltas_;
    private ArrayList<Sequence> seqs_ = new ArrayList();

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(InformationSet.item(prefix, SEQS), String[].class);
        dic.put(InformationSet.item(prefix, NAME), String.class);
        dic.put(InformationSet.item(prefix, DELTA), Double.class);
        dic.put(InformationSet.item(prefix, DELTAS), Double.class);
    }

    public InterventionVariable clone() {
        try {
            InterventionVariable spec = (InterventionVariable)super.clone();
            spec.seqs_ = new ArrayList();
            for (Sequence seq : this.seqs_) {
                spec.seqs_.add(seq.clone());
            }
            return spec;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    @Override
    public void data(TsPeriod start, DataBlock data) {
        int di;
        int dcount = data.getLength();
        data.set(0.0);
        if (this.seqs_.isEmpty()) {
            return;
        }
        TsPeriod pstart = new TsPeriod(start.getFrequency());
        TsPeriod pend = new TsPeriod(start.getFrequency());
        pstart.set(this.seqs_.get((int)0).start);
        pend.set(this.seqs_.get((int)0).end);
        for (int i = 1; i < this.seqs_.size(); ++i) {
            if (pstart.isAfter(this.seqs_.get((int)i).start)) {
                pstart.set(this.seqs_.get((int)i).start);
            }
            if (!pend.isBefore(this.seqs_.get((int)i).end)) continue;
            pend.set(this.seqs_.get((int)i).end);
        }
        int n = dcount + start.minus(pstart);
        if (n < 0) {
            return;
        }
        double[] tmp = new double[n];
        TsPeriod curstart = new TsPeriod(start.getFrequency());
        TsPeriod curend = new TsPeriod(start.getFrequency());
        for (int i = 0; i < this.seqs_.size(); ++i) {
            curstart.set(this.seqs_.get((int)i).start);
            curend.set(this.seqs_.get((int)i).end);
            int istart = curstart.minus(pstart);
            int iend = 1 + curend.minus(pstart);
            if (iend > n) {
                iend = n;
            }
            int j = istart;
            while (j < iend) {
                int n2 = j++;
                tmp[n2] = tmp[n2] + 1.0;
            }
        }
        if (this.delta_ != 0.0 || this.deltas_ != 0.0) {
            Polynomial num = Polynomial.ONE;
            Polynomial d = Polynomial.valueOf(1.0, -this.delta_);
            if (start.getFrequency() != TsFrequency.Yearly) {
                double[] ds = Polynomial.Doubles.fromDegree(start.getFrequency().intValue());
                ds[0] = 1.0;
                ds[start.getFrequency().intValue()] = -this.deltas_;
                d = d.times(Polynomial.of(ds));
            }
            RationalFunction rf = new RationalFunction(num, d);
            double[] w = rf.coefficients(n);
            double[] ftmp = new double[n];
            for (int i = 0; i < ftmp.length; ++i) {
                if (tmp[i] == 0.0) continue;
                for (int j = 0; j < ftmp.length - i; ++j) {
                    int n3 = i + j;
                    ftmp[n3] = ftmp[n3] + tmp[i] * w[j];
                }
            }
            tmp = ftmp;
        }
        if ((di = pstart.minus(start)) > 0) {
            data.drop(di, 0).copyFrom(tmp, 0);
        } else {
            data.copyFrom(tmp, -di);
        }
    }

    @Override
    public String getDescription(TsFrequency context) {
        return this.desc_ == null ? this.toString() : this.desc_;
    }

    @Override
    public boolean isSignificant(TsDomain domain) {
        DataBlock s = new DataBlock(domain.getLength());
        this.data(domain.getStart(), s);
        return !s.isConstant();
    }

    public void add(Day start, Day end) {
        this.seqs_.add(new Sequence(start, end));
    }

    public void clear() {
        this.seqs_.clear();
    }

    public int getCount() {
        return this.seqs_.size();
    }

    public Sequence getSequence(int idx) {
        return this.seqs_.get(idx);
    }

    public double getDelta() {
        return this.delta_;
    }

    public void setDelta(double value) {
        this.delta_ = value;
    }

    public double getDeltaS() {
        return this.deltas_;
    }

    public void setDeltaS(double value) {
        this.deltas_ = value;
    }

    public boolean getD1DS() {
        return this.delta_ == 1.0 && this.deltas_ == 1.0;
    }

    public void setD1DS(boolean value) {
        if (value) {
            this.delta_ = 1.0;
            this.deltas_ = 1.0;
        } else {
            this.delta_ = 0.0;
            this.deltas_ = 0.0;
        }
    }

    public Sequence[] getSequences() {
        return Jdk6.Collections.toArray(this.seqs_, Sequence.class);
    }

    public void setSequences(Sequence[] seqs) {
        this.seqs_.clear();
        if (seqs != null) {
            Collections.addAll(this.seqs_, seqs);
        }
    }

    public void setDescription(String desc) {
        this.desc_ = desc;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof InterventionVariable && this.equals((InterventionVariable)obj);
    }

    private boolean equals(InterventionVariable other) {
        return other.delta_ == this.delta_ && other.deltas_ == this.deltas_ && Comparator.equals(other.seqs_, this.seqs_);
    }

    public int hashCode() {
        int hash = 3;
        hash = 71 * hash + Jdk6.Double.hashCode(this.delta_);
        hash = 71 * hash + Jdk6.Double.hashCode(this.deltas_);
        hash = 71 * hash + Arrays.hashCode(this.seqs_.toArray());
        return hash;
    }

    @Override
    public InformationSet write(boolean verbose) {
        InformationSet info = new InformationSet();
        if (verbose || this.delta_ != 0.0) {
            info.add(DELTA, Double.valueOf(this.delta_));
        }
        if (verbose || this.deltas_ != 0.0) {
            info.add(DELTAS, Double.valueOf(this.deltas_));
        }
        if (this.desc_ != null) {
            info.add(NAME, this.desc_);
        }
        String[] seqs = new String[this.seqs_.size()];
        for (int i = 0; i < seqs.length; ++i) {
            seqs[i] = this.seqs_.get(i).toString();
        }
        info.add(SEQS, seqs);
        return info;
    }

    @Override
    public boolean read(InformationSet info) {
        try {
            String[] seqs;
            String desc;
            Double deltas;
            Double delta = info.get(DELTA, Double.class);
            if (delta != null) {
                this.delta_ = delta;
            }
            if ((deltas = info.get(DELTAS, Double.class)) != null) {
                this.deltas_ = deltas;
            }
            if ((desc = info.get(NAME, String.class)) != null) {
                this.desc_ = desc;
            }
            if ((seqs = info.get(SEQS, String[].class)) != null) {
                for (int i = 0; i < seqs.length; ++i) {
                    Sequence cur = Sequence.fromString(seqs[i]);
                    if (cur == null) {
                        return false;
                    }
                    this.seqs_.add(cur);
                }
            }
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }

    public String toString() {
        if (this.seqs_.isEmpty()) {
            return "I:{}";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("I:");
        builder.append('{');
        builder.append(this.seqs_.get(0));
        for (int i = 1; i < this.seqs_.size(); ++i) {
            builder.append(';').append(this.seqs_.get(i));
        }
        builder.append('}');
        this.appendDetails(builder);
        return builder.toString();
    }

    private void appendDetails(StringBuilder builder) {
        int nd = (this.delta_ == 0.0 ? 0 : 1) + (this.deltas_ == 0.0 ? 0 : 1);
        if (nd > 0) {
            DecimalFormat fmt = new DecimalFormat();
            fmt.setMaximumFractionDigits(2);
            builder.append('(');
            if (this.delta_ != 0.0) {
                builder.append("delta=").append(fmt.format(this.delta_));
                if (nd == 2) {
                    builder.append(", ");
                }
            }
            if (this.deltas_ != 0.0) {
                builder.append("deltas=").append(fmt.format(this.deltas_));
            }
            builder.append(')');
        }
    }

    public String toString(TsFrequency freq) {
        if (this.seqs_.isEmpty()) {
            return "I:{}";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("I:");
        builder.append('{');
        builder.append(this.seqs_.get(0).toString(freq));
        for (int i = 1; i < this.seqs_.size(); ++i) {
            builder.append(';').append(this.seqs_.get(i).toString(freq));
        }
        builder.append('}');
        this.appendDetails(builder);
        return builder.toString();
    }

    @Override
    public String getName() {
        return this.desc_ == null ? this.toString().replace('.', '$') : this.desc_;
    }
}

