/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.information.Information;
import ec.tstoolkit.information.InformationLinker;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.utilities.DefaultNameValidator;
import ec.tstoolkit.utilities.INameValidator;
import ec.tstoolkit.utilities.NameManager;
import java.util.Arrays;
import java.util.List;

public class TsVariables
extends NameManager<ITsVariable> {
    public static final InformationLinker<ITsVariable> LINKER = new InformationLinker();
    public static final String X = "x_";

    public TsVariables() {
        super(ITsVariable.class, X, new DefaultNameValidator(".+-*/"));
    }

    public TsVariables(String prefix, INameValidator validator) {
        super(ITsVariable.class, prefix, validator);
    }

    public boolean isEmpty() {
        return this.getCount() < 1;
    }

    public TsDomain common(TsFrequency freq) {
        TsDomain all = null;
        for (ITsVariable var : this.variables()) {
            TsFrequency fcur = var.getDefinitionFrequency();
            if (fcur != TsFrequency.Undefined && fcur != freq) continue;
            TsDomain cur = var.getDefinitionDomain();
            all = TsDomain.and(all, cur);
        }
        return all;
    }

    public TsFrequency[] frequencies() {
        TsFrequency[] all = new TsFrequency[TsFrequency.values().length];
        int idx = 0;
        for (ITsVariable var : this.variables()) {
            int i;
            TsFrequency fcur = var.getDefinitionFrequency();
            if (fcur == TsFrequency.Undefined) continue;
            for (i = 0; i < idx && all[i] != fcur; ++i) {
            }
            if (i != idx) continue;
            all[idx++] = fcur;
        }
        return Arrays.copyOf(all, idx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InformationSet write(boolean verbose) {
        InformationLinker<ITsVariable> informationLinker = LINKER;
        synchronized (informationLinker) {
            InformationSet info = new InformationSet();
            String[] names = this.getNames();
            for (int i = 0; i < names.length; ++i) {
                ITsVariable var = (ITsVariable)this.get(names[i]);
                InformationSet subset = LINKER.encode(var, verbose);
                if (subset == null) continue;
                info.set(names[i], subset);
            }
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean read(InformationSet info) {
        InformationLinker<ITsVariable> informationLinker = LINKER;
        synchronized (informationLinker) {
            List<Information<InformationSet>> sel = info.select(InformationSet.class);
            for (Information<InformationSet> item : sel) {
                ITsVariable var = LINKER.decode((InformationSet)item.value);
                if (var == null) continue;
                this.set(item.name, var);
            }
            return true;
        }
    }
}

