/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.r_osgi.messages;

import ch.ethz.iks.r_osgi.messages.RemoteOSGiMessage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class RemoteCallResultMessage
extends RemoteOSGiMessage {
    private byte errorFlag;
    private Object result;
    private Throwable exception;

    public RemoteCallResultMessage() {
        super((short)6);
    }

    RemoteCallResultMessage(ObjectInputStream input) throws IOException, ClassNotFoundException {
        super((short)6);
        this.errorFlag = input.readByte();
        if (this.errorFlag == 0) {
            this.result = input.readObject();
            this.exception = null;
        } else {
            this.exception = (Throwable)input.readObject();
            this.result = null;
        }
    }

    @Override
    public void writeBody(ObjectOutputStream out) throws IOException {
        if (this.exception == null) {
            out.writeByte(0);
            out.writeObject(this.result);
        } else {
            out.writeByte(1);
            out.writeObject(this.exception);
        }
    }

    public boolean causedException() {
        return this.errorFlag == 1;
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
        this.errorFlag = 0;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable t) {
        this.exception = t;
        this.errorFlag = 1;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[REMOTE_CALL_RESULT] - XID: ");
        buffer.append(this.xid);
        buffer.append(", errorFlag: ");
        buffer.append(this.errorFlag);
        if (this.causedException()) {
            buffer.append(", exception: ");
            buffer.append(this.exception.getMessage());
        } else {
            buffer.append(", result: ");
            buffer.append(this.result);
        }
        return buffer.toString();
    }
}

