/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.util;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Properties;
import org.eclipse.ecf.core.util.Proxy;

public class JREProxyHelper {
    private static final String SOCKS_PROXY_PORT_SYSTEM_PROPERTY = "socksProxyPort";
    private static final String SOCKS_PROXY_HOST_SYSTEM_PROPERTY = "socksProxyHost";
    private static final String HTTP_PROXY_PORT_SYSTEM_PROPERTY = "http.proxyPort";
    private static final String HTTP_PROXY_HOST_SYSTEM_PROPERTY = "http.proxyHost";
    private String proxyHostProperty;
    private String proxyPortProperty;
    private String oldHost;
    private String oldPort;

    public void setupProxy(Proxy proxy2) {
        Properties systemProperties = System.getProperties();
        this.proxyHostProperty = proxy2.getType().equals(Proxy.Type.HTTP) ? HTTP_PROXY_HOST_SYSTEM_PROPERTY : SOCKS_PROXY_HOST_SYSTEM_PROPERTY;
        this.proxyPortProperty = proxy2.getType().equals(Proxy.Type.HTTP) ? HTTP_PROXY_PORT_SYSTEM_PROPERTY : SOCKS_PROXY_PORT_SYSTEM_PROPERTY;
        this.oldHost = systemProperties.getProperty(this.proxyHostProperty);
        if (this.oldHost != null) {
            this.oldPort = systemProperties.getProperty(this.proxyPortProperty);
        }
        systemProperties.setProperty(this.proxyHostProperty, proxy2.getAddress().getHostName());
        int proxyPort = proxy2.getAddress().getPort();
        if (proxyPort != -1) {
            systemProperties.setProperty(this.proxyPortProperty, String.valueOf(proxyPort));
        }
        final String username = proxy2.getUsername();
        boolean setAuthenticator = false;
        if (username != null && !username.equals("")) {
            String password;
            String string = password = proxy2.getPassword() == null ? "" : proxy2.getPassword();
            if (proxy2.hasCredentials()) {
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(username, password.toCharArray());
                    }
                });
                setAuthenticator = true;
            }
        }
        if (!setAuthenticator) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return null;
                }
            });
        }
    }

    public void dispose() {
        if (this.oldHost != null) {
            System.getProperties().setProperty(this.proxyHostProperty, this.oldHost);
            this.oldHost = null;
            if (this.oldPort != null) {
                System.getProperties().setProperty(this.proxyPortProperty, this.oldPort);
                this.oldPort = null;
            }
        }
    }
}

