/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.dynamic.employee;

import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicHelper;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.jpa.dynamic.JPADynamicHelper;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.testing.tests.jpa.dynamic.DynamicTestHelper;
import org.eclipse.persistence.testing.tests.jpa.dynamic.employee.DynamicEmployeeSystem;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class EmployeeQueriesTestSuite {
    static EntityManagerFactory emf = null;
    static JPADynamicHelper helper = null;
    static Server serverSession = null;
    static DynamicEmployeeSystem deSystem = null;

    @BeforeClass
    public static void setUp() throws Exception {
        emf = DynamicTestHelper.createEMF("dynamic");
        boolean isMySQL = JpaHelper.getServerSession((EntityManagerFactory)emf).getDatasourcePlatform().getClass().getName().contains("MySQLPlatform");
        Assume.assumeTrue((boolean)isMySQL);
        helper = new JPADynamicHelper(emf);
        deSystem = DynamicEmployeeSystem.buildProject((DynamicHelper)helper);
        serverSession = JpaHelper.getServerSession((EntityManagerFactory)emf);
        deSystem.populate(helper, emf.createEntityManager());
    }

    @AfterClass
    public static void tearDown() {
        serverSession.executeNonSelectingSQL("DROP TABLE D_SALARY");
        serverSession.executeNonSelectingSQL("DROP TABLE D_PROJ_EMP");
        serverSession.executeNonSelectingSQL("DROP TABLE D_PROJECT");
        serverSession.executeNonSelectingSQL("DROP TABLE D_PHONE");
        serverSession.executeNonSelectingSQL("DROP TABLE D_EMPLOYEE");
        serverSession.executeNonSelectingSQL("DROP TABLE D_ADDRESS");
        helper = null;
        emf.close();
        emf = null;
    }

    @Test
    public void readAllEmployees_JPQL() {
        EntityManager em = emf.createEntityManager();
        List<DynamicEntity> emps = this.readAllEmployeesUsingJPQL(em);
        deSystem.assertSame(emps);
    }

    @Test
    public void joinFetchJPQL() {
        List<DynamicEntity> emps = this.joinFetchJPQL(emf.createEntityManager());
        Assert.assertNotNull(emps);
    }

    @Test
    public void joinFetchHint() {
        List<DynamicEntity> emps = this.joinFetchHint(emf.createEntityManager());
        Assert.assertNotNull(emps);
    }

    @Test
    public void minEmployeeId() {
        int minId = EmployeeQueriesTestSuite.minimumEmployeeId(emf.createEntityManager());
        Assert.assertTrue((minId > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGenderIn() {
        List<DynamicEntity> emps = this.findEmployeesUsingGenderIn(emf.createEntityManager());
        Assert.assertNotNull(emps);
    }

    @Test
    public void testReadAllExressions() {
        List<DynamicEntity> emps = this.findUsingNativeReadAllQuery(emf.createEntityManager());
        Assert.assertNotNull(emps);
    }

    public List<DynamicEntity> readAllEmployeesUsingJPQL(EntityManager em) {
        return em.createQuery("SELECT e FROM Employee e ORDER BY e.id ASC").getResultList();
    }

    public List<DynamicEntity> joinFetchJPQL(EntityManager em) {
        return em.createQuery("SELECT e FROM Employee e JOIN FETCH e.address ORDER BY e.lastName ASC, e.firstName ASC").getResultList();
    }

    public List<DynamicEntity> joinFetchHint(EntityManager em) {
        Query query = em.createQuery("SELECT e FROM Employee e WHERE e.manager.address.city = 'Ottawa' ORDER BY e.lastName ASC, e.firstName ASC");
        query.setHint("eclipselink.join-fetch", (Object)"e.address");
        query.setHint("eclipselink.join-fetch", (Object)"e.manager");
        query.setHint("eclipselink.join-fetch", (Object)"e.manager.address");
        query.setHint("eclipselink.batch", (Object)"e.manager.phoneNumbers");
        List emps = query.getResultList();
        for (DynamicEntity emp : emps) {
            ((Collection)((DynamicEntity)emp.get("manager")).get("phoneNumbers")).size();
        }
        return emps;
    }

    public static int minimumEmployeeId(EntityManager em) {
        return ((Number)em.createQuery("SELECT MIN(e.id) FROM Employee e").getSingleResult()).intValue();
    }

    public DynamicEntity minimumEmployee(EntityManager em) {
        Query q = em.createQuery("SELECT e FROM Employee e WHERE e.id in (SELECT MIN(ee.id) FROM Employee ee)");
        return (DynamicEntity)q.getSingleResult();
    }

    public List<DynamicEntity> findEmployeesUsingGenderIn(EntityManager em) {
        return em.createQuery("SELECT e FROM Employee e WHERE e.gender IN (:GENDER1, :GENDER2)").setParameter("GENDER1", (Object)"Male").setParameter("GENDER2", (Object)"Female").getResultList();
    }

    public List<DynamicEntity> findUsingNativeReadAllQuery(EntityManager em) {
        ClassDescriptor descriptor = serverSession.getDescriptorForAlias("Employee");
        ReadAllQuery raq = new ReadAllQuery(descriptor.getJavaClass());
        ExpressionBuilder eb = raq.getExpressionBuilder();
        raq.setSelectionCriteria(eb.get("gender").equal((Object)"Male"));
        Query query = JpaHelper.createQuery((DatabaseQuery)raq, (EntityManager)em);
        return query.getResultList();
    }

    public DynamicEntity minEmployeeWithAddressAndPhones(EntityManager em) {
        return (DynamicEntity)em.createQuery("SELECT e FROM Employee e JOIN FETCH e.address WHERE e.id IN (SELECT MIN(p.id) FROM PhoneNumber p)").getSingleResult();
    }
}

