/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.relationships;

import javax.persistence.EntityManager;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.sessions.RepeatableWriteUnitOfWork;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.relationships.IsolatedItem;
import org.eclipse.persistence.testing.models.jpa.relationships.RelationshipsTableManager;

public class IsolatedCacheTestSuite
extends JUnitTestCase {
    public IsolatedCacheTestSuite() {
    }

    public IsolatedCacheTestSuite(String name) {
        super(name);
    }

    public void testSetup() {
        new RelationshipsTableManager().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("IsolatedCacheTestSuite");
        suite.addTest((Test)new IsolatedCacheTestSuite("testSetup"));
        suite.addTest((Test)new IsolatedCacheTestSuite("testCacheIsolationDBQueryHit"));
        return suite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCacheIsolationDBQueryHit() throws Exception {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            IsolatedItem item = new IsolatedItem();
            item.setDescription("A phoney item");
            item.setName("Phoney name");
            em.persist((Object)item);
            this.commitTransaction(em);
            this.beginTransaction(em);
            em.clear();
            RepeatableWriteUnitOfWork uow = (RepeatableWriteUnitOfWork)((EntityManagerImpl)em.getDelegate()).getUnitOfWork();
            IsolatedCacheTestSuite.assertFalse((String)"The isolated item was not cleared from the shared cache", (boolean)uow.getIdentityMapAccessor().containsObjectInIdentityMap((Object)item));
            IsolatedCacheTestSuite.assertFalse((String)"The isolated item was not cleared from the uow cache", (boolean)uow.getParent().getIdentityMapAccessor().containsObjectInIdentityMap((Object)item));
            this.commitTransaction(em);
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }
}

