/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.dynamic.simple.mappings;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicHelper;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.dynamic.DynamicTypeBuilder;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.dynamic.DynamicEntityImpl;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.tests.dynamic.DynamicTestingHelper;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SimpleTypes_MultiTable {
    static DatabaseSession session = null;
    static DynamicHelper dynamicHelper = null;

    @BeforeClass
    public static void setUp() {
        session = DynamicTestingHelper.createSession();
        dynamicHelper = new DynamicHelper(session);
        DynamicClassLoader dcl = dynamicHelper.getDynamicClassLoader();
        Class simpleTypeA = dcl.createDynamicClass("simple.mappings.SimpleA");
        DynamicTypeBuilder typeBuilder = new DynamicTypeBuilder(simpleTypeA, null, new String[]{"SIMPLE_TYPE_A", "SIMPLE_TYPE_B", "SIMPLE_TYPE_C"});
        typeBuilder.setPrimaryKeyFields(new String[]{"SIMPLE_TYPE_A.SID"});
        typeBuilder.addDirectMapping("id", Integer.TYPE, "SIMPLE_TYPE_A.SID");
        typeBuilder.addDirectMapping("value1", String.class, "SIMPLE_TYPE_A.VAL_1");
        typeBuilder.addDirectMapping("value2", Boolean.TYPE, "SIMPLE_TYPE_B.VAL_2");
        typeBuilder.addDirectMapping("value3", String.class, "SIMPLE_TYPE_B.VAL_3");
        typeBuilder.addDirectMapping("value4", Double.TYPE, "SIMPLE_TYPE_C.VAL_4");
        typeBuilder.addDirectMapping("value5", String.class, "SIMPLE_TYPE_C.VAL_5");
        dynamicHelper.addTypes(true, true, new DynamicType[]{typeBuilder.getType()});
    }

    @AfterClass
    public static void tearDown() {
        session.executeNonSelectingSQL("DROP TABLE SIMPLE_TYPE_C");
        session.executeNonSelectingSQL("DROP TABLE SIMPLE_TYPE_B");
        session.executeNonSelectingSQL("DROP TABLE SIMPLE_TYPE_A");
        session.logout();
        session = null;
        dynamicHelper = null;
    }

    @After
    public void clearDynamicTables() {
        session.executeNonSelectingSQL("DELETE FROM SIMPLE_TYPE_C");
        session.executeNonSelectingSQL("DELETE FROM SIMPLE_TYPE_B");
        session.executeNonSelectingSQL("DELETE FROM SIMPLE_TYPE_A");
    }

    @Test
    public void verifyConfig() throws Exception {
        ClassDescriptor descriptorA = dynamicHelper.getSession().getClassDescriptorForAlias("SimpleA");
        Assert.assertNotNull((String)"No descriptor found for alias='SimpleA'", (Object)descriptorA);
        DynamicType simpleTypeA = dynamicHelper.getType("SimpleA");
        Assert.assertNotNull((String)"'SimpleA' EntityType not found", (Object)simpleTypeA);
        Assert.assertEquals((Object)descriptorA, (Object)simpleTypeA.getDescriptor());
        Assert.assertTrue((boolean)descriptorA.hasMultipleTables());
        Assert.assertEquals((long)3L, (long)descriptorA.getTables().size());
        DirectToFieldMapping a_id = (DirectToFieldMapping)descriptorA.getMappingForAttributeName("id");
        Assert.assertEquals(Integer.TYPE, (Object)a_id.getAttributeClassification());
        DirectToFieldMapping a_value1 = (DirectToFieldMapping)descriptorA.getMappingForAttributeName("value1");
        Assert.assertEquals(String.class, (Object)a_value1.getAttributeClassification());
        DirectToFieldMapping a_value2 = (DirectToFieldMapping)descriptorA.getMappingForAttributeName("value2");
        Assert.assertEquals(Boolean.TYPE, (Object)a_value2.getAttributeClassification());
        DirectToFieldMapping a_value3 = (DirectToFieldMapping)descriptorA.getMappingForAttributeName("value3");
        Assert.assertEquals(String.class, (Object)a_value3.getAttributeClassification());
        DirectToFieldMapping a_value4 = (DirectToFieldMapping)descriptorA.getMappingForAttributeName("value4");
        Assert.assertEquals(Double.TYPE, (Object)a_value4.getAttributeClassification());
        DirectToFieldMapping a_value5 = (DirectToFieldMapping)descriptorA.getMappingForAttributeName("value5");
        Assert.assertEquals(String.class, (Object)a_value5.getAttributeClassification());
    }

    @Test
    public void verifyProperties() {
        DynamicType simpleTypeA = dynamicHelper.getType("SimpleA");
        Assert.assertNotNull((Object)simpleTypeA);
        Assert.assertEquals((long)6L, (long)simpleTypeA.getNumberOfProperties());
        Assert.assertTrue((boolean)simpleTypeA.getPropertiesNames().contains("id"));
        Assert.assertEquals(Integer.TYPE, (Object)simpleTypeA.getPropertyType("id"));
        Assert.assertTrue((String)"value1", (boolean)simpleTypeA.getPropertiesNames().contains("value1"));
        Assert.assertEquals(String.class, (Object)simpleTypeA.getPropertyType("value1"));
        Assert.assertTrue((String)"value2", (boolean)simpleTypeA.getPropertiesNames().contains("value2"));
        Assert.assertEquals(Boolean.TYPE, (Object)simpleTypeA.getPropertyType("value2"));
        Assert.assertTrue((String)"value3", (boolean)simpleTypeA.getPropertiesNames().contains("value3"));
        Assert.assertEquals(String.class, (Object)simpleTypeA.getPropertyType("value3"));
        Assert.assertTrue((String)"value4", (boolean)simpleTypeA.getPropertiesNames().contains("value4"));
        Assert.assertEquals(Double.TYPE, (Object)simpleTypeA.getPropertyType("value4"));
        Assert.assertTrue((String)"value5", (boolean)simpleTypeA.getPropertiesNames().contains("value5"));
        Assert.assertEquals(String.class, (Object)simpleTypeA.getPropertyType("value5"));
    }

    @Test
    public void createSimpleA() {
        DynamicType simpleTypeA = dynamicHelper.getType("SimpleA");
        Assert.assertNotNull((Object)simpleTypeA);
        DynamicEntity a = simpleTypeA.newDynamicEntity();
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)a.get("id"), (Object)0);
        Assert.assertFalse((boolean)a.isSet("value1"));
        Assert.assertEquals((Object)a.get("value2"), (Object)false);
        Assert.assertFalse((boolean)a.isSet("value3"));
        Assert.assertEquals((Object)a.get("value4"), (Object)0.0);
        Assert.assertFalse((boolean)a.isSet("value5"));
    }

    @Test
    public void persistSimpleA() {
        DynamicType simpleTypeA = dynamicHelper.getType("SimpleA");
        Assert.assertNotNull((Object)simpleTypeA);
        DynamicEntity simpleInstance = simpleTypeA.newDynamicEntity();
        simpleInstance.set("id", (Object)1);
        simpleInstance.set("value1", (Object)"A1");
        UnitOfWork uow = session.acquireUnitOfWork();
        uow.registerNewObject((Object)simpleInstance);
        uow.commit();
        ReportQuery countQuery = dynamicHelper.newReportQuery("SimpleA", new ExpressionBuilder());
        countQuery.addCount();
        countQuery.setShouldReturnSingleValue(true);
        int simpleCount = ((Number)session.executeQuery((DatabaseQuery)countQuery)).intValue();
        Assert.assertEquals((long)1L, (long)simpleCount);
        session.release();
    }

    @Test
    public void verifyChangeTracking() {
        this.persistSimpleA();
        DynamicType simpleTypeA = dynamicHelper.getType("SimpleA");
        Assert.assertNotNull((Object)simpleTypeA);
        UnitOfWork uow = session.acquireUnitOfWork();
        ReadObjectQuery findQuery = dynamicHelper.newReadObjectQuery("SimpleA");
        findQuery.setSelectionCriteria(findQuery.getExpressionBuilder().get("id").equal(1));
        DynamicEntityImpl a = (DynamicEntityImpl)uow.executeQuery((DatabaseQuery)findQuery);
        Assert.assertNotNull((Object)a);
        Assert.assertNotNull((Object)a._persistence_getPropertyChangeListener());
        uow.release();
        session.release();
    }
}

