/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.events;

import java.util.Vector;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.events.Address;
import org.eclipse.persistence.testing.models.events.Customer;
import org.eclipse.persistence.testing.tests.events.EventHookTestCase;

public class ObjectChangeSetUpdateAttributeTest
extends EventHookTestCase {
    public Customer customer;
    public ObjectChangeSet customerChangeSet;

    @Override
    public void setup() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.beginTransaction();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.customer = Customer.example1();
        uow.registerObject((Object)this.customer);
        uow.commit();
        Address.preUpdateCount = 0;
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Customer cloneCustomer = (Customer)uow.readObject((Object)this.customer);
        cloneCustomer.postWrite = true;
        cloneCustomer.preUpdate = true;
        cloneCustomer.address.address = "No Place Special";
        uow.commit();
        this.customerChangeSet = (ObjectChangeSet)uow.getUnitOfWorkChangeSet().getObjectChangeSetForClone((Object)cloneCustomer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verify() {
        Customer originalCustomer = (Customer)this.getSession().readObject((Object)this.customer);
        try {
            if (originalCustomer.name.equals("PreWrite")) {
                throw new TestErrorException("Failed to update attribute in direct to field");
            }
            if (!originalCustomer.associations.contains("PreUpdate")) {
                throw new TestErrorException("PreUpdateEvent failed to fire");
            }
            if (Address.preUpdateCount != 1) {
                throw new TestErrorException("PreUpdateEvent fired too many times");
            }
            if (!originalCustomer.associations.contains("PostWrite")) {
                throw new TestErrorException("Failed to update attribute in direct collection with addition");
            }
            if (originalCustomer.associations.contains("Mickey Mouse Club")) {
                throw new TestErrorException("Failed to update attribute in direct collection with removal");
            }
            if (((Vector)originalCustomer.orders.getValue()).size() != 3) {
                throw new TestErrorException("Failed to update attribute in collection");
            }
            if (this.customerChangeSet.getChanges().size() <= 2) {
                throw new TestErrorException("Failed to update the changeSet");
            }
            if (!originalCustomer.creditCard.number.equals("0")) {
                throw new TestErrorException("Failed to update the aggregate attribute");
            }
            if (this.customerChangeSet.getChangesForAttributeNamed("creditCard") == null) {
                throw new TestErrorException("Failed to update the changeset with aggregate attribute");
            }
        }
        finally {
            Address.preUpdateCount = 0;
        }
    }
}

