/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.persistence.internal.identitymaps.CacheIdentityMap;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.internal.identitymaps.NoIdentityMap;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class MultipleRegisterTest
extends TestCase {
    IdentityMap map;
    Vector primaryKeys;
    Vector originalObjects;
    Vector retrievedObjects;

    public MultipleRegisterTest(IdentityMap map, Vector keys, Vector testObjects) {
        this.map = map;
        this.primaryKeys = keys;
        this.originalObjects = testObjects;
    }

    public void test() {
        Object value;
        Vector key;
        int index;
        for (index = 0; index < this.primaryKeys.size(); ++index) {
            key = (Vector)this.primaryKeys.elementAt(index);
            value = this.originalObjects.elementAt(index);
            this.map.put((Object)key, value, null, 0L);
        }
        this.retrievedObjects = new Vector();
        for (index = 0; index < this.primaryKeys.size(); ++index) {
            key = (Vector)this.primaryKeys.elementAt(index);
            value = this.map.get((Object)key);
            this.retrievedObjects.addElement(value);
        }
    }

    public void verify() {
        if (this.map instanceof NoIdentityMap) {
            this.verify((NoIdentityMap)this.map);
        } else if (this.map instanceof CacheIdentityMap) {
            this.verifyFixedSize();
        } else {
            if (this.originalObjects.size() != this.retrievedObjects.size()) {
                throw new TestErrorException(this.originalObjects.size() + " objects were registered " + "in the identity map but only " + this.retrievedObjects.size() + " were retrieved.");
            }
            Hashtable mismatches = this.verifyObjectIdentity();
            if (mismatches.size() != 0) {
                throw new TestErrorException(mismatches.size() + " mismatches occurred while" + " retrieving objects from a full identity map. The mismatches are " + mismatches + ".");
            }
        }
    }

    public void verify(NoIdentityMap map) {
        if (map.getSize() != 0) {
            throw new TestErrorException("Objects were registered in a NoIdentityMap but there are " + map.getSize() + " objects in the map.");
        }
        Enumeration values = this.retrievedObjects.elements();
        while (values.hasMoreElements()) {
            if (values.nextElement() == null) continue;
            throw new TestErrorException("A non-null value was retrieved from a no identity map.");
        }
    }

    public void verifyFixedSize() {
        if (this.map.getSize() > this.map.getMaxSize()) {
            throw new TestErrorException("Fixed size identity map " + this.map + " contains " + this.map.getSize() + " objects. " + "The specified maximum size for this map is " + this.map.getMaxSize() + ".");
        }
        Hashtable mismatches = this.verifyObjectIdentity();
        int expectedMismatches = this.originalObjects.size() - this.map.getMaxSize();
        if (mismatches.size() != expectedMismatches) {
            throw new TestErrorException(mismatches.size() + "mismatches occurred while" + "retrieving objects from the identity map. " + expectedMismatches + "were expected. The mismatches were " + mismatches + ".");
        }
    }

    public Hashtable verifyObjectIdentity() {
        Hashtable mismatches = new Hashtable();
        for (int index = 0; index < this.originalObjects.size(); ++index) {
            Object retrieved;
            Object original = this.originalObjects.elementAt(index);
            if (original == (retrieved = this.retrievedObjects.elementAt(index))) continue;
            mismatches.put(original, retrieved);
        }
        return mismatches;
    }
}

