/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.inheritance;

import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestException;
import org.eclipse.persistence.testing.models.inheritance.JavaProgrammer;

public class SecondaryTableUpdateTest
extends TestCase {
    public JavaProgrammer J;

    public SecondaryTableUpdateTest() {
        this.setDescription("Checks if an update occurs when attributes from a non-primary table are modified");
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.getAbstractSession().beginTransaction();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.J = (JavaProgrammer)uow.readObject(JavaProgrammer.class);
        this.J.setNumberOfSupportQuestions(this.J.getNumberOfSupportQuestions() + 1);
        uow.commit();
    }

    public void verify() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        ExpressionBuilder eb = new ExpressionBuilder();
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        JavaProgrammer JP = (JavaProgrammer)uow.readObject(JavaProgrammer.class, eb.get("id").equal(this.J.id));
        if (JP.id != this.J.id) {
            throw new TestException("Update Failed");
        }
    }
}

