/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.orderedlist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.annotations.OrderCorrectionType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.AttributeChangeTrackingPolicy;
import org.eclipse.persistence.descriptors.changetracking.ObjectChangePolicy;
import org.eclipse.persistence.descriptors.changetracking.ObjectChangeTrackingPolicy;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.queries.OrderedListContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.ReportQueryResult;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.models.orderedlist.Child;
import org.eclipse.persistence.testing.models.orderedlist.Employee;
import org.eclipse.persistence.testing.models.orderedlist.EmployeeSystem;
import org.eclipse.persistence.testing.models.orderedlist.LargeProject;
import org.eclipse.persistence.testing.models.orderedlist.NullsLastOrderedListContainerPolicy;
import org.eclipse.persistence.testing.models.orderedlist.PhoneNumber;
import org.eclipse.persistence.testing.models.orderedlist.Project;
import org.eclipse.persistence.testing.models.orderedlist.SmallProject;

public class OrderListTestModel
extends TestModel {
    static boolean shouldRunWithoutListOrderField = false;
    boolean isTopLevel;
    boolean useListOrderField;
    boolean isPrivatelyOwned;
    boolean useIndirection;
    boolean useSecondaryTable;
    boolean useVarcharOrder;
    EmployeeSystem.ChangeTracking changeTracking;
    OrderCorrectionType orderCorrectionType;
    boolean shouldOverrideContainerPolicy;
    EmployeeSystem.JoinFetchOrBatchRead joinFetchOrBatchRead;
    Map<Class, ObjectChangeTrackingPolicy> originalChangeTrackingPolicies;
    static final String front = "front";
    static final String middle = "middle";
    static final String end = "end";

    public static TestSuite suite() {
        return new OrderListTestModel();
    }

    public OrderListTestModel() {
        this.setDescription("This model tests ordered list.");
        this.isTopLevel = true;
    }

    void addTestModel(DatabasePlatform platform) {
        if (this.shouldAddModel(platform)) {
            this.addTest((Test)new OrderListTestModel(this.useListOrderField, this.useIndirection, this.isPrivatelyOwned, this.useSecondaryTable, this.useVarcharOrder, this.changeTracking, this.orderCorrectionType, this.shouldOverrideContainerPolicy, this.joinFetchOrBatchRead));
        }
    }

    void addModels() {
        int k;
        int i;
        org.eclipse.persistence.platform.database.DatabasePlatform platform = this.getSession().getPlatform();
        this.changeTracking = EmployeeSystem.ChangeTracking.ATTRIBUTE;
        this.orderCorrectionType = OrderCorrectionType.READ_WRITE;
        this.joinFetchOrBatchRead = EmployeeSystem.JoinFetchOrBatchRead.NONE;
        this.useVarcharOrder = false;
        this.useSecondaryTable = false;
        this.isPrivatelyOwned = false;
        this.useIndirection = true;
        this.useListOrderField = true;
        this.shouldOverrideContainerPolicy = false;
        this.useVarcharOrder = true;
        this.addTestModel((DatabasePlatform)platform);
        this.useVarcharOrder = false;
        this.useSecondaryTable = true;
        this.addTestModel((DatabasePlatform)platform);
        this.useSecondaryTable = false;
        this.useIndirection = false;
        this.changeTracking = EmployeeSystem.ChangeTracking.DEFERRED;
        this.addTestModel((DatabasePlatform)platform);
        this.changeTracking = EmployeeSystem.ChangeTracking.ATTRIBUTE;
        this.useIndirection = true;
        this.shouldOverrideContainerPolicy = true;
        this.addTestModel((DatabasePlatform)platform);
        this.shouldOverrideContainerPolicy = false;
        for (i = 0; i < EmployeeSystem.ChangeTracking.values().length; ++i) {
            this.changeTracking = EmployeeSystem.ChangeTracking.values()[i];
            this.addTestModel((DatabasePlatform)platform);
        }
        this.isPrivatelyOwned = true;
        for (i = 0; i < EmployeeSystem.ChangeTracking.values().length; ++i) {
            this.changeTracking = EmployeeSystem.ChangeTracking.values()[i];
            this.addTestModel((DatabasePlatform)platform);
        }
        this.changeTracking = EmployeeSystem.ChangeTracking.ATTRIBUTE;
        this.isPrivatelyOwned = false;
        for (int j = 0; j < OrderCorrectionType.values().length; ++j) {
            this.orderCorrectionType = OrderCorrectionType.values()[j];
            this.addTestModel((DatabasePlatform)platform);
        }
        this.orderCorrectionType = OrderCorrectionType.READ_WRITE;
        for (k = 0; k < EmployeeSystem.JoinFetchOrBatchRead.values().length; ++k) {
            this.joinFetchOrBatchRead = EmployeeSystem.JoinFetchOrBatchRead.values()[k];
            this.addTestModel((DatabasePlatform)platform);
        }
        this.joinFetchOrBatchRead = EmployeeSystem.JoinFetchOrBatchRead.NONE;
        this.useSecondaryTable = true;
        for (k = 0; k < EmployeeSystem.JoinFetchOrBatchRead.values().length; ++k) {
            this.joinFetchOrBatchRead = EmployeeSystem.JoinFetchOrBatchRead.values()[k];
            this.addTestModel((DatabasePlatform)platform);
        }
        this.joinFetchOrBatchRead = EmployeeSystem.JoinFetchOrBatchRead.NONE;
        this.useSecondaryTable = false;
    }

    boolean shouldAddModel(DatabasePlatform platform) {
        if (!this.useListOrderField) {
            if (!shouldRunWithoutListOrderField) {
                return false;
            }
            if (this.orderCorrectionType != OrderCorrectionType.READ) {
                return false;
            }
            if (this.useVarcharOrder) {
                return false;
            }
        }
        if (this.useSecondaryTable && this.joinFetchOrBatchRead == EmployeeSystem.JoinFetchOrBatchRead.OUTER_JOIN && (platform.isH2() || platform.isHSQL() || platform.isTimesTen())) {
            return false;
        }
        return !this.useVarcharOrder || platform.supportsAutoConversionToNumericForArithmeticOperations();
    }

    public OrderListTestModel(boolean useListOrderField, boolean useIndirection, boolean isPrivatelyOwned, boolean useSecondaryTable, boolean useVarcharOrder, EmployeeSystem.ChangeTracking changeTracking, OrderCorrectionType orderCorrectionType, boolean shouldOverrideContainerPolicy, EmployeeSystem.JoinFetchOrBatchRead joinFetchOrBatchRead) {
        this.useListOrderField = useListOrderField;
        this.useIndirection = useIndirection;
        this.isPrivatelyOwned = isPrivatelyOwned;
        this.useSecondaryTable = useSecondaryTable;
        this.useVarcharOrder = useVarcharOrder;
        this.changeTracking = changeTracking;
        this.orderCorrectionType = orderCorrectionType;
        this.shouldOverrideContainerPolicy = shouldOverrideContainerPolicy;
        this.joinFetchOrBatchRead = joinFetchOrBatchRead;
        this.setDescription("This model tests ordered list");
        this.setName("");
        this.addToName(useListOrderField ? "" : "NO_ORDER_LIST");
        this.addToName(useIndirection ? "" : "NO_INDIRECTION");
        this.addToName(isPrivatelyOwned ? "PRIVATE" : "");
        this.addToName(useSecondaryTable ? "SECONDARY_TABLE" : "");
        this.addToName(useVarcharOrder ? "VARCHAR_ORDER" : "");
        this.addToName(changeTracking.toString());
        this.addToName(orderCorrectionType == OrderCorrectionType.READ ? "" : orderCorrectionType.toString());
        this.addToName(shouldOverrideContainerPolicy ? "OVERRIDE_CONTAINER_POLICY" : "");
        this.addToName(joinFetchOrBatchRead.toString());
    }

    void addToName(String strToAdd) {
        if (strToAdd.length() > 0) {
            this.setName(this.getName() + " " + strToAdd);
        }
    }

    public void addRequiredSystems() {
        if (!this.isTopLevel) {
            this.addRequiredSystem(new EmployeeSystem(this.useListOrderField, this.useIndirection, this.isPrivatelyOwned, this.useSecondaryTable, this.useVarcharOrder, this.changeTracking, this.orderCorrectionType, this.shouldOverrideContainerPolicy, this.joinFetchOrBatchRead));
        }
    }

    public void addTests() {
        if (!this.isTopLevel) {
            this.addTest((Test)new CreateTest());
            this.addTest((Test)new SimpleAddRemoveTest());
            if (this.joinFetchOrBatchRead != EmployeeSystem.JoinFetchOrBatchRead.INNER_JOIN && this.joinFetchOrBatchRead != EmployeeSystem.JoinFetchOrBatchRead.OUTER_JOIN) {
                this.addTest((Test)new SimpleAddRemoveTest2());
            }
            if (this.joinFetchOrBatchRead != EmployeeSystem.JoinFetchOrBatchRead.INNER_JOIN) {
                this.addTest((Test)new AddRemoveUpdateTest());
            }
            this.addTest((Test)new VerifyForeignKeyOfRemovedObject(false));
            this.addTest((Test)new VerifyForeignKeyOfRemovedObject(true));
            this.addTest((Test)new SimpleSetTest());
            this.addTest((Test)new SimpleSetListTest());
            this.addTest((Test)new SimpleSetListTest(false));
            this.addTest((Test)new SimpleSetListTest(true));
            this.addTest((Test)new TranspositionTest(new int[]{0, 1}, new int[]{1, 0}, false));
            this.addTest((Test)new TranspositionTest(new int[]{0, 1}, new int[]{1, 0}, true));
            this.addTest((Test)new TranspositionMergeTest(new int[]{0, 1}, new int[]{1, 0}));
            this.addTest((Test)new TranspositionTest(new int[]{1, 3, 5}, new int[]{5, 1, 3}, false));
            this.addTest((Test)new TranspositionTest(new int[]{1, 3, 5}, new int[]{5, 1, 3}, true));
            this.addTest((Test)new TranspositionMergeTest(new int[]{1, 3, 5}, new int[]{5, 1, 3}));
            this.addTest((Test)new AddNullTest(front));
            this.addTest((Test)new AddNullTest(middle));
            this.addTest((Test)new AddNullTest(end));
            if (this.joinFetchOrBatchRead != EmployeeSystem.JoinFetchOrBatchRead.INNER_JOIN && this.joinFetchOrBatchRead != EmployeeSystem.JoinFetchOrBatchRead.OUTER_JOIN) {
                this.addTest((Test)new AddDuplicateTest(front));
                this.addTest((Test)new AddDuplicateTest(middle));
                this.addTest((Test)new AddDuplicateTest(end));
            }
            if (this.joinFetchOrBatchRead == EmployeeSystem.JoinFetchOrBatchRead.OUTER_JOIN) {
                this.addTest((Test)new CreateEmptyTest());
                this.addTest((Test)new CreateEmptyManagersTest());
            }
            if (this.useListOrderField) {
                this.addTest((Test)new SimpleIndexTest(true));
                if (this.shouldOverrideContainerPolicy) {
                    this.addTest((Test)new VerifyContainerPolicyClassTest());
                }
                if (this.orderCorrectionType == OrderCorrectionType.EXCEPTION) {
                    if (this.joinFetchOrBatchRead != EmployeeSystem.JoinFetchOrBatchRead.INNER_JOIN) {
                        this.addTest((Test)new BreakOrderExceptionTest_OneToMany());
                    }
                    this.addTest((Test)new BreakOrderExceptionTest_UnidirectionalOneToMany());
                    this.addTest((Test)new BreakOrderExceptionTest_ManyToMany());
                    this.addTest((Test)new BreakOrderExceptionTest_DirectCollection());
                    if (this.changeTracking == EmployeeSystem.ChangeTracking.DEFERRED) {
                        this.addTest((Test)new BreakOrderExceptionTest_AggregateCollection());
                    }
                } else if (this.orderCorrectionType == OrderCorrectionType.READ_WRITE) {
                    this.addTest((Test)new BreakOrderCorrectionAndRemoveTest(false));
                    this.addTest((Test)new BreakOrderCorrectionAndRemoveTest(true));
                    this.addTest((Test)new BreakOrderCorrectionTest(false));
                    this.addTest((Test)new BreakOrderCorrectionTest(true));
                }
            }
            this.addTest((Test)new CreateManagersTest());
        } else {
            this.addModels();
        }
    }

    public void setup() {
        if (!this.isTopLevel && this.changeTracking == EmployeeSystem.ChangeTracking.ATTRIBUTE) {
            HashMap<Class<PhoneNumber>, ObjectChangePolicy> originalChangeTrackingPolicies = new HashMap<Class<PhoneNumber>, ObjectChangePolicy>();
            originalChangeTrackingPolicies.put(Employee.class, this.getSession().getDescriptor(Employee.class).getObjectChangePolicy());
            this.getSession().getDescriptor(Employee.class).setObjectChangePolicy((ObjectChangePolicy)new AttributeChangeTrackingPolicy());
            originalChangeTrackingPolicies.put(Project.class, this.getSession().getDescriptor(Project.class).getObjectChangePolicy());
            this.getSession().getDescriptor(Project.class).setObjectChangePolicy((ObjectChangePolicy)new AttributeChangeTrackingPolicy());
            originalChangeTrackingPolicies.put(SmallProject.class, this.getSession().getDescriptor(SmallProject.class).getObjectChangePolicy());
            this.getSession().getDescriptor(SmallProject.class).setObjectChangePolicy((ObjectChangePolicy)new AttributeChangeTrackingPolicy());
            originalChangeTrackingPolicies.put(LargeProject.class, this.getSession().getDescriptor(LargeProject.class).getObjectChangePolicy());
            this.getSession().getDescriptor(LargeProject.class).setObjectChangePolicy((ObjectChangePolicy)new AttributeChangeTrackingPolicy());
            if (this.changeTracking != EmployeeSystem.ChangeTracking.ATTRIBUTE) {
                originalChangeTrackingPolicies.put(PhoneNumber.class, this.getSession().getDescriptor(PhoneNumber.class).getObjectChangePolicy());
                this.getSession().getDescriptor(PhoneNumber.class).setObjectChangePolicy((ObjectChangePolicy)new AttributeChangeTrackingPolicy());
            }
        }
    }

    public void reset() {
        if (!this.isTopLevel && this.originalChangeTrackingPolicies != null) {
            for (Map.Entry<Class, ObjectChangeTrackingPolicy> entry : this.originalChangeTrackingPolicies.entrySet()) {
                this.getSession().getDescriptor(entry.getKey()).setObjectChangePolicy((ObjectChangePolicy)entry.getValue());
            }
            this.originalChangeTrackingPolicies = null;
        }
    }

    class VerifyForeignKeyOfRemovedObject
    extends ChangeTest {
        boolean deleteSourceObject;

        VerifyForeignKeyOfRemovedObject(boolean deleteSourceObject) {
            this.deleteSourceObject = deleteSourceObject;
            this.setName(this.getShortClassName() + (deleteSourceObject ? "_deleteSource" : "_removeTarget"));
        }

        @Override
        public void setup() {
            this.usePhones = false;
            this.useProjects = false;
            this.useResponsibilities = false;
            super.setup();
        }

        public void test() {
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            this.managerClone = (Employee)uow.registerObject((Object)this.manager);
            if (this.deleteSourceObject) {
                for (int i = 0; i < this.nSize; ++i) {
                    if (!this.useManagedEmployees) continue;
                    this.managerClone.getManagedEmployees().get(i).setManager(null);
                }
                uow.deleteObject((Object)this.managerClone);
            } else {
                for (int i = this.nSize - 1; 0 <= i; --i) {
                    if (this.useManagedEmployees) {
                        this.managerClone.removeManagedEmployee(i);
                    }
                    if (!this.useChildren) continue;
                    this.managerClone.getChildren().remove(i);
                }
            }
            uow.commit();
        }

        @Override
        public void verify() {
            int nonNulls;
            String sqlString;
            if (this.useManagedEmployees) {
                sqlString = "SELECT COUNT(*) FROM " + this.getManagegedEmployeesOrderTable() + " WHERE " + this.getManagegedEmployeesOrderField() + " IS NOT NULL";
                nonNulls = ((Number)((AbstractRecord)this.getSession().executeSQL(sqlString).get(0)).getValues().get(0)).intValue();
                if (nonNulls != 0) {
                    this.errorMsg = this.errorMsg + "useManagedEmployees has " + nonNulls + " non nulls; ";
                }
            }
            if (this.useChildren) {
                sqlString = "SELECT COUNT(*) FROM " + this.getChildrenOrderTable() + " WHERE " + this.getChildrenOrderField() + " IS NOT NULL";
                nonNulls = ((Number)((AbstractRecord)this.getSession().executeSQL(sqlString).get(0)).getValues().get(0)).intValue();
                if (nonNulls != 0) {
                    this.errorMsg = this.errorMsg + "useManagedEmployees has " + nonNulls + " non nulls; ";
                }
            }
        }
    }

    class VerifyContainerPolicyClassTest
    extends TestCase {
        Class expectedClass;

        VerifyContainerPolicyClassTest() {
            this(NullsLastOrderedListContainerPolicy.class);
        }

        VerifyContainerPolicyClassTest(Class expectedClass) {
            this.expectedClass = expectedClass;
            this.setName("VerifyContainerPolicyClassTest");
        }

        public void verify() {
            String errorMsg = "";
            List<CollectionMapping> listOrderMappings = EmployeeSystem.getListOrderMappings(this.getDatabaseSession());
            for (int i = 0; i < listOrderMappings.size(); ++i) {
                ReadQuery selectQuery;
                CollectionMapping mapping = listOrderMappings.get(i);
                if (!mapping.getContainerPolicy().getClass().equals(this.expectedClass)) {
                    errorMsg = errorMsg + mapping.getAttributeName() + ".containerPolicy type is wrong; ";
                }
                if ((selectQuery = mapping.getSelectionQuery()).isReadAllQuery()) {
                    if (((ReadAllQuery)selectQuery).getContainerPolicy().getClass().equals(this.expectedClass)) continue;
                    errorMsg = errorMsg + mapping.getAttributeName() + ".queryContainerPolicy type is wrong; ";
                    continue;
                }
                if (((DataReadQuery)selectQuery).getContainerPolicy().getClass().equals(this.expectedClass)) continue;
                errorMsg = errorMsg + mapping.getAttributeName() + ".queryContainerPolicy type is wrong; ";
            }
            if (errorMsg.length() > 0) {
                throw new TestErrorException(errorMsg);
            }
        }
    }

    class CreateEmptyManagersTest
    extends CreateManagersTest {
        CreateEmptyManagersTest() {
            this.nSize = 0;
        }
    }

    class CreateManagersTest
    extends BaseMultipleManagersTest {
        CreateManagersTest() {
        }

        @Override
        public void setup() {
            this.createManagers();
        }
    }

    class BaseMultipleManagersTest
    extends BaseTest {
        int nManagers;
        int nSize;
        List<Employee> managers;
        List<Employee> managerClones;

        BaseMultipleManagersTest() {
            this.managers = new ArrayList<Employee>(this.nManagers);
            this.managerClones = new ArrayList<Employee>(this.nManagers);
            this.nManagers = 2;
            this.nSize = 2;
        }

        void createManagers() {
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            for (int i = 0; i < this.nManagers; ++i) {
                String iStr = Integer.toString(i);
                Employee manager = new Employee("Manager", iStr);
                for (int j = 0; j < this.nSize; ++j) {
                    this.addTo(manager, this.create(iStr, j));
                }
                Employee managerClone = (Employee)uow.registerObject((Object)manager);
                this.managers.add(manager);
                this.managerClones.add(managerClone);
            }
            uow.commit();
        }

        @Override
        public void reset() {
            super.reset();
            this.managers.clear();
            this.managerClones.clear();
        }

        public void verify() {
            if (this.managers == null || this.managers.isEmpty()) {
                throw new TestErrorException("managers is null or empty. Nothing to verify");
            }
            for (int k = 0; k < 2; ++k) {
                String textNameExt;
                if (k == 0) {
                    textNameExt = "Cache";
                } else {
                    textNameExt = "DB";
                    this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
                    ReadAllQuery query = new ReadAllQuery();
                    query.setReferenceClass(Employee.class);
                    Expression exp = query.getExpressionBuilder().get("firstName").equal((Object)"Manager");
                    query.setSelectionCriteria(exp);
                    query.addOrdering(query.getExpressionBuilder().get("lastName"));
                    this.managers.clear();
                    this.managers.addAll((List)this.getSession().executeQuery((DatabaseQuery)query));
                }
                if (this.managers.size() != this.managerClones.size()) {
                    this.errorMsg = "wrong managers size " + this.managers.size() + "; expected size is " + this.managerClones.size();
                    continue;
                }
                for (int i = 0; i < this.managers.size(); ++i) {
                    if (this.getAbstractSession().compareObjects((Object)this.managerClones.get(i), (Object)this.managers.get(i))) continue;
                    String localErrorMsg = textNameExt + ": " + "manager[" + i + "] not equal\n";
                    this.errorMsg = this.errorMsg + localErrorMsg;
                }
            }
            if (this.errorMsg.length() > 0) {
                throw new TestErrorException(this.errorMsg);
            }
        }
    }

    class BreakOrderCorrectionTest
    extends ChangeTest {
        boolean shoulReadManagerThroughUow;

        BreakOrderCorrectionTest(boolean shoulReadManagerThroughUow) {
            this.nSize = 4;
            this.shoulReadManagerThroughUow = shoulReadManagerThroughUow;
            if (OrderListTestModel.this.orderCorrectionType != OrderCorrectionType.READ_WRITE) {
                throw new TestProblemException("Requires OrderCorrectionType.CORRECTION");
            }
            this.setName(this.getName() + (shoulReadManagerThroughUow ? " ReadThroughUow" : " ReadThroughSession"));
        }

        public void test() {
            this.breakOrder();
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            if (!this.shoulReadManagerThroughUow) {
                this.manager = (Employee)this.getSession().readObject((Object)this.manager);
                if (this.isInstantiated(this.manager)) {
                    this.errorMsg = this.verifyIsListOrderBrokenInDb(this.manager, true);
                    if (this.errorMsg.length() > 0) {
                        this.errorMsg = "manager in test: " + this.errorMsg;
                        throw new TestErrorException(this.errorMsg);
                    }
                }
            }
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            this.managerClone = this.shoulReadManagerThroughUow ? (Employee)uow.readObject((Object)this.manager) : (Employee)uow.registerObject((Object)this.manager);
            List list1 = this.removeFrom(this.managerClone, 1);
            this.errorMsg = this.verifyIsListOrderBrokenInDb(this.managerClone, true);
            if (this.errorMsg.length() > 0) {
                this.errorMsg = "managerClone in test: " + this.errorMsg;
                uow.release();
                throw new TestErrorException(this.errorMsg);
            }
            List list0 = this.removeFrom(this.managerClone, 0);
            this.addTo(this.managerClone, list1);
            this.addTo(this.managerClone, list0);
            uow.commit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void verify() {
            OrderCorrectionType originalMode = this.changeOrderCorrectionType(OrderCorrectionType.EXCEPTION);
            try {
                String localErrorMsg;
                if (this.shoulReadManagerThroughUow) {
                    ReadObjectQuery query = new ReadObjectQuery();
                    query.setReferenceClass(Employee.class);
                    query.checkCacheOnly();
                    this.manager = (Employee)this.getSession().readObject((Object)this.manager);
                }
                this.errorMsg = this.verifyIsListOrderBrokenInDb(this.manager, false);
                if (this.errorMsg.length() > 0) {
                    this.errorMsg = "manager in verify: " + this.errorMsg;
                }
                if ((localErrorMsg = this.verifyIsListOrderBrokenInDb(this.managerClone, false)).length() > 0) {
                    localErrorMsg = "managerClone in verify: " + localErrorMsg;
                    this.errorMsg = this.errorMsg + localErrorMsg;
                }
                super.verify();
            }
            finally {
                this.changeOrderCorrectionType(originalMode);
            }
        }
    }

    class BreakOrderCorrectionAndRemoveTest
    extends BreakOrderCorrectionTest {
        BreakOrderCorrectionAndRemoveTest(boolean shoulReadManagerThroughUow) {
            super(shoulReadManagerThroughUow);
        }

        @Override
        public void test() {
            this.breakOrder();
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            if (!this.shoulReadManagerThroughUow) {
                this.manager = (Employee)this.getSession().readObject((Object)this.manager);
                if (this.isInstantiated(this.manager)) {
                    this.errorMsg = this.verifyIsListOrderBrokenInDb(this.manager, true);
                    if (this.errorMsg.length() > 0) {
                        this.errorMsg = "manager in test: " + this.errorMsg;
                        throw new TestErrorException(this.errorMsg);
                    }
                }
            }
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            this.managerClone = this.shoulReadManagerThroughUow ? (Employee)uow.readObject((Object)this.manager) : (Employee)uow.registerObject((Object)this.manager);
            List list1 = this.removeFrom(this.managerClone, 1);
            this.errorMsg = this.verifyIsListOrderBrokenInDb(this.managerClone, true);
            if (this.errorMsg.length() > 0) {
                this.errorMsg = "managerClone in test: " + this.errorMsg;
                uow.release();
                throw new TestErrorException(this.errorMsg);
            }
            try {
                uow.commit();
            }
            catch (ArrayIndexOutOfBoundsException exception) {
                throw new TestErrorException("Test received exception commit when fixing a broken collection", (Throwable)exception);
            }
        }
    }

    class BreakOrderExceptionTest_AggregateCollection
    extends BreakOrderExceptionTest {
        BreakOrderExceptionTest_AggregateCollection() {
        }

        @Override
        public void test() {
            this.breakPhonesOrder();
        }
    }

    class BreakOrderExceptionTest_DirectCollection
    extends BreakOrderExceptionTest {
        BreakOrderExceptionTest_DirectCollection() {
        }

        @Override
        public void test() {
            this.breakResponsibilitiesOrder();
        }
    }

    class BreakOrderExceptionTest_ManyToMany
    extends BreakOrderExceptionTest {
        BreakOrderExceptionTest_ManyToMany() {
        }

        @Override
        public void test() {
            this.breakProjectsOrder();
        }
    }

    class BreakOrderExceptionTest_UnidirectionalOneToMany
    extends BreakOrderExceptionTest {
        BreakOrderExceptionTest_UnidirectionalOneToMany() {
        }

        @Override
        public void test() {
            this.breakChildrenOrder();
        }
    }

    class BreakOrderExceptionTest_OneToMany
    extends BreakOrderExceptionTest {
        BreakOrderExceptionTest_OneToMany() {
        }

        @Override
        public void test() {
            this.breakManagedEmployeesOrder();
        }
    }

    abstract class BreakOrderExceptionTest
    extends ChangeTest {
        BreakOrderExceptionTest() {
            if (OrderListTestModel.this.orderCorrectionType != OrderCorrectionType.EXCEPTION) {
                throw new TestProblemException("Requires OrderCorrectionType.EXCEPTION");
            }
        }

        public abstract void test();

        @Override
        protected void verify() {
            try {
                super.verify();
                throw new TestErrorException("Expected QueryException.LIST_ORDER_FIELD_WRONG_VALUE was not thrown.");
            }
            catch (QueryException queryException) {
                if (queryException.getErrorCode() == 6162) {
                    return;
                }
                throw queryException;
            }
        }
    }

    class AddDuplicateTest
    extends WhereToAddTest {
        AddDuplicateTest(String whereToAdd) {
            super(whereToAdd);
        }

        @Override
        List objectToAdd() {
            List newList = this.create("new", 0);
            List oldList = this.getFrom(this.managerClone, 0);
            for (int i = 0; i < newList.size(); ++i) {
                if (!(newList.get(i) instanceof String)) continue;
                newList.set(i, oldList.get(i));
                break;
            }
            return newList;
        }
    }

    class AddNullTest
    extends WhereToAddTest {
        AddNullTest(String whereToAdd) {
            super(whereToAdd);
        }

        @Override
        List objectToAdd() {
            List list = this.create("new", 0);
            for (int i = 0; i < list.size(); ++i) {
                if (!(list.get(i) instanceof String)) continue;
                list.set(i, null);
                break;
            }
            return list;
        }
    }

    abstract class WhereToAddTest
    extends ChangeTest {
        String whereToAdd;

        WhereToAddTest(String whereToAdd) {
            this.whereToAdd = whereToAdd;
            if (!(OrderListTestModel.front.equals(whereToAdd) || OrderListTestModel.middle.equals(whereToAdd) || OrderListTestModel.end.equals(whereToAdd))) {
                throw new TestProblemException("Wrong whereToAdd = " + whereToAdd + "; Supported values: " + OrderListTestModel.front + "; " + OrderListTestModel.middle + "; " + OrderListTestModel.end);
            }
            this.setName(this.getName() + " " + whereToAdd);
        }

        public void test() {
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            this.managerClone = (Employee)uow.registerObject((Object)this.manager);
            if (OrderListTestModel.front.equals(this.whereToAdd)) {
                this.addTo(this.managerClone, 0, this.objectToAdd());
            } else if (OrderListTestModel.middle.equals(this.whereToAdd)) {
                this.addTo(this.managerClone, 1, this.objectToAdd());
            } else if (OrderListTestModel.end.equals(this.whereToAdd)) {
                this.addTo(this.managerClone, this.objectToAdd());
            }
            uow.commit();
        }

        abstract List objectToAdd();
    }

    class SimpleIndexTest
    extends ChangeTest {
        int min;
        int max;
        int nExpected;
        boolean useIndex;

        SimpleIndexTest(boolean useIndex) {
            this.nSize = 12;
            this.min = 1;
            this.max = 4;
            this.nExpected = this.max - this.min + 1;
            this.useIndex = useIndex;
            this.setName(this.getName() + (useIndex ? " use index()" : " use getField()"));
        }

        public void test() {
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            if (this.useManagedEmployees) {
                this.test("managedEmployees");
            }
            if (this.useChildren) {
                this.test("children");
            }
            if (this.useProjects) {
                this.test("projects");
            }
            if (this.useResponsibilities) {
                this.test("responsibilitiesList");
            }
            if (this.usePhones) {
                this.test("phoneNumbers");
            }
        }

        void test(String attributeName) {
            ReportQuery query = new ReportQuery();
            query.setReferenceClass(Employee.class);
            ExpressionBuilder builder = query.getExpressionBuilder();
            Expression firstNameManager = builder.get("firstName").equal((Object)"Manager");
            Expression anyOfAttribute = builder.anyOf(attributeName);
            Expression exp = this.useIndex ? firstNameManager.and(anyOfAttribute.index().between(this.min, this.max)) : (this.isTableExpressionRequired(attributeName) ? firstNameManager.and(anyOfAttribute.getTable(this.getTableName(attributeName)).getField(this.getFieldName(attributeName)).between(this.min, this.max)) : firstNameManager.and(anyOfAttribute.getField(this.getFieldName(attributeName)).between(this.min, this.max)));
            query.setSelectionCriteria(exp);
            query.addAttribute(attributeName, anyOfAttribute);
            ArrayList<Integer> indexesRead = new ArrayList<Integer>(this.nExpected);
            boolean error = false;
            List results = (List)this.getSession().executeQuery((DatabaseQuery)query);
            for (int i = 0; i < results.size(); ++i) {
                ReportQueryResult result = (ReportQueryResult)results.get(i);
                int index = this.getIndex(result.getResults().get(0), attributeName);
                error |= this.max < index || index < this.min;
                indexesRead.add(index);
            }
            String localErrorMsg = "";
            if (error) {
                localErrorMsg = localErrorMsg + "Wrong index values read: " + indexesRead + "; expected all numbers between (inclusive) " + this.min + " and " + this.max;
            }
            if (OrderListTestModel.this.joinFetchOrBatchRead != EmployeeSystem.JoinFetchOrBatchRead.OUTER_JOIN && OrderListTestModel.this.joinFetchOrBatchRead != EmployeeSystem.JoinFetchOrBatchRead.INNER_JOIN && indexesRead.size() != this.nExpected) {
                localErrorMsg = localErrorMsg + attributeName + " Wrong number of objects read: " + indexesRead.size() + "; expected " + this.nExpected;
            }
            if (localErrorMsg.length() > 0) {
                localErrorMsg = attributeName + ": " + localErrorMsg + "\n";
                this.errorMsg = this.errorMsg + localErrorMsg;
            }
        }

        int getIndex(Object obj, String attributeName) {
            int index = -1;
            if (attributeName.equals("managedEmployees")) {
                index = Integer.parseInt(((Employee)obj).getFirstName());
            } else if (attributeName.equals("children")) {
                index = Integer.parseInt(((Child)obj).getFirstName());
            } else if (attributeName.equals("projects")) {
                index = this.getNumberFromString(((Project)obj).getName());
            } else if (attributeName.equals("responsibilitiesList")) {
                index = this.getNumberFromString((String)obj);
            } else if (attributeName.equals("phoneNumbers")) {
                index = Integer.parseInt(((PhoneNumber)obj).getNumber());
            }
            return index;
        }

        int getNumberFromString(String str) {
            char ch;
            int nEnd = str.length();
            int nStart = 0;
            for (nStart = 0; nStart < nEnd && ('0' > (ch = str.charAt(nStart)) || ch > '9'); ++nStart) {
            }
            str = str.substring(nStart);
            return Integer.parseInt(str);
        }

        @Override
        protected void verify() {
            if (this.errorMsg.length() > 0) {
                this.errorMsg = "\n" + this.errorMsg;
                throw new TestErrorException(this.errorMsg);
            }
        }

        boolean isTableExpressionRequired(String attributeName) {
            return attributeName.equals("projects") || attributeName.equals("responsibilitiesList");
        }

        String getTableName(String attributeName) {
            if (attributeName.equals("projects")) {
                return "OL_PROJ_EMP";
            }
            if (attributeName.equals("responsibilitiesList")) {
                return "OL_RESPONS";
            }
            throw new TestProblemException(attributeName + " should not be looking for table name.");
        }

        String getFieldName(String attributeName) {
            String fieldName = null;
            if (attributeName.equals("managedEmployees")) {
                fieldName = "MANAGED_ORDER";
            } else if (attributeName.equals("children")) {
                fieldName = "CHILDREN_ORDER";
            } else if (attributeName.equals("projects")) {
                fieldName = "PROJ_ORDER";
            } else if (attributeName.equals("responsibilitiesList")) {
                fieldName = "RESPONS_ORDER";
            } else if (attributeName.equals("phoneNumbers")) {
                fieldName = "PHONE_ORDER";
            }
            return fieldName;
        }
    }

    class SimpleSetListTest
    extends ChangeTest {
        Boolean useSet;

        SimpleSetListTest() {
        }

        SimpleSetListTest(boolean useSet) {
            this.useSet = useSet;
            this.setName(this.getName() + (useSet ? " set" : " remove/add"));
        }

        public void test() {
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            this.managerClone = (Employee)uow.registerObject((Object)this.manager);
            if (this.useSet != null) {
                if (this.useSet.booleanValue()) {
                    this.setInto(this.managerClone, 1, this.create("temp", 1));
                } else {
                    this.addTo(this.managerClone, this.create("temp", 2));
                }
            }
            List<List> list = this.createList();
            this.addTo(list, this.create("new", 0));
            this.addTo(list, this.create("new", 1));
            this.setListInto(this.managerClone, list);
            uow.commit();
        }
    }

    class SimpleSetTest
    extends ChangeTest {
        SimpleSetTest() {
        }

        public void test() {
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            this.managerClone = (Employee)uow.registerObject((Object)this.manager);
            this.setInto(this.managerClone, 1, this.create("new", 1));
            uow.commit();
        }
    }

    class SimpleAddRemoveTest2
    extends ChangeTest {
        SimpleAddRemoveTest2() {
            this.nSize = 12;
        }

        public void test() {
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            this.managerClone = (Employee)uow.registerObject((Object)this.manager);
            this.addTo(this.managerClone, 0, this.create("new", 0));
            this.addTo(this.managerClone, 4, this.create("new", 4));
            this.removeFrom(this.managerClone, 8);
            uow.commit();
        }
    }

    class AddRemoveUpdateTest
    extends ChangeTest {
        List removedList;
        List removedListClone;

        AddRemoveUpdateTest() {
        }

        @Override
        public void setup() {
            this.useResponsibilities = false;
            this.usePhones = false;
            super.setup();
        }

        public void test() {
            List newList = this.create("new", 0);
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            List newListClone = this.register(newList, uow);
            uow.commit();
            this.removedList = this.getFrom(this.manager, 0);
            uow = this.getSession().acquireUnitOfWork();
            this.managerClone = (Employee)uow.registerObject((Object)this.manager);
            newListClone = this.register(newList, uow);
            this.update(newListClone, "updated", 0);
            this.addTo(this.managerClone, newListClone);
            this.removedListClone = this.removeFrom(this.managerClone, 0);
            this.update(this.removedListClone, "updated", 0);
            uow.commit();
        }

        @Override
        public void verify() {
            super.verify();
            if (OrderListTestModel.this.isPrivatelyOwned) {
                this.verifyListRemoved(this.removedList);
            } else {
                this.verifyList(this.removedList, this.removedListClone);
            }
            if (this.errorMsg.length() > 0) {
                throw new TestErrorException('\n' + this.errorMsg);
            }
        }
    }

    class SimpleAddRemoveTest
    extends ChangeTest {
        SimpleAddRemoveTest() {
        }

        public void test() {
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            this.managerClone = (Employee)uow.registerObject((Object)this.manager);
            this.addTo(this.managerClone, this.create("new", 1));
            this.removeFrom(this.managerClone, 0);
            uow.commit();
        }
    }

    class TranspositionMergeTest
    extends TranspositionTest {
        TranspositionMergeTest(int nSize, int[] oldIndexes, int[] newIndexes) {
            super(nSize, oldIndexes, newIndexes, true);
        }

        TranspositionMergeTest(int[] oldIndexes, int[] newIndexes) {
            super(oldIndexes, newIndexes, true);
        }

        @Override
        void setName() {
            this.setName(this.getName() + " " + this.toString(this.oldIndexes) + " -> " + this.toString(this.newIndexes));
        }

        @Override
        public void test() {
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            this.transpose(uow);
            uow.unregisterObject((Object)this.managerClone);
            uow.release();
            uow = this.getSession().acquireUnitOfWork();
            this.managerClone = (Employee)uow.mergeCloneWithReferences((Object)this.managerClone);
            uow.commit();
        }
    }

    class TranspositionTest
    extends ChangeTest {
        int[] oldIndexes;
        int[] newIndexes;
        boolean useSet;

        TranspositionTest(int nSize, int[] oldIndexes, int[] newIndexes, boolean useSet) {
            this.nSize = nSize;
            this.oldIndexes = oldIndexes;
            this.newIndexes = newIndexes;
            this.useSet = useSet;
            this.verifyIndexes();
            for (int i = 0; i < oldIndexes.length; ++i) {
                if (oldIndexes[i] >= nSize) {
                    throw new TestProblemException("oldIndex[" + i + "] = " + oldIndexes[i] + ", which is greater than nSize =" + nSize);
                }
                if (newIndexes[i] < nSize) continue;
                throw new TestProblemException("newIndex[" + i + "] = " + newIndexes[i] + ", which is greater than nSize =" + nSize);
            }
            this.setName();
        }

        TranspositionTest(int[] oldIndexes, int[] newIndexes, boolean useSet) {
            this.oldIndexes = oldIndexes;
            this.newIndexes = newIndexes;
            this.useSet = useSet;
            this.verifyIndexes();
            this.nSize = 0;
            for (int i = 0; i < oldIndexes.length; ++i) {
                if (oldIndexes[i] > this.nSize) {
                    this.nSize = oldIndexes[i];
                }
                if (newIndexes[i] <= this.nSize) continue;
                this.nSize = newIndexes[i];
            }
            ++this.nSize;
            this.setName();
        }

        public void verifyIndexes() {
            if (this.oldIndexes.length != this.newIndexes.length) {
                throw new TestProblemException("oldIndexes.length != newIndexes.length");
            }
            for (int i = 0; i < this.oldIndexes.length; ++i) {
                int oldIndex = this.oldIndexes[i];
                boolean found = false;
                for (int j = 0; j < this.newIndexes.length; ++j) {
                    if (oldIndex != this.newIndexes[j]) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                throw new TestProblemException("oldIndexes[" + i + "] value " + oldIndex + " not found in newIndexes");
            }
        }

        String toString(int[] array) {
            String str = "[";
            for (int i = 0; i < array.length; ++i) {
                str = str + Integer.toString(array[i]);
                str = i < array.length - 1 ? str + ", " : str + "]";
            }
            return str;
        }

        void setName() {
            this.setName(this.getName() + " " + this.toString(this.oldIndexes) + " -> " + this.toString(this.newIndexes) + (this.useSet ? " set" : " remove/add"));
        }

        public void transpose(UnitOfWork uow) {
            int i;
            this.managerClone = (Employee)uow.registerObject((Object)this.manager);
            int n = this.oldIndexes.length;
            ArrayList[] lists = new ArrayList[n];
            for (i = 0; i < n; ++i) {
                lists[i] = this.getFrom(this.managerClone, this.oldIndexes[i]);
            }
            for (i = 0; i < n; ++i) {
                int newIndex = this.newIndexes[i];
                if (this.useSet) {
                    this.setInto_NoRelMaintanence(this.managerClone, newIndex, lists[i]);
                    continue;
                }
                this.removeFrom_NoRelMaintanence(this.managerClone, newIndex);
                this.addTo_NoRelMaintanence(this.managerClone, newIndex, lists[i]);
            }
        }

        public void test() {
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            this.transpose(uow);
            uow.commit();
        }
    }

    class ChangeTest
    extends BaseManagerTest {
        ChangeTest() {
        }

        @Override
        public void setup() {
            super.setup();
            this.createManager();
        }
    }

    class CreateEmptyTest
    extends CreateTest {
        CreateEmptyTest() {
            this.nSize = 0;
        }
    }

    class CreateTest
    extends BaseManagerTest {
        CreateTest() {
        }

        public void test() {
            this.createManager();
        }
    }

    class BaseManagerTest
    extends BaseTest {
        int nSize;
        Employee manager;
        Employee managerClone;

        BaseManagerTest() {
            this.nSize = 2;
        }

        void createManager() {
            this.manager = new Employee("Manager");
            for (int i = 0; i < this.nSize; ++i) {
                this.addTo(this.manager, this.create("old", i));
            }
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            this.managerClone = (Employee)uow.registerObject((Object)this.manager);
            uow.commit();
        }

        protected void verify() {
            if (this.manager == null) {
                throw new TestErrorException("manager == null. Nothing to verify");
            }
            for (int k = 0; k < 2; ++k) {
                String textNameExt;
                if (k == 0) {
                    textNameExt = "Cache";
                } else {
                    textNameExt = "DB";
                    this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
                    this.manager = (Employee)this.getSession().readObject((Object)this.manager);
                }
                if (this.getAbstractSession().compareObjects((Object)this.managerClone, (Object)this.manager)) continue;
                this.errorMsg = this.errorMsg + textNameExt + ": " + "objects not equal\n";
            }
            if (this.errorMsg.length() > 0) {
                throw new TestErrorException('\n' + this.errorMsg);
            }
        }

        protected void verifyList(List listToVerify, List listToCompareTo) {
            if (listToVerify == null) {
                throw new TestErrorException("listToVerify is null. Nothing to verify");
            }
            int size = listToVerify.size();
            for (int k = 0; k < 2; ++k) {
                int i;
                String textNameExt;
                if (k == 0) {
                    textNameExt = "Cache";
                } else {
                    textNameExt = "DB";
                    this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
                    for (i = 0; i < size; ++i) {
                        listToVerify.set(i, this.getSession().readObject(listToVerify.get(i)));
                    }
                }
                for (i = 0; i < size; ++i) {
                    Object toVerify = listToVerify.get(i);
                    Object toCompareTo = listToCompareTo.get(i);
                    if (this.getAbstractSession().compareObjects(toCompareTo, toVerify)) continue;
                    this.errorMsg = this.errorMsg + textNameExt + ": " + "objects not equal\n";
                }
            }
        }

        protected void verifyListRemoved(List listToVerify) {
            if (listToVerify == null) {
                throw new TestErrorException("listToVerify is null. Nothing to verify");
            }
            int size = listToVerify.size();
            for (int k = 0; k < 2; ++k) {
                int i;
                String textNameExt;
                if (k == 0) {
                    textNameExt = "Cache";
                    for (i = 0; i < size; ++i) {
                        ReadObjectQuery query = new ReadObjectQuery();
                        query.setSelectionObject(listToVerify.get(i));
                        query.checkCacheOnly();
                        Object readObject = this.getSession().executeQuery((DatabaseQuery)query);
                        if (readObject == null) continue;
                        this.errorMsg = this.errorMsg + textNameExt + ": " + readObject + " was not removed\n";
                    }
                    continue;
                }
                textNameExt = "DB";
                this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
                for (i = 0; i < size; ++i) {
                    Object readObject = this.getSession().readObject(listToVerify.get(i));
                    if (readObject == null) continue;
                    this.errorMsg = this.errorMsg + textNameExt + ": " + readObject + " was not removed\n";
                }
            }
        }

        @Override
        public void reset() {
            super.reset();
            this.manager = null;
            this.managerClone = null;
        }

        String nSizeName() {
            return this.getShortClassName() + ": " + this.nSize + ":";
        }
    }

    class BaseTest
    extends TestCase {
        boolean useManagedEmployees = true;
        boolean useChildren = true;
        boolean useProjects = true;
        boolean useResponsibilities = true;
        boolean usePhones = true;
        String errorMsg;

        BaseTest() {
            this.setValidFlags();
            this.errorMsg = "";
            this.setName(this.getShortClassName());
        }

        protected void setValidFlags() {
            if (OrderListTestModel.this.changeTracking == EmployeeSystem.ChangeTracking.ATTRIBUTE) {
                this.usePhones = false;
            }
            if (OrderListTestModel.this.joinFetchOrBatchRead == EmployeeSystem.JoinFetchOrBatchRead.INNER_JOIN) {
                this.useManagedEmployees = false;
            }
        }

        protected void validateFlags() {
            if (OrderListTestModel.this.changeTracking == EmployeeSystem.ChangeTracking.ATTRIBUTE && this.usePhones) {
                this.errorMsg = this.errorMsg + "ChangeTracking.ATTRIBUTE requires usePhones==false; ";
            }
            if (OrderListTestModel.this.joinFetchOrBatchRead == EmployeeSystem.JoinFetchOrBatchRead.INNER_JOIN && this.useManagedEmployees) {
                this.errorMsg = this.errorMsg + "JoinFetchOrBatchRead.INNER_JOIN requires useManagedEmployees==false; ";
            }
            if (this.errorMsg.length() > 0) {
                throw new TestProblemException(this.errorMsg);
            }
        }

        public void setup() {
            if (!(this.useManagedEmployees || this.useChildren || this.useProjects || this.useResponsibilities || this.usePhones)) {
                throw new TestProblemException("useManagedEmployees, useChildren, useProjects, useResponsibilities, usePhones are all false - nothing to test");
            }
            this.validateFlags();
        }

        public void reset() {
            if (this.useManagedEmployees) {
                if (OrderListTestModel.this.useSecondaryTable) {
                    this.getSession().executeNonSelectingSQL("UPDATE OL_SALARY SET MANAGER_ID = NULL");
                } else {
                    this.getSession().executeNonSelectingSQL("UPDATE OL_EMPLOYEE SET MANAGER_ID = NULL");
                }
            }
            if (this.useChildren) {
                this.getSession().executeNonSelectingSQL("DELETE FROM OL_ALLOWANCE");
                this.getSession().executeNonSelectingSQL("DELETE FROM OL_CHILD");
            }
            if (this.useProjects) {
                this.getSession().executeNonSelectingSQL("DELETE FROM OL_PROJ_EMP");
                this.getSession().executeNonSelectingSQL("DELETE FROM OL_LPROJECT");
                this.getSession().executeNonSelectingSQL("DELETE FROM OL_PROJECT");
            }
            if (this.useResponsibilities) {
                this.getSession().executeNonSelectingSQL("DELETE FROM OL_RESPONS");
            }
            if (this.usePhones) {
                this.getSession().executeNonSelectingSQL("DELETE FROM OL_PHONE");
            }
            this.getSession().executeNonSelectingSQL("DELETE FROM OL_SALARY");
            this.getSession().executeNonSelectingSQL("DELETE FROM OL_EMPLOYEE");
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            this.errorMsg = "";
        }

        List create(String prefix, int indexForName) {
            ArrayList<Object> list = new ArrayList<Object>();
            String iString = Integer.toString(indexForName);
            String str = prefix + iString;
            if (this.useManagedEmployees) {
                list.add(new Employee(iString, prefix));
            }
            if (this.useChildren) {
                list.add(new Child(iString, prefix));
            }
            if (this.useProjects) {
                if (indexForName % 2 == 0) {
                    list.add(new SmallProject(str));
                } else {
                    list.add(new LargeProject(str));
                }
            }
            if (this.useResponsibilities) {
                list.add(str);
            }
            if (this.usePhones) {
                if (prefix.length() > 3) {
                    prefix = prefix.substring(0, 3);
                }
                list.add(new PhoneNumber(prefix, iString));
            }
            return list;
        }

        List createNull() {
            ArrayList<Object> list = new ArrayList<Object>();
            if (this.useManagedEmployees) {
                list.add(null);
            }
            if (this.useChildren) {
                list.add(null);
            }
            if (this.useProjects) {
                list.add(null);
            }
            if (this.useResponsibilities) {
                list.add(null);
            }
            if (this.usePhones) {
                list.add(null);
            }
            return list;
        }

        void addTo(Employee empManager, List list) {
            int i = 0;
            if (this.useManagedEmployees) {
                empManager.addManagedEmployee((Employee)list.get(i++));
            }
            if (this.useChildren) {
                empManager.getChildren().add(list.get(i++));
            }
            if (this.useProjects) {
                empManager.addProject((Project)list.get(i++));
            }
            if (this.useResponsibilities) {
                empManager.addResponsibility((String)list.get(i++));
            }
            if (this.usePhones) {
                empManager.addPhoneNumber((PhoneNumber)list.get(i++));
            }
        }

        void addTo(Employee empManager, int index, List list) {
            int i = 0;
            if (this.useManagedEmployees) {
                empManager.addManagedEmployee(index, (Employee)list.get(i++));
            }
            if (this.useChildren) {
                empManager.getChildren().add(index, list.get(i++));
            }
            if (this.useProjects) {
                empManager.addProject(index, (Project)list.get(i++));
            }
            if (this.useResponsibilities) {
                empManager.addResponsibility(index, (String)list.get(i++));
            }
            if (this.usePhones) {
                empManager.addPhoneNumber(index, (PhoneNumber)list.get(i++));
            }
        }

        void addTo_NoRelMaintanence(Employee empManager, int index, List list) {
            int i = 0;
            if (this.useManagedEmployees) {
                empManager.getManagedEmployees().add(index, (Employee)list.get(i++));
            }
            if (this.useChildren) {
                empManager.getChildren().add(index, list.get(i++));
            }
            if (this.useProjects) {
                empManager.getProjects().add(index, (Project)list.get(i++));
            }
            if (this.useResponsibilities) {
                empManager.addResponsibility(index, (String)list.get(i++));
            }
            if (this.usePhones) {
                empManager.addPhoneNumber(index, (PhoneNumber)list.get(i++));
            }
        }

        List removeFrom(Employee empManager, int index) {
            ArrayList<Object> list = new ArrayList<Object>();
            if (this.useManagedEmployees) {
                list.add(empManager.removeManagedEmployee(index));
            }
            if (this.useChildren) {
                list.add(empManager.getChildren().remove(index));
            }
            if (this.useProjects) {
                list.add(empManager.removeProject(index));
            }
            if (this.useResponsibilities) {
                list.add(empManager.removeResponsibility(index));
            }
            if (this.usePhones) {
                list.add(empManager.removePhoneNumber(index));
            }
            return list;
        }

        List removeFrom_NoRelMaintanence(Employee empManager, int index) {
            ArrayList<Object> list = new ArrayList<Object>();
            if (this.useManagedEmployees) {
                list.add(empManager.getManagedEmployees().remove(index));
            }
            if (this.useChildren) {
                list.add(empManager.getChildren().remove(index));
            }
            if (this.useProjects) {
                list.add(empManager.getProjects().remove(index));
            }
            if (this.useResponsibilities) {
                list.add(empManager.removeResponsibility(index));
            }
            if (this.usePhones) {
                list.add(empManager.removePhoneNumber(index));
            }
            return list;
        }

        List getFrom(Employee empManager, int index) {
            ArrayList<Object> list = new ArrayList<Object>();
            if (this.useManagedEmployees) {
                list.add(empManager.getManagedEmployees().get(index));
            }
            if (this.useChildren) {
                list.add(empManager.getChildren().get(index));
            }
            if (this.useProjects) {
                list.add(empManager.getProjects().get(index));
            }
            if (this.useResponsibilities) {
                list.add(empManager.getResponsibilitiesList().get(index));
            }
            if (this.usePhones) {
                list.add(empManager.getPhoneNumbers().get(index));
            }
            return list;
        }

        List setInto(Employee empManager, int index, List list) {
            int i = 0;
            ArrayList<Object> listOut = new ArrayList<Object>();
            if (this.useManagedEmployees) {
                listOut.add(empManager.setManagedEmployee(index, (Employee)list.get(i++)));
            }
            if (this.useChildren) {
                listOut.add(empManager.getChildren().set(index, list.get(i++)));
            }
            if (this.useProjects) {
                listOut.add(empManager.setProject(index, (Project)list.get(i++)));
            }
            if (this.useResponsibilities) {
                listOut.add(empManager.setResponsibility(index, (String)list.get(i++)));
            }
            if (this.usePhones) {
                listOut.add(empManager.setPhoneNumber(index, (PhoneNumber)list.get(i++)));
            }
            return listOut;
        }

        List setInto_NoRelMaintanence(Employee empManager, int index, List list) {
            int i = 0;
            ArrayList<Object> listOut = new ArrayList<Object>();
            if (this.useManagedEmployees) {
                listOut.add(empManager.getManagedEmployees().set(index, (Employee)list.get(i++)));
            }
            if (this.useChildren) {
                listOut.add(empManager.getChildren().set(index, list.get(i++)));
            }
            if (this.useProjects) {
                listOut.add(empManager.getProjects().set(index, (Project)list.get(i++)));
            }
            if (this.useResponsibilities) {
                listOut.add(empManager.setResponsibility(index, (String)list.get(i++)));
            }
            if (this.usePhones) {
                listOut.add(empManager.setPhoneNumber(index, (PhoneNumber)list.get(i++)));
            }
            return listOut;
        }

        void setListInto(Employee empManager, List<List> listOfLists) {
            int j;
            List<Object> oldList;
            List newList;
            int i = 0;
            if (this.useManagedEmployees) {
                newList = listOfLists.get(i++);
                oldList = empManager.getManagedEmployees();
                empManager.setManagedEmployees(newList);
                if (oldList != null) {
                    for (j = 0; j < oldList.size(); ++j) {
                        ((Employee)oldList.get(j)).setManager(null);
                    }
                }
                if (newList != null) {
                    for (j = 0; j < newList.size(); ++j) {
                        ((Employee)newList.get(j)).setManager(empManager);
                    }
                }
            }
            if (this.useChildren) {
                empManager.setChildren((Vector)listOfLists.get(i++));
            }
            if (this.useProjects) {
                newList = listOfLists.get(i++);
                oldList = empManager.getProjects();
                empManager.setProjects(newList);
                if (oldList != null) {
                    for (j = 0; j < oldList.size(); ++j) {
                        ((Project)oldList.get(j)).getEmployees().remove(empManager);
                    }
                }
                if (newList != null) {
                    for (j = 0; j < newList.size(); ++j) {
                        ((Project)newList.get(j)).getEmployees().add(empManager);
                    }
                }
            }
            if (this.useResponsibilities) {
                empManager.setResponsibilitiesList(listOfLists.get(i++));
            }
            if (this.usePhones) {
                empManager.setPhoneNumbers(listOfLists.get(i++));
            }
        }

        void update(List list, String prefix, int indexForName) {
            String iString = Integer.toString(indexForName);
            int i = 0;
            if (this.useManagedEmployees) {
                Employee emp = (Employee)list.get(i++);
                emp.setFirstName(iString);
                emp.setLastName(prefix);
            }
            if (this.useChildren) {
                Child child = (Child)list.get(i++);
                child.setFirstName(iString);
                child.setLastName(prefix);
            }
            if (this.useProjects) {
                Project project = (Project)list.get(i++);
                project.setName(iString);
            }
            if (this.useResponsibilities) {
                throw new TestProblemException("Can't update a String. Set useResponsibilities to false");
            }
            if (this.usePhones) {
                if (prefix.length() > 3) {
                    prefix = prefix.substring(0, 3);
                }
                PhoneNumber phone = (PhoneNumber)list.get(i++);
                phone.setAreaCode(prefix);
                phone.setNumber(iString);
            }
        }

        List register(List list, UnitOfWork uow) {
            ArrayList<Object> listClone = new ArrayList<Object>(list.size());
            int i = 0;
            if (this.useManagedEmployees) {
                listClone.add(uow.registerObject(list.get(i++)));
            }
            if (this.useChildren) {
                listClone.add(uow.registerObject(list.get(i++)));
            }
            if (this.useProjects) {
                listClone.add(uow.registerObject(list.get(i++)));
            }
            if (this.useResponsibilities) {
                throw new TestProblemException("Can't register a String in uow. Set useResponsibilities to false");
            }
            if (this.usePhones) {
                throw new TestProblemException("Can't register aggregate in uow. Set usePhones to false");
            }
            return listClone;
        }

        List<List> createList() {
            ArrayList<List> listOfLists = new ArrayList<List>();
            if (this.useManagedEmployees) {
                listOfLists.add(new ArrayList());
            }
            if (this.useChildren) {
                listOfLists.add(new Vector());
            }
            if (this.useProjects) {
                listOfLists.add(new ArrayList());
            }
            if (this.useResponsibilities) {
                listOfLists.add(new ArrayList());
            }
            if (this.usePhones) {
                listOfLists.add(new ArrayList());
            }
            return listOfLists;
        }

        void addTo(List<List> listOfLists, List list) {
            int i = 0;
            if (this.useManagedEmployees) {
                listOfLists.get(i).add(list.get(i++));
            }
            if (this.useChildren) {
                listOfLists.get(i).add(list.get(i++));
            }
            if (this.useProjects) {
                listOfLists.get(i).add(list.get(i++));
            }
            if (this.useResponsibilities) {
                listOfLists.get(i).add(list.get(i++));
            }
            if (this.usePhones) {
                listOfLists.get(i).add(list.get(i++));
            }
        }

        String getManagegedEmployeesOrderTable() {
            return OrderListTestModel.this.useSecondaryTable ? "OL_SALARY" : "OL_EMPLOYEE";
        }

        String getManagegedEmployeesOrderField() {
            return OrderListTestModel.this.useVarcharOrder ? "MANAGED_ORDER_VARCHAR" : "MANAGED_ORDER";
        }

        void breakManagedEmployeesOrder() {
            this.executeBreak(this.getManagegedEmployeesOrderTable(), this.getManagegedEmployeesOrderField(), "1", "NULL");
        }

        String getChildrenOrderTable() {
            return OrderListTestModel.this.useSecondaryTable ? "OL_ALLOWANCE" : "OL_CHILD";
        }

        String getChildrenOrderField() {
            return OrderListTestModel.this.useVarcharOrder ? "CHILDREN_ORDER_VARCHAR" : "CHILDREN_ORDER";
        }

        void breakChildrenOrder() {
            this.executeBreak(this.getChildrenOrderTable(), this.getChildrenOrderField(), "0", "NULL");
        }

        void breakProjectsOrder() {
            String tableName = "OL_PROJ_EMP";
            String fieldName = OrderListTestModel.this.useVarcharOrder ? "PROJ_ORDER_VARCHAR" : "PROJ_ORDER";
            this.executeBreak(tableName, fieldName, "0", "5");
        }

        void breakResponsibilitiesOrder() {
            String tableName = "OL_RESPONS";
            String fieldName = OrderListTestModel.this.useVarcharOrder ? "RESPONS_ORDER_VARCHAR" : "RESPONS_ORDER";
            this.executeBreak(tableName, fieldName, "1", "0");
        }

        void breakPhonesOrder() {
            String tableName = "OL_PHONE";
            String fieldName = OrderListTestModel.this.useVarcharOrder ? "PHONE_ORDER_VARCHAR" : "PHONE_ORDER";
            this.executeBreak(tableName, fieldName, "0", "1");
        }

        void executeBreak(String tableName, String fieldName, String oldValue, String newValue) {
            this.getSession().executeNonSelectingSQL("UPDATE " + tableName + " SET " + fieldName + " = " + newValue + " WHERE " + fieldName + " = " + oldValue);
        }

        void breakOrder() {
            if (this.useManagedEmployees) {
                this.breakManagedEmployeesOrder();
            }
            if (this.useChildren) {
                this.breakChildrenOrder();
            }
            if (this.useProjects) {
                this.breakProjectsOrder();
            }
            if (this.useResponsibilities) {
                this.breakResponsibilitiesOrder();
            }
            if (this.usePhones) {
                this.breakPhonesOrder();
            }
        }

        OrderCorrectionType changeOrderCorrectionType(OrderCorrectionType mode) {
            OrderCorrectionType oldMode = null;
            if (this.useManagedEmployees) {
                oldMode = this.changeOrderCorrectionType("managedEmployees", mode, oldMode);
            }
            if (this.useChildren) {
                oldMode = this.changeOrderCorrectionType("children", mode, oldMode);
            }
            if (this.useProjects) {
                oldMode = this.changeOrderCorrectionType("projects", mode, oldMode);
            }
            if (this.useResponsibilities) {
                oldMode = this.changeOrderCorrectionType("responsibilitiesList", mode, oldMode);
            }
            if (this.usePhones) {
                oldMode = this.changeOrderCorrectionType("phoneNumbers", mode, oldMode);
            }
            return oldMode;
        }

        OrderCorrectionType changeOrderCorrectionType(String attribute, OrderCorrectionType mode, OrderCorrectionType oldMode) {
            ClassDescriptor desc = this.getSession().getDescriptor(Employee.class);
            CollectionMapping mapping = (CollectionMapping)desc.getMappingForAttributeName(attribute);
            OrderCorrectionType currOldMode = this.changeOrderCorrectionType(mapping, mode);
            if (oldMode != null && oldMode != currOldMode) {
                throw new TestProblemException("OrderCorrectionTypes for " + attribute + " is " + currOldMode + "; for previous mapping(s) it was " + oldMode);
            }
            return currOldMode;
        }

        OrderCorrectionType changeOrderCorrectionType(CollectionMapping mapping, OrderCorrectionType mode) {
            OrderedListContainerPolicy policy = (OrderedListContainerPolicy)mapping.getContainerPolicy();
            OrderCorrectionType oldMode = policy.getOrderCorrectionType();
            policy.setOrderCorrectionType(mode);
            OrderedListContainerPolicy queryPolicy = null;
            if (mapping.getSelectionQuery().isReadAllQuery()) {
                queryPolicy = (OrderedListContainerPolicy)((ReadAllQuery)mapping.getSelectionQuery()).getContainerPolicy();
            } else if (mapping.getSelectionQuery().isDataReadQuery()) {
                queryPolicy = (OrderedListContainerPolicy)((DataReadQuery)mapping.getSelectionQuery()).getContainerPolicy();
            }
            if (policy != queryPolicy) {
                OrderCorrectionType oldModeQuery = queryPolicy.getOrderCorrectionType();
                if (oldMode != oldModeQuery) {
                    throw new TestErrorException(mapping.getAttributeName() + ": OrderCorrectionTypes in container policy is " + oldMode + "; is query is " + oldModeQuery);
                }
                queryPolicy.setOrderCorrectionType(mode);
            }
            return oldMode;
        }

        String verifyIsListOrderBrokenInDb(Employee empManager, boolean expected) {
            String localErrorMsg = "";
            if (this.useManagedEmployees) {
                localErrorMsg = localErrorMsg + this.verifyIsListOrderBrokenInDb(empManager, expected, "managedEmployees");
            }
            if (this.useChildren) {
                localErrorMsg = localErrorMsg + this.verifyIsListOrderBrokenInDb(empManager, expected, "children");
            }
            if (this.useProjects) {
                localErrorMsg = localErrorMsg + this.verifyIsListOrderBrokenInDb(empManager, expected, "projects");
            }
            if (this.useResponsibilities) {
                localErrorMsg = localErrorMsg + this.verifyIsListOrderBrokenInDb(empManager, expected, "responsibilitiesList");
            }
            if (this.usePhones) {
                localErrorMsg = localErrorMsg + this.verifyIsListOrderBrokenInDb(empManager, expected, "phoneNumbers");
            }
            if (localErrorMsg.length() > 0) {
                localErrorMsg = "isListOrderBrokenInDb expected to be " + expected + ". For the following attributes it is " + !expected + ": " + localErrorMsg;
            }
            return localErrorMsg;
        }

        String verifyIsListOrderBrokenInDb(Employee empManager, boolean expected, String attribute) {
            String localErrorMsg = "";
            ClassDescriptor desc = this.getSession().getDescriptor(Employee.class);
            CollectionMapping mapping = (CollectionMapping)desc.getMappingForAttributeName(attribute);
            Object attributeValue = mapping.getRealAttributeValueFromObject((Object)empManager, this.getAbstractSession());
            if (((IndirectList)attributeValue).isListOrderBrokenInDb() != expected) {
                localErrorMsg = attribute + "; ";
            }
            return localErrorMsg;
        }

        boolean isInstantiated(Employee empManager) {
            String str;
            boolean isInstantiated;
            List<Object> list;
            String instantiatedStr = "";
            String notInstantiatedStr = "";
            if (this.useManagedEmployees) {
                list = empManager.getManagedEmployees();
                isInstantiated = this.isInstantiated(list);
                str = isInstantiated ? instantiatedStr : notInstantiatedStr;
                str = str + "managedEmployees; ";
            }
            if (this.useChildren) {
                list = empManager.getChildren();
                isInstantiated = this.isInstantiated(list);
                str = isInstantiated ? instantiatedStr : notInstantiatedStr;
                str = str + "children; ";
            }
            if (this.useProjects) {
                list = empManager.getProjects();
                isInstantiated = this.isInstantiated(list);
                str = isInstantiated ? instantiatedStr : notInstantiatedStr;
                str = str + "projects; ";
            }
            if (this.useResponsibilities) {
                list = empManager.getResponsibilitiesList();
                isInstantiated = this.isInstantiated(list);
                str = isInstantiated ? instantiatedStr : notInstantiatedStr;
                str = str + "responsibilities; ";
            }
            if (this.usePhones) {
                list = empManager.getPhoneNumbers();
                isInstantiated = this.isInstantiated(list);
                str = isInstantiated ? instantiatedStr : notInstantiatedStr;
                str = str + "phoneNumbers; ";
            }
            if (instantiatedStr.length() > 0 && notInstantiatedStr.length() > 0) {
                throw new TestProblemException("Some attributes are instantiated: " + instantiatedStr + " and some are not: " + notInstantiatedStr);
            }
            return instantiatedStr.length() > 0;
        }

        boolean isInstantiated(List list) {
            return !(list instanceof IndirectList) || ((IndirectList)list).isInstantiated();
        }

        String getShortClassName() {
            String name = ((Object)((Object)this)).getClass().getName();
            int begin = name.indexOf(36) + 1;
            int end = name.length();
            return name.substring(begin, end);
        }
    }
}

