/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestSuite;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.DefaultConnector;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.framework.LoadBuildSystem;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestCollection;
import org.eclipse.persistence.testing.framework.TestEntity;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestExecutor;
import org.eclipse.persistence.testing.framework.TestResultsSummary;
import org.eclipse.persistence.testing.framework.TestSystem;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCaseHelper;
import org.eclipse.persistence.testing.framework.ui.LoadBuildBrowserFrame;
import org.eclipse.persistence.testing.framework.ui.SynchronizedTestExecutor;
import org.eclipse.persistence.testing.framework.ui.SynchronizedTester;
import org.eclipse.persistence.testing.framework.ui.TestEntityTreeModel;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.eclipse.persistence.tools.sessionconsole.SessionConsolePanel;

public class TestingBrowserPanel
extends JPanel
implements ItemListener,
TestListener,
SynchronizedTester {
    protected SynchronizedTestExecutor executionThread;
    protected TestExecutor executor;
    protected Vector models;
    protected Test currentRun;
    private JButton theKillButton = null;
    private JButton theResetButton = null;
    private JButton theRunTestButton = null;
    private SessionConsolePanel theSessionInspectorPanel = null;
    private JButton theSetupButton = null;
    private JButton theStopButton = null;
    private JScrollPane theTestsScrollPane = null;
    private JTree theTestsTree = null;
    private JSplitPane theSplitPane = null;
    private JPanel theTestPanel = null;
    private JToolBar theToolBar = null;
    private JCheckBox theHandleErrorsCheckBox = null;
    private JCheckBox runFastCheckBox = null;
    private JCheckBox logErrorsOnlyCheckBox = null;
    private JComboBox theLoginChoice = null;
    private JLabel theQuickLoginLabel = null;
    private JButton theloadBuildButton = null;
    private JLabel theCurrentTestLabel = null;
    private JTextField theCurrentTestTextField = null;
    private JProgressBar theRunModelProgressBar = null;
    private JProgressBar theRunProgressBar = null;
    private JProgressBar errorsProgressBar = null;
    private JLabel theStatusLabel = null;
    private JLabel theCurrentSuiteLabel = null;
    private JTextField theCurrentSuiteTextField = null;
    private JLabel theRunStatusLabel = null;
    private JLabel errorsLabel = null;
    TestBrowserEventHandler theEventHandler = new TestBrowserEventHandler();

    public TestingBrowserPanel() {
        this.initialize();
    }

    public TestingBrowserPanel(LayoutManager layout) {
        super(layout);
    }

    public TestingBrowserPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public TestingBrowserPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    @Override
    public void finishedTest() {
        this.getStopButton().setEnabled(false);
        this.getKillButton().setEnabled(false);
        if (this.getExecutionThread() != null && this.getExecutionThread().shouldRunSetupOnly()) {
            TreePath path = this.getTestsTree().getSelectionPath();
            this.resetModels();
            this.getTestsTree().setExpandsSelectedPaths(true);
            this.getTestsTree().setSelectionPath(new TreePath(path.getPath()));
            this.getTestsTree().expandPath(path);
            this.getTestsTree().makeVisible(path);
            this.getTestsTree().invalidate();
            this.getTestsTree().validate();
            this.getTestsTree().repaint();
        }
        this.getSessionInspectorPanel().setSession(this.getExecutor().getSession());
        if (this.getExecutor().getSession() != null) {
            while (this.getExecutor().getAbstractSession().isInTransaction()) {
                this.getExecutor().getAbstractSession().rollbackTransaction();
            }
        }
        this.getSessionInspectorPanel().resetDescriptors();
        this.setCurrentRun(null);
        this.getRunProgressBar().setValue(0);
        this.getRunModelProgressBar().setValue(0);
        this.getCurrentTestTextField().setText("");
        this.getCurrentSuiteTextField().setText("");
        this.showNormalCursor();
    }

    public Test getCurrentRun() {
        return this.currentRun;
    }

    private JLabel getCurrentSuiteLabel() {
        if (this.theCurrentSuiteLabel == null) {
            try {
                this.theCurrentSuiteLabel = new JLabel();
                this.theCurrentSuiteLabel.setName("CurrentSuiteLabel");
                this.theCurrentSuiteLabel.setText("Current Suite:");
                this.theCurrentSuiteLabel.setBackground(SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.theCurrentSuiteLabel;
    }

    private JTextField getCurrentSuiteTextField() {
        if (this.theCurrentSuiteTextField == null) {
            try {
                this.theCurrentSuiteTextField = new JTextField();
                this.theCurrentSuiteTextField.setName("CurrentSuiteTextField");
                this.theCurrentSuiteTextField.setBackground(SystemColor.control);
                this.theCurrentSuiteTextField.setEditable(false);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.theCurrentSuiteTextField;
    }

    private JLabel getCurrentTestLabel() {
        if (this.theCurrentTestLabel == null) {
            try {
                this.theCurrentTestLabel = new JLabel();
                this.theCurrentTestLabel.setName("CurrentTestLabel");
                this.theCurrentTestLabel.setText("Current Test:");
                this.theCurrentTestLabel.setBackground(SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.theCurrentTestLabel;
    }

    private JTextField getCurrentTestTextField() {
        if (this.theCurrentTestTextField == null) {
            try {
                this.theCurrentTestTextField = new JTextField();
                this.theCurrentTestTextField.setName("CurrentTestTextField");
                this.theCurrentTestTextField.setBackground(SystemColor.control);
                this.theCurrentTestTextField.setEditable(false);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.theCurrentTestTextField;
    }

    protected SynchronizedTestExecutor getExecutionThread() {
        return this.executionThread;
    }

    public TestExecutor getExecutor() {
        return this.executor;
    }

    private JCheckBox getHandleErrorsCheckBox() {
        if (this.theHandleErrorsCheckBox == null) {
            try {
                this.theHandleErrorsCheckBox = new JCheckBox();
                this.theHandleErrorsCheckBox.setName("HandleErrorsCheckBox");
                this.theHandleErrorsCheckBox.setText("Handle Errors");
                this.theHandleErrorsCheckBox.setBackground(SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.theHandleErrorsCheckBox;
    }

    private JCheckBox getRunFastCheckBox() {
        if (this.runFastCheckBox == null) {
            try {
                this.runFastCheckBox = new JCheckBox();
                this.runFastCheckBox.setName("RunFastCheckBox");
                this.runFastCheckBox.setText("Fast");
                this.runFastCheckBox.setBackground(SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.runFastCheckBox;
    }

    private JCheckBox getLogOnlyErrorsCheckBox() {
        if (this.logErrorsOnlyCheckBox == null) {
            try {
                this.logErrorsOnlyCheckBox = new JCheckBox();
                this.logErrorsOnlyCheckBox.setName("LogErrorsOnlyCheckBox");
                this.logErrorsOnlyCheckBox.setText("Log Errors Only");
                this.logErrorsOnlyCheckBox.setBackground(SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.logErrorsOnlyCheckBox;
    }

    private JButton getKillButton() {
        if (this.theKillButton == null) {
            try {
                this.theKillButton = new JButton();
                this.theKillButton.setName("KillButton");
                this.theKillButton.setText("Kill");
                this.theKillButton.setBackground(SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.theKillButton;
    }

    private JButton getLoadBuildButton() {
        if (this.theloadBuildButton == null) {
            try {
                this.theloadBuildButton = new JButton();
                this.theloadBuildButton.setName("loadBuildButton");
                this.theloadBuildButton.setText("Query Test Results");
                this.theloadBuildButton.setBackground(SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.theloadBuildButton;
    }

    private JComboBox getLoginChoice() {
        if (this.theLoginChoice == null) {
            try {
                this.theLoginChoice = new JComboBox();
                this.theLoginChoice.setName("LoginChoice");
                this.theLoginChoice.setBackground(SystemColor.window);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.theLoginChoice;
    }

    public Vector getModels() {
        return this.models;
    }

    private JLabel getQuickLoginLabel() {
        if (this.theQuickLoginLabel == null) {
            try {
                this.theQuickLoginLabel = new JLabel();
                this.theQuickLoginLabel.setName("QuickLoginLabel");
                this.theQuickLoginLabel.setText("Quick Login:");
                this.theQuickLoginLabel.setBackground(SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.theQuickLoginLabel;
    }

    private JButton getResetButton() {
        if (this.theResetButton == null) {
            try {
                this.theResetButton = new JButton();
                this.theResetButton.setName("ResetButton");
                this.theResetButton.setText("Reset");
                this.theResetButton.setBackground(SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.theResetButton;
    }

    public Container getRoot() {
        Container parent = this;
        while (!(parent instanceof Frame)) {
            if ((parent = parent.getParent()) != null) continue;
            return this;
        }
        return parent;
    }

    private JProgressBar getRunModelProgressBar() {
        if (this.theRunModelProgressBar == null) {
            try {
                this.theRunModelProgressBar = new JProgressBar();
                this.theRunModelProgressBar.setName("RunModelProgressBar");
                this.theRunModelProgressBar.setBackground(SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.theRunModelProgressBar;
    }

    private JProgressBar getRunProgressBar() {
        if (this.theRunProgressBar == null) {
            try {
                this.theRunProgressBar = new JProgressBar();
                this.theRunProgressBar.setName("RunProgressBar");
                this.theRunProgressBar.setBackground(SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.theRunProgressBar;
    }

    private JProgressBar getErrorsProgressBar() {
        if (this.errorsProgressBar == null) {
            try {
                this.errorsProgressBar = new JProgressBar();
                this.errorsProgressBar.setName("ErrorsProgressBar");
                this.errorsProgressBar.setForeground(Color.RED);
                this.errorsProgressBar.setBackground(SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.errorsProgressBar;
    }

    private JLabel getRunStatusLabel() {
        if (this.theRunStatusLabel == null) {
            try {
                this.theRunStatusLabel = new JLabel();
                this.theRunStatusLabel.setName("RunStatusLabel");
                this.theRunStatusLabel.setText("Run Status:");
                this.theRunStatusLabel.setBackground(SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.theRunStatusLabel;
    }

    private JLabel getErrorsLabel() {
        if (this.errorsLabel == null) {
            try {
                this.errorsLabel = new JLabel();
                this.errorsLabel.setName("RrrorsLabel");
                this.errorsLabel.setText("Errors:");
                this.errorsLabel.setBackground(SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.errorsLabel;
    }

    private JButton getRunTestButton() {
        if (this.theRunTestButton == null) {
            try {
                this.theRunTestButton = new JButton();
                this.theRunTestButton.setName("RunTestButton");
                this.theRunTestButton.setText("Run Test");
                this.theRunTestButton.setBackground(SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.theRunTestButton;
    }

    public Test getSelectedTest() {
        return (Test)this.getTestsTree().getSelectionPath().getLastPathComponent();
    }

    public TestEntity getSelectedEntity() {
        Test test = this.getSelectedTest();
        if (!(test instanceof TestEntity)) {
            return null;
        }
        return (TestEntity)test;
    }

    private SessionConsolePanel getSessionInspectorPanel() {
        if (this.theSessionInspectorPanel == null) {
            try {
                this.theSessionInspectorPanel = new SessionConsolePanel();
                this.theSessionInspectorPanel.setName("SessionInspectorPanel");
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.theSessionInspectorPanel;
    }

    private JButton getSetupButton() {
        if (this.theSetupButton == null) {
            try {
                this.theSetupButton = new JButton();
                this.theSetupButton.setName("SetupButton");
                this.theSetupButton.setText("Setup");
                this.theSetupButton.setBackground(SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.theSetupButton;
    }

    private JSplitPane getSplitPane() {
        if (this.theSplitPane == null) {
            try {
                this.theSplitPane = new JSplitPane(1);
                this.theSplitPane.setName("SplitPane");
                this.theSplitPane.setDividerSize(8);
                this.theSplitPane.setOneTouchExpandable(true);
                this.theSplitPane.setDividerLocation(200);
                this.getSplitPane().add((Component)this.getSessionInspectorPanel(), "right");
                this.getSplitPane().add((Component)this.getTestPanel(), "left");
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.theSplitPane;
    }

    private JLabel getStatusLabel() {
        if (this.theStatusLabel == null) {
            try {
                this.theStatusLabel = new JLabel();
                this.theStatusLabel.setName("StatusLabel");
                this.theStatusLabel.setText("Suite Status:");
                this.theStatusLabel.setBackground(SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.theStatusLabel;
    }

    private JButton getStopButton() {
        if (this.theStopButton == null) {
            try {
                this.theStopButton = new JButton();
                this.theStopButton.setName("StopButton");
                this.theStopButton.setText("Stop");
                this.theStopButton.setBackground(SystemColor.control);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.theStopButton;
    }

    private JPanel getTestPanel() {
        if (this.theTestPanel == null) {
            try {
                this.theTestPanel = new JPanel();
                this.theTestPanel.setName("TestPanel");
                this.theTestPanel.setLayout(new GridBagLayout());
                this.theTestPanel.setBackground(SystemColor.control);
                this.theTestPanel.setPreferredSize(new Dimension(300, 0));
                GridBagConstraints constraintsHandleErrorsCheckBox = new GridBagConstraints();
                constraintsHandleErrorsCheckBox.gridx = 0;
                constraintsHandleErrorsCheckBox.gridy = 7;
                constraintsHandleErrorsCheckBox.anchor = 17;
                constraintsHandleErrorsCheckBox.insets = new Insets(0, 2, 0, 0);
                this.getTestPanel().add((Component)this.getHandleErrorsCheckBox(), constraintsHandleErrorsCheckBox);
                GridBagConstraints constraintsRunFastCheckBox = new GridBagConstraints();
                constraintsRunFastCheckBox.gridx = 0;
                constraintsRunFastCheckBox.gridy = 8;
                constraintsRunFastCheckBox.anchor = 17;
                constraintsRunFastCheckBox.insets = new Insets(0, 2, 0, 0);
                this.getTestPanel().add((Component)this.getRunFastCheckBox(), constraintsRunFastCheckBox);
                GridBagConstraints constraintsLogOnlyErrorsCheckBox = new GridBagConstraints();
                constraintsLogOnlyErrorsCheckBox.gridx = 0;
                constraintsLogOnlyErrorsCheckBox.gridy = 9;
                constraintsLogOnlyErrorsCheckBox.anchor = 17;
                constraintsLogOnlyErrorsCheckBox.insets = new Insets(0, 2, 0, 0);
                this.getTestPanel().add((Component)this.getLogOnlyErrorsCheckBox(), constraintsLogOnlyErrorsCheckBox);
                GridBagConstraints constraintsTestsScrollPane = new GridBagConstraints();
                constraintsTestsScrollPane.gridx = 0;
                constraintsTestsScrollPane.gridy = 0;
                constraintsTestsScrollPane.gridwidth = 2;
                constraintsTestsScrollPane.fill = 1;
                constraintsTestsScrollPane.weightx = 1.0;
                constraintsTestsScrollPane.weighty = 1.0;
                this.getTestPanel().add((Component)this.getTestsScrollPane(), constraintsTestsScrollPane);
                GridBagConstraints constraintsRunProgressBar = new GridBagConstraints();
                constraintsRunProgressBar.gridx = 1;
                constraintsRunProgressBar.gridy = 1;
                constraintsRunProgressBar.gridwidth = 2;
                constraintsRunProgressBar.fill = 2;
                constraintsRunProgressBar.insets = new Insets(2, 2, 2, 2);
                this.getTestPanel().add((Component)this.getRunProgressBar(), constraintsRunProgressBar);
                GridBagConstraints constraintsQuickLoginLabel = new GridBagConstraints();
                constraintsQuickLoginLabel.gridx = 0;
                constraintsQuickLoginLabel.gridy = 6;
                constraintsQuickLoginLabel.anchor = 17;
                constraintsQuickLoginLabel.insets = new Insets(0, 7, 0, 2);
                this.getTestPanel().add((Component)this.getQuickLoginLabel(), constraintsQuickLoginLabel);
                GridBagConstraints constraintsLoginChoice = new GridBagConstraints();
                constraintsLoginChoice.gridx = 1;
                constraintsLoginChoice.gridy = 6;
                constraintsLoginChoice.fill = 2;
                constraintsLoginChoice.insets = new Insets(2, 2, 2, 2);
                this.getTestPanel().add((Component)this.getLoginChoice(), constraintsLoginChoice);
                GridBagConstraints constraintsRunModelProgressBar = new GridBagConstraints();
                constraintsRunModelProgressBar.gridx = 1;
                constraintsRunModelProgressBar.gridy = 4;
                constraintsRunModelProgressBar.gridwidth = 2;
                constraintsRunModelProgressBar.fill = 2;
                constraintsRunModelProgressBar.insets = new Insets(0, 2, 0, 2);
                this.getTestPanel().add((Component)this.getRunModelProgressBar(), constraintsRunModelProgressBar);
                GridBagConstraints constraintsErrorsLabel = new GridBagConstraints();
                constraintsErrorsLabel.gridx = 0;
                constraintsErrorsLabel.gridy = 2;
                constraintsErrorsLabel.anchor = 17;
                constraintsErrorsLabel.insets = new Insets(0, 7, 0, 2);
                this.getTestPanel().add((Component)this.getErrorsLabel(), constraintsErrorsLabel);
                GridBagConstraints constraintsErrorsProgressBar = new GridBagConstraints();
                constraintsErrorsProgressBar.gridx = 1;
                constraintsErrorsProgressBar.gridy = 2;
                constraintsErrorsProgressBar.gridwidth = 2;
                constraintsErrorsProgressBar.fill = 2;
                constraintsErrorsProgressBar.insets = new Insets(0, 3, 0, 2);
                this.getTestPanel().add((Component)this.getErrorsProgressBar(), constraintsErrorsProgressBar);
                GridBagConstraints constraintsStatusLabel = new GridBagConstraints();
                constraintsStatusLabel.gridx = 0;
                constraintsStatusLabel.gridy = 4;
                constraintsStatusLabel.anchor = 17;
                constraintsStatusLabel.insets = new Insets(0, 7, 0, 2);
                this.getTestPanel().add((Component)this.getStatusLabel(), constraintsStatusLabel);
                GridBagConstraints constraintsCurrentTestLabel = new GridBagConstraints();
                constraintsCurrentTestLabel.gridx = 0;
                constraintsCurrentTestLabel.gridy = 5;
                constraintsCurrentTestLabel.anchor = 17;
                constraintsCurrentTestLabel.insets = new Insets(0, 7, 0, 2);
                this.getTestPanel().add((Component)this.getCurrentTestLabel(), constraintsCurrentTestLabel);
                GridBagConstraints constraintsCurrentTestTextField = new GridBagConstraints();
                constraintsCurrentTestTextField.gridx = 1;
                constraintsCurrentTestTextField.gridy = 5;
                constraintsCurrentTestTextField.fill = 2;
                constraintsCurrentTestTextField.insets = new Insets(2, 2, 2, 2);
                this.getTestPanel().add((Component)this.getCurrentTestTextField(), constraintsCurrentTestTextField);
                GridBagConstraints constraintsRunStatusLabel = new GridBagConstraints();
                constraintsRunStatusLabel.gridx = 0;
                constraintsRunStatusLabel.gridy = 1;
                constraintsRunStatusLabel.anchor = 17;
                constraintsRunStatusLabel.insets = new Insets(0, 7, 0, 2);
                this.getTestPanel().add((Component)this.getRunStatusLabel(), constraintsRunStatusLabel);
                GridBagConstraints constraintsCurrentSuiteLabel = new GridBagConstraints();
                constraintsCurrentSuiteLabel.gridx = 0;
                constraintsCurrentSuiteLabel.gridy = 3;
                constraintsCurrentSuiteLabel.anchor = 17;
                constraintsCurrentSuiteLabel.insets = new Insets(0, 7, 0, 2);
                this.getTestPanel().add((Component)this.getCurrentSuiteLabel(), constraintsCurrentSuiteLabel);
                GridBagConstraints constraintsCurrentSuiteTextField = new GridBagConstraints();
                constraintsCurrentSuiteTextField.gridx = 1;
                constraintsCurrentSuiteTextField.gridy = 3;
                constraintsCurrentSuiteTextField.fill = 2;
                constraintsCurrentSuiteTextField.insets = new Insets(2, 2, 2, 2);
                this.getTestPanel().add((Component)this.getCurrentSuiteTextField(), constraintsCurrentSuiteTextField);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.theTestPanel;
    }

    private JScrollPane getTestsScrollPane() {
        if (this.theTestsScrollPane == null) {
            try {
                this.theTestsScrollPane = new JScrollPane();
                this.theTestsScrollPane.setName("TestsScrollPane");
                this.theTestsScrollPane.setMinimumSize(new Dimension(0, 0));
                this.theTestsScrollPane.setMaximumSize(new Dimension(0, 0));
                this.getTestsScrollPane().setViewportView(this.getTestsTree());
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.theTestsScrollPane;
    }

    private JTree getTestsTree() {
        if (this.theTestsTree == null) {
            try {
                this.theTestsTree = new JTree();
                this.theTestsTree.setName("TestsTree");
                this.theTestsTree.setBounds(0, 0, 76, 36);
                this.theTestsTree.setMaximumSize(new Dimension(0, 0));
                this.theTestsTree.setRootVisible(false);
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.theTestsTree;
    }

    private JToolBar getToolBar() {
        if (this.theToolBar == null) {
            try {
                this.theToolBar = new JToolBar();
                this.theToolBar.setName("ToolBar");
                this.theToolBar.setBackground(SystemColor.control);
                this.theToolBar.add(this.getRunTestButton());
                this.theToolBar.addSeparator();
                this.theToolBar.add(this.getSetupButton());
                this.theToolBar.addSeparator();
                this.theToolBar.add(this.getResetButton());
                this.theToolBar.addSeparator();
                this.theToolBar.add(this.getStopButton());
                this.theToolBar.addSeparator();
                this.theToolBar.add(this.getKillButton());
                this.theToolBar.addSeparator();
                this.getToolBar().add((Component)this.getLoadBuildButton(), this.getLoadBuildButton().getName());
            }
            catch (Throwable exception) {
                this.handleException(exception);
            }
        }
        return this.theToolBar;
    }

    public void handleErrorsChanged() {
        this.getExecutor().setShouldHandleErrors(this.getHandleErrorsCheckBox().isSelected());
    }

    public void runFastChanged() {
        SchemaManager.FAST_TABLE_CREATOR = this.getRunFastCheckBox().isSelected();
    }

    public void logOnlyErrorsChanged() {
        this.getExecutor().setShouldLogOnlyErrors(this.getLogOnlyErrorsCheckBox().isSelected());
    }

    private void handleException(Throwable exception) {
        try {
            this.getExecutor().getLog().write("--------- UNCAUGHT EXCEPTION ---------" + Helper.cr());
            exception.printStackTrace(new PrintWriter(this.getExecutor().getLog()));
            this.getExecutor().getLog().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void initConnections() throws Exception {
        this.getRunTestButton().addActionListener(this.theEventHandler);
        this.getSetupButton().addActionListener(this.theEventHandler);
        this.getStopButton().addActionListener(this.theEventHandler);
        this.getKillButton().addActionListener(this.theEventHandler);
        this.getHandleErrorsCheckBox().addItemListener(this.theEventHandler);
        this.getRunFastCheckBox().addItemListener(this.theEventHandler);
        this.getLogOnlyErrorsCheckBox().addItemListener(this.theEventHandler);
        this.getLoginChoice().addItemListener(this.theEventHandler);
        this.getResetButton().addActionListener(this.theEventHandler);
        this.getLoadBuildButton().addActionListener(this.theEventHandler);
    }

    private void initialize() {
        try {
            this.setName("TestingBrowserPanel");
            this.setLayout(new GridBagLayout());
            this.setBackground(SystemColor.control);
            this.setSize(708, 524);
            GridBagConstraints constraintsToolBar = new GridBagConstraints();
            constraintsToolBar.gridx = 0;
            constraintsToolBar.gridy = 0;
            constraintsToolBar.gridwidth = 3;
            constraintsToolBar.fill = 1;
            constraintsToolBar.weightx = 1.0;
            this.add((Component)this.getToolBar(), constraintsToolBar);
            GridBagConstraints constraintsSplitPane = new GridBagConstraints();
            constraintsSplitPane.gridx = 0;
            constraintsSplitPane.gridy = 1;
            constraintsSplitPane.fill = 1;
            constraintsSplitPane.weightx = 1.0;
            constraintsSplitPane.weighty = 1.0;
            this.add((Component)this.getSplitPane(), constraintsSplitPane);
            this.initConnections();
        }
        catch (Throwable exception) {
            this.handleException(exception);
        }
        this.setup();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        try {
            if (e.getSource() == this.getHandleErrorsCheckBox()) {
                this.handleErrorsChanged();
            }
            if (e.getSource() == this.getRunFastCheckBox()) {
                this.runFastChanged();
            }
            if (e.getSource() == this.getLogOnlyErrorsCheckBox()) {
                this.logOnlyErrorsChanged();
            }
            if (e.getSource() == this.getLoginChoice()) {
                this.loginChanged();
            }
        }
        catch (Throwable exception) {
            this.handleException(exception);
        }
    }

    public void killTest() {
        if (this.getExecutionThread() != null) {
            this.getExecutionThread().stop();
            this.setExecutionThread(null);
        }
        this.finishedTest();
        this.getExecutor().getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void loginChanged() {
        TestSystem system = new TestSystem();
        String platform = (String)this.getLoginChoice().getSelectedItem();
        if (platform.equals("Last Login Used")) {
            try {
                this.getSessionInspectorPanel().loadLoginFromFile();
                system.setLogin(this.getSessionInspectorPanel().getLoginEditor().getLogin());
            }
            catch (Throwable error) {}
        } else if (platform.equals("Local Oracle DB (thin)")) {
            system.useOracleThin("localhost:1521:orcl", "scott", "tiger");
        } else if (platform.equals("Oracle 11gR2 (thin)")) {
            system.useOracleThin("ottvm030.ca.oracle.com:1521:TOPLINK", "", "password");
        } else if (platform.equals("Oracle 11gR1 (thin)")) {
            system.useOracleThin("ottvm028.ca.oracle.com:1521:TOPLINK", "", "password");
        } else if (platform.equals("Oracle 11gR1 - Austin (thin)")) {
            system.useOracleThin("adc6160375.us.oracle.com:1521:TOPLINK", "", "password");
        } else if (platform.equals("Oracle (OCI)")) {
            system.useOracleOCI();
        } else if (platform.equals("TimesTen - coredev1")) {
            system.useTimesTen("coredev1");
        } else if (platform.equals("TimesTen - coredev2")) {
            system.useTimesTen("coredev2");
        } else if (platform.equals("DB2 (App)")) {
            system.useDB2App();
        } else if (platform.equals("DB2 (Net)")) {
            system.useDB2Net();
        } else if (platform.equals("DB2 (Universal Driver)")) {
            system.useDB2UniversalDriver();
        } else if (platform.equals("DB2 (DataDirect)")) {
            system.useDB2DataDirect();
        } else if (platform.equals("Derby")) {
            system.useDerby();
        } else if (platform.equals("H2")) {
            system.useH2();
        } else if (platform.equals("HSQL")) {
            system.useHSQL();
        } else if (platform.equals("PostgreSQL")) {
            system.usePostgres();
        } else if (platform.equals("Informix IDS 11.1")) {
            system.useInformix11();
        } else if (platform.equals("Sybase (JConnect)")) {
            system.useSybaseJConnect();
        } else if (platform.equals("Sybase (DataDirect)")) {
            system.useSybaseDataDirect();
        } else if (platform.equals("MySQL (Connector/J) - COREDEV1")) {
            system.useMySQL("qa3");
        } else if (platform.equals("MySQL (Connector/J) - COREDEV2")) {
            system.useMySQL("qa4");
        } else if (platform.equals("SQLServer (Weblogic Thin)")) {
            system.useSQLServerWeblogicThin();
        } else if (platform.equals("SQLServer (MS JDBC)")) {
            system.useSQLServerMSJDBC();
        } else if (platform.equals("SQLServer (DataDirect)")) {
            system.useSQLServerDataDirect();
        } else if (platform.equals("MS Access (JDBCODBC)")) {
            system.useAccessJDBCODBC();
        } else if (platform.equals("Symfoware (RDB2_TCP)")) {
            system.useSymfowareRDB2_TCP();
        }
        DatabaseLogin login = system.getLogin();
        this.getExecutor().getAbstractSession().setLogin(login);
        this.getSessionInspectorPanel().getLoginEditor().setLogin(login);
        if (LoadBuildSystem.loadBuild == null) {
            return;
        }
        if (this.getExecutor().getSession().getLogin().getConnector() instanceof DefaultConnector) {
            LoadBuildSystem.loadBuild.loginChoice = login.getConnectionString();
        }
        LoadBuildSystem.loadBuild.databaseLogin = this.getSessionInspectorPanel().getSession().getProject().getLogin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logTestResults() {
        if (this.getExecutionThread() != null) {
            this.showBusyCursor();
            try {
                this.getExecutor().logResultForTestEntity(this.getExecutionThread().getTest());
            }
            finally {
                this.showNormalCursor();
            }
        }
    }

    @Override
    public void notifyException(Throwable exception) {
        try {
            this.getExecutor().getLog().write("--------- UNCAUGHT EXCEPTION ---------" + Helper.cr());
            exception.printStackTrace(new PrintWriter(this.getExecutor().getLog()));
            this.getExecutor().getLog().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void queryLoadBuild() {
        LoadBuildBrowserFrame loadBuildBrowser = new LoadBuildBrowserFrame();
        loadBuildBrowser.setVisible(true);
        loadBuildBrowser.repaint();
    }

    public void refreshButtons() {
        boolean isLoggedIn = this.getExecutor().getSession() != null && this.getExecutor().getSession().isConnected();
        TestEntity entity = this.getSelectedEntity();
        if (isLoggedIn || entity == null || !entity.requiresDatabase()) {
            this.getSetupButton().setEnabled(true);
            this.getResetButton().setEnabled(true);
            this.getRunTestButton().setEnabled(true);
        } else {
            this.getSetupButton().setEnabled(false);
            this.getResetButton().setEnabled(false);
            this.getRunTestButton().setEnabled(false);
        }
        if (isLoggedIn) {
            this.getLoginChoice().setEnabled(false);
        } else {
            this.getLoginChoice().setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshModels() {
        this.showBusyCursor();
        try {
            this.setupDefaultModels();
            this.resetModels();
            this.getExecutor().initializeConfiguredSystems();
            this.getExecutor().resetLoadedModels();
            this.getExecutor().addLoadedModels(this.getModels());
        }
        finally {
            this.showNormalCursor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTests() {
        this.showBusyCursor();
        try {
            this.setupDefaultModels();
            this.resetModels();
            this.getExecutor().resetLoadedModels();
            this.getExecutor().addLoadedModels(this.getModels());
        }
        finally {
            this.showNormalCursor();
        }
    }

    public void resetLogin() {
        this.getLoginChoice().addItem("Last Login Used");
        this.getLoginChoice().addItem("Local Oracle DB (thin)");
        this.getLoginChoice().addItem("Oracle 11gR2 (thin)");
        this.getLoginChoice().addItem("Oracle 11gR1 (thin)");
        this.getLoginChoice().addItem("Oracle 11gR1 - Austin (thin)");
        this.getLoginChoice().addItem("Oracle (OCI)");
        this.getLoginChoice().addItem("TimesTen - coredev1");
        this.getLoginChoice().addItem("TimesTen - coredev2");
        this.getLoginChoice().addItem("DB2 (App)");
        this.getLoginChoice().addItem("DB2 (Net)");
        this.getLoginChoice().addItem("DB2 (Universal Driver)");
        this.getLoginChoice().addItem("DB2 (DataDirect)");
        this.getLoginChoice().addItem("Derby");
        this.getLoginChoice().addItem("HSQL");
        this.getLoginChoice().addItem("H2");
        this.getLoginChoice().addItem("PostgreSQL");
        this.getLoginChoice().addItem("Informix IDS 11.1");
        this.getLoginChoice().addItem("Sybase (JConnect)");
        this.getLoginChoice().addItem("Sybase (DataDirect)");
        this.getLoginChoice().addItem("MySQL (Connector/J) - COREDEV1");
        this.getLoginChoice().addItem("MySQL (Connector/J) - COREDEV2");
        this.getLoginChoice().addItem("SQLServer (DataDirect)");
        this.getLoginChoice().addItem("SQLServer (MS JDBC)");
        this.getLoginChoice().addItem("SQLServer (Weblogic Thin)");
        this.getLoginChoice().addItem("Symfoware (RDB2_TCP)");
        this.loginChanged();
    }

    public void resetModels() {
        TestEntityTreeModel model = new TestEntityTreeModel(this.getModels());
        this.getTestsTree().setModel(model);
        this.getTestsTree().repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetTest() {
        this.showBusyCursor();
        try {
            TestEntity test = this.getSelectedEntity();
            if (test == null || !(test instanceof TestCollection)) {
                return;
            }
            test.resetEntity();
            this.resetModels();
            this.getSessionInspectorPanel().setSession(this.getExecutor().getSession());
        }
        finally {
            this.showNormalCursor();
        }
    }

    public void runTest() {
        this.showBusyCursor();
        Test test = this.getSelectedTest();
        if (test == null) {
            return;
        }
        try {
            if (this.getExecutor().getSession().getDatasourceLogin() instanceof DatabaseLogin && this.getExecutor().getSession().getLogin().getConnector() instanceof DefaultConnector) {
                LoadBuildSystem.loadBuild.loginChoice = this.getExecutor().getSession().getLogin().getConnectionString();
            }
        }
        catch (Exception isDatasourceLogin) {
            // empty catch block
        }
        Map<String, String> properties = JUnitTestCaseHelper.getDatabaseProperties();
        if (this.getExecutor().getSession().getDatasourceLogin() instanceof DatabaseLogin && this.getExecutor().getSession().getLogin().getConnector() instanceof DefaultConnector) {
            properties.put("javax.persistence.jdbc.driver", this.getExecutor().getSession().getLogin().getDriverClassName());
            properties.put("javax.persistence.jdbc.url", this.getExecutor().getSession().getLogin().getConnectionString());
            properties.put("eclipselink.target-database", this.getExecutor().getSession().getDatasourceLogin().getPlatform().getClass().getName());
            properties.put("javax.persistence.jdbc.user", this.getExecutor().getSession().getDatasourceLogin().getUserName());
            properties.put("javax.persistence.jdbc.password", this.getExecutor().getSession().getDatasourceLogin().getPassword());
            properties.put("eclipselink.logging.level", this.getExecutor().getSession().getSessionLog().getLevelString());
            for (Map map : JUnitTestCaseHelper.puPropertiesMap.values()) {
                if (!map.containsKey("eclipselink.logging.level")) continue;
                map.put("eclipselink.logging.level", this.getExecutor().getSession().getSessionLog().getLevelString());
            }
        }
        TestExecutor.setDefaultJUnitTestResult(null);
        TestExecutor.setJUnitTestResults(null);
        this.setExecutionThread(new SynchronizedTestExecutor(this.getExecutor(), test, this));
        this.getExecutionThread().start();
        this.getStopButton().setEnabled(true);
        this.getKillButton().setEnabled(true);
    }

    public void saveLoadBuild() {
        if (LoadBuildSystem.loadBuild == null || LoadBuildSystem.loadBuild.isEmpty()) {
            return;
        }
        this.showBusyCursor();
        LoadBuildSystem loadBuildSystem = new LoadBuildSystem();
        loadBuildSystem.saveLoadBuild();
        this.showNormalCursor();
    }

    public void setCurrentRun(Test currentRun) {
        this.currentRun = currentRun;
    }

    protected void setExecutionThread(SynchronizedTestExecutor thread) {
        this.executionThread = thread;
    }

    public void setExecutor(TestExecutor executor) {
        this.executor = executor;
    }

    public void setModels(Vector models) {
        this.models = models;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup() {
        this.showBusyCursor();
        try {
            DatabaseSession session = new Project(new DatabaseLogin()).createDatabaseSession();
            this.setExecutor(new TestExecutor());
            this.getExecutor().setListener(this);
            this.getExecutor().setSession((Session)session);
            this.getSessionInspectorPanel().setSession((Session)session);
            this.setupDefaultModels();
            this.resetModels();
            this.resetLogin();
            this.handleErrorsChanged();
            this.loginChanged();
            this.getLogOnlyErrorsCheckBox().setSelected(true);
        }
        finally {
            this.showNormalCursor();
        }
    }

    public void setupDefaultModels() {
        Vector allModels = new Vector();
        try {
            Class<?> testModelClass = Class.forName("org.eclipse.persistence.testing.tests.TestRunModel");
            Method buildTestsMethod = testModelClass.getMethod("buildAllModels", new Class[0]);
            Vector result = (Vector)buildTestsMethod.invoke(null, new Object[0]);
            Helper.addAllToVector(allModels, (Vector)result);
        }
        catch (Exception exception) {
            System.out.println("Problems loading BasicTestModel " + exception.toString());
            exception.printStackTrace();
        }
        this.setModels(allModels);
    }

    public void setupTest() {
        this.showBusyCursor();
        TestEntity entity = this.getSelectedEntity();
        if (entity == null || !(entity instanceof TestCollection)) {
            this.showNormalCursor();
            return;
        }
        TestCollection test = (TestCollection)entity;
        test.setExecutor(this.getExecutor());
        this.setExecutionThread(new SynchronizedTestExecutor(this.getExecutor(), test, this));
        this.getExecutionThread().setShouldRunSetupOnly(true);
        this.getExecutionThread().start();
        this.getStopButton().setEnabled(true);
        this.getKillButton().setEnabled(true);
    }

    public void showBusyCursor() {
        for (Container parent = this; parent != null; parent = parent.getParent()) {
            parent.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public void showNormalCursor() {
        for (Container parent = this; parent != null; parent = parent.getParent()) {
            parent.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void stopTest() {
        if (this.getExecutionThread() != null) {
            this.getExecutionThread().stopExecution();
        } else {
            this.finishedTest();
        }
    }

    public void addError(Test test, Throwable error) {
        if (!this.getExecutor().shouldHandleErrors()) {
            throw new TestErrorException(error.getMessage(), error);
        }
        this.getErrorsProgressBar().setValue(this.getErrorsProgressBar().getValue() + 1);
        if (this.getErrorsProgressBar().getValue() >= this.getErrorsProgressBar().getMaximum()) {
            this.getErrorsProgressBar().setMaximum(this.getErrorsProgressBar().getMaximum() * 2);
        }
    }

    public void addFailure(Test test, AssertionFailedError error) {
        if (!this.getExecutor().shouldHandleErrors()) {
            throw new TestErrorException(error.getMessage(), (Throwable)error);
        }
        this.getErrorsProgressBar().setValue(this.getErrorsProgressBar().getValue() + 1);
        if (this.getErrorsProgressBar().getValue() >= this.getErrorsProgressBar().getMaximum()) {
            this.getErrorsProgressBar().setMaximum(this.getErrorsProgressBar().getMaximum() * 2);
        }
    }

    public void endTest(Test test) {
        this.getRunModelProgressBar().setValue(this.getRunModelProgressBar().getValue() + 1);
        if (test instanceof TestEntity) {
            TestEntity testEntity = (TestEntity)test;
            if (testEntity instanceof TestCase && ((TestCase)testEntity).getTestResult().hasFailed()) {
                this.getErrorsProgressBar().setValue(this.getErrorsProgressBar().getValue() + 1);
            } else if (testEntity instanceof TestCollection && ((TestResultsSummary)testEntity.getReport()).didSetupFail()) {
                this.getErrorsProgressBar().setValue(this.getErrorsProgressBar().getValue() + 1);
            }
            if (this.getErrorsProgressBar().getValue() >= this.getErrorsProgressBar().getMaximum()) {
                this.getErrorsProgressBar().setMaximum(this.getErrorsProgressBar().getMaximum() * 2);
            }
            if (testEntity.getContainer() == this.getCurrentRun()) {
                this.getRunProgressBar().setMaximum(((TestCollection)testEntity.getContainer()).getTests().size());
                this.getRunProgressBar().setValue(this.getRunProgressBar().getValue() + 1);
            }
        }
        this.getSessionInspectorPanel().setSession(this.getExecutor().getSession());
    }

    public void startTest(Test test) {
        if (test instanceof TestSuite) {
            TestSuite suite = (TestSuite)test;
            this.getRunModelProgressBar().setValue(0);
            this.getRunModelProgressBar().setMaximum(suite.countTestCases());
            this.getCurrentSuiteTextField().setText(suite.getName());
            if (this.getCurrentRun() == null) {
                this.setCurrentRun(test);
                this.getRunProgressBar().setValue(0);
                this.getRunProgressBar().setMaximum(suite.countTestCases());
                this.getErrorsProgressBar().setMaximum(10);
                this.getErrorsProgressBar().setValue(0);
            }
            this.getCurrentTestTextField().setText(suite.getName());
        } else if (test instanceof junit.framework.TestCase) {
            this.getCurrentTestTextField().setText(((junit.framework.TestCase)test).getName());
            if (!(test instanceof TestEntity)) {
                this.getCurrentSuiteTextField().setText(Helper.getShortClassName(test.getClass()));
            }
        }
    }

    class TestBrowserEventHandler
    implements ActionListener,
    ItemListener {
        TestBrowserEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (e.getSource() == TestingBrowserPanel.this.getRunTestButton()) {
                    TestingBrowserPanel.this.runTest();
                }
                if (e.getSource() == TestingBrowserPanel.this.getSetupButton()) {
                    TestingBrowserPanel.this.setupTest();
                }
                if (e.getSource() == TestingBrowserPanel.this.getStopButton()) {
                    TestingBrowserPanel.this.stopTest();
                }
                if (e.getSource() == TestingBrowserPanel.this.getKillButton()) {
                    TestingBrowserPanel.this.killTest();
                }
                if (e.getSource() == TestingBrowserPanel.this.getResetButton()) {
                    TestingBrowserPanel.this.resetTest();
                }
                if (e.getSource() == TestingBrowserPanel.this.getLoadBuildButton()) {
                    TestingBrowserPanel.this.queryLoadBuild();
                }
            }
            catch (Throwable exception) {
                TestingBrowserPanel.this.handleException(exception);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            try {
                if (e.getSource() == TestingBrowserPanel.this.getHandleErrorsCheckBox()) {
                    TestingBrowserPanel.this.handleErrorsChanged();
                }
                if (e.getSource() == TestingBrowserPanel.this.getRunFastCheckBox()) {
                    TestingBrowserPanel.this.runFastChanged();
                }
                if (e.getSource() == TestingBrowserPanel.this.getLogOnlyErrorsCheckBox()) {
                    TestingBrowserPanel.this.logOnlyErrorsChanged();
                }
                if (e.getSource() == TestingBrowserPanel.this.getLoginChoice()) {
                    TestingBrowserPanel.this.loginChanged();
                }
            }
            catch (Throwable exception) {
                TestingBrowserPanel.this.handleException(exception);
            }
        }
    }
}

